/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class ClassSerializer
extends SimpleTypeSerializer<Class> {
    public ClassSerializer() {
        super(DataType.CLASS);
    }

    @Override
    protected Class readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        String name = context.readValue(buffer, String.class, false);
        try {
            return Class.forName(name);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void writeValue(Class value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue(value.getName(), buffer, false);
    }
}

