/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.data.rules.utils;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.ReportFileModel;
import org.jboss.windup.reporting.model.source.SourceReportModel;
import org.jboss.windup.reporting.service.SourceReportService;
import org.jboss.windup.rules.apps.java.service.JavaClassService;

public class DataUtils {
    public static final Function<Optional<ReportFileModel>, String> FILE_ID_MAPPER = reportFileModel -> reportFileModel.map(f -> f.getId().toString()).orElse(null);

    public static Optional<ReportFileModel> getSourceFile(JavaClassService javaClassService, SourceReportService sourceReportService, String classQualifiedName) {
        return StreamSupport.stream(javaClassService.getJavaSource(classQualifiedName).spliterator(), false).map(arg_0 -> ((SourceReportService)sourceReportService).getSourceReportForFileModel(arg_0)).filter(Objects::nonNull).map(SourceReportModel::getSourceFileModel).findFirst();
    }

    public static String getSourceFileId(JavaClassService javaClassService, SourceReportService sourceReportService, String classQualifiedName) {
        Optional<ReportFileModel> sourceFile = DataUtils.getSourceFile(javaClassService, sourceReportService, classQualifiedName);
        return FILE_ID_MAPPER.apply(sourceFile);
    }

    public static Optional<ReportFileModel> getSourceFile(SourceReportService sourceReportService, FileModel fileModel) {
        SourceReportModel sourceReportForFileModel = sourceReportService.getSourceReportForFileModel(fileModel);
        if (sourceReportForFileModel != null) {
            return Optional.ofNullable(sourceReportForFileModel.getSourceFileModel());
        }
        return Optional.empty();
    }

    public static String getSourceFileId(SourceReportService sourceReportService, FileModel fileModel) {
        Optional<ReportFileModel> sourceFile = DataUtils.getSourceFile(sourceReportService, fileModel);
        return FILE_ID_MAPPER.apply(sourceFile);
    }

    public static String sanitizeFilename(String id) {
        String sanitizer = "_";
        return id.replaceAll("\\\\", "_").replaceAll("/", "_").replaceAll(":", "_").replaceAll("\\*", "_").replaceAll("\"", "_").replaceAll("<", "_").replaceAll(">", "_").replaceAll("\\|", "_");
    }
}

