/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.data.rules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.util.AddonFilters;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.PostReportPfRenderingPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.util.ZipUtil;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=PostReportPfRenderingPhase.class, haltOnException=true)
public class UIRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logger.getLogger(UIRuleProvider.class);
    private static final String UI_ZIP_FILENAME = "pf-windup-ui.zip";
    private static final String THEME_JS_FILENAME = "theme.js";
    @Inject
    private Furnace furnace;

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                UIRuleProvider.this.performProcess(event);
            }
        });
    }

    private void performProcess(GraphRewrite event) {
        block20: {
            GraphContext context = event.getGraphContext();
            ReportService reportService = new ReportService(context);
            Path uiDirectory = reportService.getWindupUIDirectory();
            Path uiApiDirectory = reportService.getWindupUIApiDirectory();
            try {
                Addon addon;
                FileUtils.forceMkdir((File)uiDirectory.toFile());
                InputStream uiZipInputStream = null;
                Iterator iterator = this.furnace.getAddonRegistry(new AddonRepository[0]).getAddons(AddonFilters.allLoaded()).iterator();
                while (iterator.hasNext() && (uiZipInputStream = (addon = (Addon)iterator.next()).getClassLoader().getResourceAsStream(UI_ZIP_FILENAME)) == null) {
                }
                if (uiZipInputStream == null) {
                    throw new IllegalStateException("Could not find UI");
                }
                Files.copy(uiZipInputStream, uiDirectory.resolve(UI_ZIP_FILENAME), new CopyOption[0]);
                File uiZipFile = uiDirectory.resolve(UI_ZIP_FILENAME).toFile();
                ZipUtil.unzipToFolder((File)uiZipFile, (File)uiDirectory.toFile());
                Path sourceWindupJS = uiApiDirectory.resolve("windup.js");
                Path targetWindupJS = uiDirectory.resolve("windup.js");
                Files.delete(targetWindupJS);
                Files.copy(sourceWindupJS, targetWindupJS, new CopyOption[0]);
                Files.delete(sourceWindupJS);
                Files.delete(uiDirectory.resolve(UI_ZIP_FILENAME));
                try (InputStream themeJSInputStream = UIRuleProvider.class.getClassLoader().getResourceAsStream(THEME_JS_FILENAME);){
                    if (themeJSInputStream == null) {
                        try (InputStream anotherThemeJSInputStream = this.furnace.getRuntimeClassLoader().getResourceAsStream(THEME_JS_FILENAME);){
                            if (anotherThemeJSInputStream != null) {
                                this.setupTheme(uiDirectory, anotherThemeJSInputStream);
                                break block20;
                            }
                            throw new IllegalStateException("Could not find theme.js config file");
                        }
                    }
                    this.setupTheme(uiDirectory, themeJSInputStream);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setupTheme(Path uiDirectory, InputStream themeJSInputStream) throws IOException {
        Files.delete(uiDirectory.resolve(THEME_JS_FILENAME));
        Files.copy(themeJSInputStream, uiDirectory.resolve(THEME_JS_FILENAME), new CopyOption[0]);
    }
}

