/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.data.rules;

import com.syncleus.ferma.FramedGraph;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.attribute.Text;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.PreReportPfRenderingPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.frames.FramedVertexIterable;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.SourceTypeResolver;
import org.jboss.windup.reporting.data.dto.ApplicationIssuesDto;
import org.jboss.windup.reporting.data.dto.FileContentDto;
import org.jboss.windup.reporting.data.dto.FileDto;
import org.jboss.windup.reporting.data.rules.AbstractApiRuleProvider;
import org.jboss.windup.reporting.data.rules.IssuesRuleProvider;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.model.TaggableModel;
import org.jboss.windup.reporting.model.source.SourceReportModel;
import org.jboss.windup.reporting.model.source.SourceReportToProjectEdgeModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.InlineHintService;
import org.jboss.windup.reporting.service.SourceReportService;
import org.jboss.windup.reporting.service.TechnologyTagService;

@RuleMetadata(phase=PreReportPfRenderingPhase.class, haltOnException=true)
public class FilesRuleProvider
extends AbstractApiRuleProvider {
    public static final String PATH = "files";
    @Inject
    private Imported<SourceTypeResolver> resolvers;

    @Override
    public String getBasePath() {
        return PATH;
    }

    @Override
    public Object getAll(GraphRewrite event) {
        WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
        List inputApplications = configurationModel.getInputPaths();
        return StreamSupport.stream(inputApplications.spliterator(), false).map(inputApplication -> {
            ProjectModelTraversal projectModelTraversal = new ProjectModelTraversal(inputApplication.getProjectModel());
            return this.getFileSources(event, projectModelTraversal);
        }).map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> getById(GraphRewrite event) {
        WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
        List inputApplications = configurationModel.getInputPaths();
        HashMap<String, Object> result = new HashMap<String, Object>();
        StreamSupport.stream(inputApplications.spliterator(), false).map(inputApplication -> {
            ProjectModelTraversal projectModelTraversal = new ProjectModelTraversal(inputApplication.getProjectModel());
            return this.getFileSources(event, projectModelTraversal);
        }).map(Map::entrySet).flatMap(Collection::stream).forEach(fileDtoEntry -> {
            FileContentDto contentDto = new FileContentDto();
            contentDto.setId(((FileDto)fileDtoEntry.getKey()).getId());
            contentDto.setContent((String)fileDtoEntry.getValue());
            result.put(contentDto.getId(), contentDto);
        });
        return result;
    }

    private Map<FileDto, String> getFileSources(GraphRewrite event, ProjectModelTraversal projectModelTraversal) {
        HashMap<FileDto, String> result = new HashMap<FileDto, String>();
        for (FileModel fileModel : projectModelTraversal.getCanonicalProject().getFileModels()) {
            if (!(fileModel instanceof SourceFileModel) || !((SourceFileModel)fileModel).isGenerateSourceReport()) continue;
            AbstractMap.SimpleEntry<FileDto, Optional<String>> filesDto = this.getSourceFileData(event, fileModel);
            filesDto.getValue().ifPresent(fileContent -> result.put((FileDto)filesDto.getKey(), (String)fileContent));
        }
        for (ProjectModelTraversal child : projectModelTraversal.getChildren()) {
            Map<FileDto, String> childrenSourceFiles = this.getFileSources(event, child);
            result.putAll(childrenSourceFiles);
        }
        return result;
    }

    private AbstractMap.SimpleEntry<FileDto, Optional<String>> getSourceFileData(GraphRewrite event, FileModel sourceFile) {
        SourceReportService sourceReportService = new SourceReportService(event.getGraphContext());
        Optional<SourceReportModel> reportModel = Optional.ofNullable(sourceReportService.getSourceReportForFileModel(sourceFile));
        Iterable technologyTagsForFile = new TechnologyTagService(event.getGraphContext()).findTechnologyTagsForFile(sourceFile);
        GraphTraversal classificationPipeline = new GraphTraversalSource((Graph)event.getGraphContext().getGraph()).V(new Object[]{sourceFile.getElement()});
        classificationPipeline.in(new String[]{"ClassificationModel-classificationModelToFileModel"}).has("w:winduptype", (P)Text.textContains((Object)"ClassificationModel"));
        FramedVertexIterable classificationModels = new FramedVertexIterable((FramedGraph)event.getGraphContext().getFramed(), (Iterable)classificationPipeline.toList(), ClassificationModel.class);
        GraphTraversal hintPipeline = new GraphTraversalSource((Graph)event.getGraphContext().getGraph()).V(new Object[]{sourceFile.getElement()});
        hintPipeline.in(new String[]{"file"}).has("w:winduptype", (P)Text.textContains((Object)"FileLocationModel"));
        hintPipeline.in(new String[]{"InlineHintModel-fileLocationReference"}).has("w:winduptype", (P)Text.textContains((Object)"InlineHintModel"));
        FramedVertexIterable hintModels = new FramedVertexIterable((FramedGraph)event.getGraphContext().getFramed(), (Iterable)hintPipeline.toList(), InlineHintModel.class);
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        InlineHintService inlineHintService = new InlineHintService(event.getGraphContext());
        int storyPoints = classificationService.getMigrationEffortPoints(sourceFile) + inlineHintService.getMigrationEffortPoints(sourceFile);
        FileDto fileDto = new FileDto();
        fileDto.setId(sourceFile.getId().toString());
        fileDto.setFullPath(reportModel.map(sourceReportModel -> sourceReportModel.getProjectEdges().stream().map(SourceReportToProjectEdgeModel::getFullPath).collect(Collectors.joining(" | "))).orElse(null));
        fileDto.setPrettyPath(sourceFile.getPrettyPath());
        fileDto.setPrettyFileName(IssuesRuleProvider.getPrettyPathForFile(sourceFile));
        fileDto.setSourceType(this.resolveSourceType(sourceFile));
        fileDto.setStoryPoints(storyPoints);
        List<FileDto.HintDto> hintDtoList = reportModel.map(sourceReportModel -> sourceReportModel.getSourceFileModel().getInlineHints().stream().map(inlineHintModel -> {
            FileDto.HintDto hintDto = new FileDto.HintDto();
            hintDto.setRuleId(inlineHintModel.getRuleID());
            hintDto.setLine(inlineHintModel.getLineNumber());
            hintDto.setTitle(inlineHintModel.getTitle());
            hintDto.setContent(inlineHintModel.getHint());
            hintDto.setLinks(inlineHintModel.getLinks().stream().map(linkModel -> {
                ApplicationIssuesDto.LinkDto linkDto = new ApplicationIssuesDto.LinkDto();
                linkDto.setTitle(linkModel.getDescription());
                linkDto.setHref(linkModel.getLink());
                return linkDto;
            }).collect(Collectors.toList()));
            return hintDto;
        }).collect(Collectors.toList())).orElse(Collections.emptyList());
        fileDto.setHints(hintDtoList);
        fileDto.setTags(StreamSupport.stream(technologyTagsForFile.spliterator(), false).map(technologyTagModel -> {
            FileDto.TagDto tagDto = new FileDto.TagDto();
            tagDto.setName(technologyTagModel.getName());
            tagDto.setVersion(technologyTagModel.getVersion());
            tagDto.setLevel(technologyTagModel.getLevel());
            return tagDto;
        }).collect(Collectors.toList()));
        fileDto.setClassificationsAndHintsTags(Stream.concat(StreamSupport.stream(classificationModels.spliterator(), false), StreamSupport.stream(hintModels.spliterator(), false)).map(rec$ -> ((TaggableModel)rec$).getTags()).flatMap(Collection::stream).collect(Collectors.toSet()));
        return new AbstractMap.SimpleEntry<FileDto, Optional<String>>(fileDto, reportModel.map(SourceReportModel::getSourceBody));
    }

    private String resolveSourceType(FileModel f) {
        for (SourceTypeResolver resolver : this.resolvers) {
            String resolvedType = resolver.resolveSourceType(f);
            if (resolvedType == null) continue;
            return resolvedType;
        }
        return "unknown";
    }
}

