/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.ferma.framefactories.annotation;

import com.syncleus.ferma.ElementFrame;
import com.syncleus.ferma.annotations.Property;
import com.syncleus.ferma.framefactories.annotation.AbstractMethodHandler;
import com.syncleus.ferma.framefactories.annotation.CachesReflection;
import com.syncleus.ferma.framefactories.annotation.ReflectionUtility;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class PropertyMethodHandler
extends AbstractMethodHandler {
    public Class<Property> getAnnotationType() {
        return Property.class;
    }

    @Override
    public <E> DynamicType.Builder<E> processMethod(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        Parameter[] arguments = method.getParameters();
        if (ReflectionUtility.isSetMethod(method)) {
            if (arguments == null || arguments.length == 0) {
                throw new IllegalStateException(method.getName() + " was annotated with @Property but had no arguments.");
            }
            if (arguments.length == 1) {
                return this.setProperty(builder, method, annotation);
            }
            throw new IllegalStateException(method.getName() + " was annotated with @Property but had more than 1 arguments.");
        }
        if (ReflectionUtility.isGetMethod(method)) {
            if (arguments == null || arguments.length == 0) {
                return this.getProperty(builder, method, annotation);
            }
            throw new IllegalStateException(method.getName() + " was annotated with @Property but had arguments.");
        }
        if (ReflectionUtility.isRemoveMethod(method)) {
            if (arguments == null || arguments.length == 0) {
                return this.removeProperty(builder, method, annotation);
            }
            throw new IllegalStateException(method.getName() + " was annotated with @Property but had some arguments.");
        }
        throw new IllegalStateException(method.getName() + " was annotated with @Property but did not begin with either of the following keywords: add, get");
    }

    private <E> DynamicType.Builder<E> setProperty(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(SetPropertyInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getProperty(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetPropertyInterceptor.class));
    }

    private <E> DynamicType.Builder<E> removeProperty(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(RemovePropertyInterceptor.class));
    }

    private static Enum getValueAsEnum(Method method, Object value) {
        Class<?> en = method.getReturnType();
        if (value != null) {
            return Enum.valueOf(en, value.toString());
        }
        return null;
    }

    public static final class RemovePropertyInterceptor {
        public static void removeProperty(@This ElementFrame thiz, @Origin Method method) {
            assert (thiz instanceof CachesReflection);
            Property annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Property.class);
            String value = annotation.value();
            thiz.getElement().property(value).remove();
        }
    }

    public static final class SetPropertyInterceptor {
        @RuntimeType
        public static void setProperty(@This ElementFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) Object obj) {
            assert (thiz instanceof CachesReflection);
            Property annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Property.class);
            String value = annotation.value();
            if (obj != null && obj.getClass().isEnum()) {
                thiz.setProperty(value, ((Enum)obj).name());
            } else {
                thiz.setProperty(value, obj);
            }
        }
    }

    public static final class GetPropertyInterceptor {
        @RuntimeType
        public static Object getProperty(@This ElementFrame thiz, @Origin Method method) {
            assert (thiz instanceof CachesReflection);
            Property annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Property.class);
            String value = annotation.value();
            Object obj = thiz.getProperty(value);
            if (method.getReturnType().isEnum()) {
                return PropertyMethodHandler.getValueAsEnum(method, obj);
            }
            return obj;
        }
    }
}

