/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.tooling;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.util.Lists;
import org.jboss.windup.config.loader.RuleLoader;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleProviderRegistryCache;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.graph.model.report.IgnoredFileRegexModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.WindupJavaConfigurationModel;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.tooling.ExecutionBuilder;
import org.jboss.windup.tooling.ExecutionResults;
import org.jboss.windup.tooling.ExecutionResultsImpl;
import org.jboss.windup.tooling.ToolingProgressMonitorAdapter;
import org.jboss.windup.tooling.ToolingXMLService;
import org.jboss.windup.tooling.WindupToolingProgressMonitor;
import org.jboss.windup.tooling.quickfix.QuickfixLocationDTO;
import org.jboss.windup.tooling.quickfix.QuickfixService;
import org.jboss.windup.tooling.rules.RuleProviderRegistry;
import org.jboss.windup.tooling.rules.RuleProviderRegistryImpl;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.ThemeProvider;
import org.jboss.windup.util.exception.WindupException;

public class ExecutionBuilderImpl
implements ExecutionBuilder {
    @Inject
    private GraphContextFactory graphContextFactory;
    @Inject
    private ToolingXMLService toolingXMLService;
    @Inject
    private WindupProcessor processor;
    @Inject
    private Furnace furnace;
    @Inject
    private RuleProviderRegistryCache ruleProviderCache;
    private String windupHome;
    private WindupToolingProgressMonitor progressMonitor;
    private String output;
    private Set<String> ignorePathPatterns = new HashSet<String>();
    private Set<String> includePackagePrefixSet = new HashSet<String>();
    private Set<String> excludePackagePrefixSet = new HashSet<String>();
    private Set<String> userRulesPathSet = new HashSet<String>();
    private Map<String, Object> options = new HashMap<String, Object>();
    private Set<String> input = new HashSet<String>();
    private String version;
    @Inject
    private RuleLoader ruleLoader;
    @Inject
    private QuickfixService quickfixService;

    public void clear() throws RemoteException {
        this.windupHome = null;
        this.progressMonitor = null;
        this.output = null;
        this.input.clear();
        this.ignorePathPatterns.clear();
        this.includePackagePrefixSet.clear();
        this.excludePackagePrefixSet.clear();
        this.userRulesPathSet.clear();
        this.options.clear();
    }

    public void terminate() throws RemoteException {
        this.furnace.stop();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Runtime.getRuntime().halt(1);
    }

    public void setWindupHome(String windupHome) throws RemoteException {
        this.windupHome = windupHome;
    }

    public void setInput(Set<String> input) throws RemoteException {
        this.input = input;
    }

    public void setOutput(String output) throws RemoteException {
        this.output = output;
    }

    public void ignore(String ignorePattern) throws RemoteException {
        this.ignorePathPatterns.add(ignorePattern);
    }

    public void includePackage(String packagePrefix) throws RemoteException {
        this.includePackagePrefixSet.add(packagePrefix);
    }

    public void includePackages(Collection<String> includePackagePrefixes) throws RemoteException {
        if (includePackagePrefixes != null) {
            this.includePackagePrefixSet.addAll(includePackagePrefixes);
        }
    }

    public void excludePackage(String packagePrefix) throws RemoteException {
        this.excludePackagePrefixSet.add(packagePrefix);
    }

    public void excludePackages(Collection<String> excludePackagePrefixes) throws RemoteException {
        if (excludePackagePrefixes != null) {
            this.excludePackagePrefixSet.addAll(excludePackagePrefixes);
        }
    }

    public void setProgressMonitor(WindupToolingProgressMonitor monitor) throws RemoteException {
        this.progressMonitor = monitor;
    }

    public void sourceOnlyMode() throws RemoteException {
        this.options.put("sourceMode", true);
    }

    public void skipReportGeneration() throws RemoteException {
        this.options.put("skipReports", true);
    }

    public void skipSourceCodeReportGeneration() throws RemoteException {
        this.options.put("skipSourceCodeReports", true);
    }

    public void addUserRulesPath(String rulesPath) throws RemoteException {
        if (rulesPath == null) {
            return;
        }
        String pathString = Paths.get(rulesPath, new String[0]).normalize().toAbsolutePath().toString();
        this.userRulesPathSet.add(pathString);
    }

    public void addUserRulesPaths(Iterable<String> rulesPaths) throws RemoteException {
        if (rulesPaths == null) {
            return;
        }
        for (String rulesPath : rulesPaths) {
            this.addUserRulesPath(rulesPath);
        }
    }

    public void setOption(String name, Object value) throws RemoteException {
        this.options.put(name, value);
    }

    public String getVersion() throws RemoteException {
        return this.version;
    }

    public void setVersion(String version) throws RemoteException {
        this.version = version;
    }

    public String transform(String transformationID, QuickfixLocationDTO locationDTO) throws RemoteException {
        return this.quickfixService.transform(transformationID, locationDTO);
    }

    public ExecutionResults execute() throws RemoteException {
        PathUtil.setWindupHome((Path)Paths.get(this.windupHome, new String[0]));
        WindupConfiguration windupConfiguration = new WindupConfiguration();
        try {
            windupConfiguration.useDefaultDirectories();
        }
        catch (IOException e) {
            throw new WindupException("Failed to configure " + ThemeProvider.getInstance().getTheme().getBrandNameAcronym() + " due to: " + e.getMessage(), (Throwable)e);
        }
        ToolingProgressMonitorAdapter progressMonitorAdapter = new ToolingProgressMonitorAdapter(this.progressMonitor);
        this.input.forEach(i -> windupConfiguration.addInputPath(Paths.get(i, new String[0])));
        windupConfiguration.setOutputDirectory(Paths.get(this.output, new String[0]));
        windupConfiguration.setProgressMonitor((WindupProgressMonitor)progressMonitorAdapter);
        Path graphPath = Paths.get(this.output, new String[0]).resolve("graph");
        Logger globalLogger = Logger.getLogger("");
        WindupProgressLoggingHandler loggingHandler = null;
        if (this.progressMonitor instanceof WindupToolingProgressMonitor) {
            loggingHandler = new WindupProgressLoggingHandler(this.progressMonitor);
            globalLogger.addHandler(loggingHandler);
        }
        try {
            ExecutionResultsImpl executionResultsImpl;
            block17: {
                GraphContext graphContext = this.graphContextFactory.create(graphPath, true);
                try {
                    GraphService graphService = new GraphService(graphContext, IgnoredFileRegexModel.class);
                    for (String string : this.ignorePathPatterns) {
                        IgnoredFileRegexModel ignored = (IgnoredFileRegexModel)graphService.create();
                        ignored.setRegex(string);
                        WindupJavaConfigurationModel javaCfg = WindupJavaConfigurationService.getJavaConfigurationModel((GraphContext)graphContext);
                        javaCfg.addIgnoredFileRegex(ignored);
                    }
                    windupConfiguration.setOptionValue("packages", (Object)Lists.toList(this.includePackagePrefixSet));
                    windupConfiguration.setOptionValue("excludePackages", (Object)Lists.toList(this.excludePackagePrefixSet));
                    for (Map.Entry entry : this.options.entrySet()) {
                        windupConfiguration.setOptionValue((String)entry.getKey(), entry.getValue());
                    }
                    windupConfiguration.setGraphContext(graphContext);
                    this.processor.execute(windupConfiguration);
                    executionResultsImpl = new ExecutionResultsImpl(graphContext, this.toolingXMLService);
                    if (graphContext == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (graphContext != null) {
                            try {
                                graphContext.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new WindupException("Failed to instantiate graph due to: " + e.getMessage(), (Throwable)e);
                    }
                }
                graphContext.close();
            }
            return executionResultsImpl;
        }
        finally {
            if (loggingHandler != null) {
                globalLogger.removeHandler(loggingHandler);
            }
        }
    }

    public RuleProviderRegistry getRuleProviderRegistry(List<String> pathStrings) throws RemoteException {
        RuleProviderRegistryImpl ruleProviderRegistry = new RuleProviderRegistryImpl();
        List paths = pathStrings.stream().map(pathString -> Paths.get(pathString, new String[0])).collect(Collectors.toList());
        RuleLoaderContext ruleLoaderContext = new RuleLoaderContext(paths, null);
        org.jboss.windup.config.metadata.RuleProviderRegistry registry = this.ruleLoader.loadConfiguration(ruleLoaderContext);
        ruleProviderRegistry.buildRuleProviders(registry);
        return ruleProviderRegistry;
    }

    public RuleProviderRegistry getSystemRuleProviderRegistry() throws RemoteException {
        RuleProviderRegistryImpl ruleProviderRegistry = new RuleProviderRegistryImpl();
        ruleProviderRegistry.buildRuleProviders(this.ruleProviderCache.getRuleProviderRegistry());
        return ruleProviderRegistry;
    }

    public String getEnv(String name) throws RemoteException {
        return System.getenv(name);
    }

    private class WindupProgressLoggingHandler
    extends Handler {
        private final WindupToolingProgressMonitor monitor;

        public WindupProgressLoggingHandler(WindupToolingProgressMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void publish(LogRecord record) {
            if (this.monitor == null) {
                return;
            }
            try {
                this.monitor.logMessage(record);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

