/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import com.codahale.metrics.Timer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransaction;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.BaseTransactionConfigurable;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.indexing.IndexMutation;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.diskstorage.indexing.RawQuery;
import org.janusgraph.diskstorage.util.StorageCallable;
import org.janusgraph.diskstorage.util.StorageRunnable;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.util.stats.MetricManager;

public class MetricInstrumentedIndexProvider
implements IndexProvider {
    private final MetricManager metricManager = MetricManager.INSTANCE;
    private final IndexProvider indexProvider;
    private final String prefix;
    public static final String M_MUTATE = "mutate";
    public static final String M_RESTORE = "restore";
    public static final String M_QUERY = "query";
    public static final String M_MIXED_COUNT_QUERY = "mixedIndexCountQuery";
    public static final String M_RAW_QUERY = "rawQuery";
    public static final String M_TOTALS = "totals";
    public static final String M_CALLS = "calls";
    public static final String M_TIME = "time";
    public static final String M_EXCEPTIONS = "exceptions";
    public static final List<String> OPERATION_NAMES = Collections.unmodifiableList(Arrays.asList("mutate", "restore", "query", "mixedIndexCountQuery", "rawQuery", "totals"));

    public MetricInstrumentedIndexProvider(IndexProvider indexProvider, String prefix) {
        this.indexProvider = indexProvider;
        this.prefix = prefix;
    }

    @Override
    public void register(String store, String key, KeyInformation information, BaseTransaction tx) throws BackendException {
        this.indexProvider.register(store, key, information, tx);
    }

    @Override
    public void mutate(Map<String, Map<String, IndexMutation>> mutations, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        this.runWithMetrics((BaseTransactionConfigurable)tx, M_MUTATE, () -> this.indexProvider.mutate(mutations, information, tx));
    }

    @Override
    public void restore(Map<String, Map<String, List<IndexEntry>>> documents, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        this.runWithMetrics((BaseTransactionConfigurable)tx, M_RESTORE, () -> this.indexProvider.restore(documents, information, tx));
    }

    @Override
    public Long queryCount(IndexQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        return this.runWithMetrics((BaseTransactionConfigurable)tx, M_MIXED_COUNT_QUERY, () -> this.indexProvider.queryCount(query, information, tx));
    }

    @Override
    public Stream<String> query(IndexQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        return this.runWithMetrics((BaseTransactionConfigurable)tx, M_QUERY, () -> this.indexProvider.query(query, information, tx));
    }

    @Override
    public Stream<RawQuery.Result<String>> query(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        return this.runWithMetrics((BaseTransactionConfigurable)tx, M_RAW_QUERY, () -> this.indexProvider.query(query, information, tx));
    }

    @Override
    public Long totals(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        return this.runWithMetrics((BaseTransactionConfigurable)tx, M_TOTALS, () -> this.indexProvider.totals(query, information, tx));
    }

    @Override
    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig config) throws BackendException {
        return this.indexProvider.beginTransaction(config);
    }

    @Override
    public void close() throws BackendException {
        this.indexProvider.close();
    }

    @Override
    public void clearStorage() throws BackendException {
        this.indexProvider.clearStorage();
    }

    @Override
    public boolean exists() throws BackendException {
        return this.indexProvider.exists();
    }

    @Override
    public boolean supports(KeyInformation information, JanusGraphPredicate janusgraphPredicate) {
        return this.indexProvider.supports(information, janusgraphPredicate);
    }

    @Override
    public boolean supports(KeyInformation information) {
        return this.indexProvider.supports(information);
    }

    @Override
    public String mapKey2Field(String key, KeyInformation information) {
        return this.indexProvider.mapKey2Field(key, information);
    }

    @Override
    public IndexFeatures getFeatures() {
        return this.indexProvider.getFeatures();
    }

    private void runWithMetrics(BaseTransactionConfigurable tx, String name, StorageRunnable impl) throws BackendException {
        if (!tx.getConfiguration().hasGroupName()) {
            impl.run();
        }
        String groupName = tx.getConfiguration().getGroupName();
        Timer.Context tc = this.incrementCallsAndReturnTimerContext(groupName, name);
        try {
            impl.run();
        }
        catch (RuntimeException | BackendException e) {
            this.incrementExceptions(groupName, name);
            throw e;
        }
        finally {
            tc.stop();
        }
    }

    private <T> T runWithMetrics(BaseTransactionConfigurable tx, String name, StorageCallable<T> impl) throws BackendException {
        if (!tx.getConfiguration().hasGroupName()) {
            return impl.call();
        }
        String groupName = tx.getConfiguration().getGroupName();
        Timer.Context tc = this.incrementCallsAndReturnTimerContext(groupName, name);
        try {
            T t = impl.call();
            return t;
        }
        catch (RuntimeException | BackendException e) {
            this.incrementExceptions(groupName, name);
            throw e;
        }
        finally {
            tc.stop();
        }
    }

    private Timer.Context incrementCallsAndReturnTimerContext(String groupName, String name) {
        this.metricManager.getCounter(groupName, this.prefix, name, M_CALLS).inc();
        return this.metricManager.getTimer(groupName, this.prefix, name, M_TIME).time();
    }

    private void incrementExceptions(String groupName, String name) {
        this.metricManager.getCounter(groupName, this.prefix, name, M_EXCEPTIONS).inc();
    }
}

