/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation.packagemapping;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.GraphRule;
import org.jboss.windup.config.PreRulesetEvaluation;
import org.jboss.windup.rules.apps.java.model.WindupJavaConfigurationModel;
import org.jboss.windup.rules.apps.java.scan.operation.packagemapping.PackageNameMappingWithOrganization;
import org.jboss.windup.rules.apps.java.scan.operation.packagemapping.PackageNameMappingWithPackagePattern;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.PathUtil;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class PackageNameMapping
extends GraphRule
implements PackageNameMappingWithPackagePattern,
PackageNameMappingWithOrganization,
PreRulesetEvaluation {
    private static final Logger LOG = Logger.getLogger(PackageNameMapping.class.getName());
    private String id = this.getClass().getName() + "_" + UUID.randomUUID();
    private String organization;
    private String packagePattern;

    @Override
    public Rule withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public PackageNameMappingWithOrganization toOrganization(String organization) {
        this.setOrganization(organization);
        return this;
    }

    public void preRulesetEvaluation(GraphRewrite event) {
        PackageNameMapping.getMappings(event).put(this.packagePattern, this.organization);
    }

    public boolean evaluate(GraphRewrite event, EvaluationContext context) {
        return true;
    }

    public void perform(GraphRewrite event, EvaluationContext context) {
    }

    public String getId() {
        return this.id;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getPackagePattern() {
        return this.packagePattern;
    }

    public void setPackagePattern(String packagePattern) {
        this.packagePattern = packagePattern;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append(".fromPackage(" + this.packagePattern + ")");
        builder.append(".toOrganization(" + this.organization + ")");
        return builder.toString();
    }

    public static PackageNameMappingWithPackagePattern fromPackage(String packagePattern) {
        PackageNameMapping packageNameMapping = new PackageNameMapping();
        packageNameMapping.setPackagePattern(packagePattern);
        return packageNameMapping;
    }

    public static boolean areAllPackagesKnown(GraphRewrite event, String filePath) {
        ZipFile archive;
        if (!StringUtils.equalsIgnoreCase((CharSequence)StringUtils.substringAfterLast((String)filePath, (String)"."), (CharSequence)"jar")) {
            return false;
        }
        try {
            archive = new ZipFile(filePath);
        }
        catch (IOException e) {
            return false;
        }
        WindupJavaConfigurationService javaConfigurationService = new WindupJavaConfigurationService(event.getGraphContext());
        WindupJavaConfigurationModel javaConfigurationModel = WindupJavaConfigurationService.getJavaConfigurationModel(event.getGraphContext());
        boolean customerPackagesSpecified = !javaConfigurationModel.getScanJavaPackages().isEmpty();
        boolean containsOnlyKnownPackages = false;
        String organization = null;
        Enumeration<? extends ZipEntry> e = archive.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String entryName = entry.getName();
            if (entry.isDirectory() || !StringUtils.endsWith((CharSequence)entryName, (CharSequence)".class")) continue;
            String classname = PathUtil.classFilePathToClassname((String)entryName);
            if (!containsOnlyKnownPackages) {
                organization = PackageNameMapping.getOrganizationFromMappings(event, classname);
                if (organization == null) break;
                containsOnlyKnownPackages = true;
            }
            if (!customerPackagesSpecified || !javaConfigurationService.shouldScanPackage(classname)) continue;
            return false;
        }
        if (containsOnlyKnownPackages) {
            LOG.info("Known Package: " + archive.getName() + "; Organization: " + organization);
        }
        return containsOnlyKnownPackages;
    }

    public static String getOrganizationFromMappings(GraphRewrite event, String pkg) {
        String pkgComparison = pkg + ".";
        String organization = null;
        for (Map.Entry<String, String> entry : PackageNameMapping.getMappings(event).entrySet()) {
            String pkgPattern = entry.getKey() + ".";
            if (!StringUtils.startsWith((CharSequence)pkgComparison, (CharSequence)pkgPattern)) continue;
            organization = entry.getValue();
            LOG.info(" -- Found organization: " + organization);
            break;
        }
        return organization;
    }

    private static Map<String, String> getMappings(GraphRewrite event) {
        HashMap map = (HashMap)event.getRewriteContext().get(PackageNameMapping.class);
        if (map == null) {
            map = new HashMap();
            event.getRewriteContext().put(PackageNameMapping.class, map);
        }
        return map;
    }
}

