/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.DuplicateArchiveModel;
import org.jboss.windup.graph.model.IgnoredArchiveModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.IgnoredFileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.java.archives.identify.ArchiveIdentificationService;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.rules.apps.java.scan.operation.IdentifiedArchiveFileFilter;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.ZipUtil;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.exception.WindupStopException;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class UnzipArchiveToOutputFolder
extends AbstractIterationOperation<ArchiveModel> {
    private static final String MALFORMED_ARCHIVE = "Malformed archive";
    public static final String ARCHIVES = "archives";
    private static final String KEY_BAD_ARCHIVES = "unparsableArchives";
    private static final Logger LOG = Logging.get(UnzipArchiveToOutputFolder.class);
    private final ArchiveIdentificationService archiveIdentificationService;

    public UnzipArchiveToOutputFolder(ArchiveIdentificationService archiveIdentificationService) {
        this.archiveIdentificationService = archiveIdentificationService;
    }

    public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
        GraphContext graphContext = event.getGraphContext();
        if (new WindupJavaConfigurationService(graphContext).checkRegexAndIgnore(event, (FileModel)payload)) {
            return;
        }
        LOG.info("Unzipping archive: " + payload.toPrettyString());
        File zipFile = payload.asFile();
        if (zipFile == null || !zipFile.isFile()) {
            throw new WindupException("Input path doesn't point to a file: " + (zipFile == null ? "null" : zipFile.getAbsolutePath()));
        }
        this.checkCancelled(event);
        Path unzippedArchiveDir = UnzipArchiveToOutputFolder.getArchivesDirLocation(graphContext);
        UnzipArchiveToOutputFolder.ensureDirIsCreated(unzippedArchiveDir);
        Object badArchives = event.getRewriteContext().get((Object)KEY_BAD_ARCHIVES);
        if (null == badArchives) {
            event.getRewriteContext().put((Object)KEY_BAD_ARCHIVES, new ArrayList());
        }
        this.unzipToTempDirectory(event, context, unzippedArchiveDir, zipFile, payload, false);
    }

    private void checkCancelled(GraphRewrite event) {
        if (event.shouldWindupStop()) {
            throw new WindupStopException("Request to stop detected during unzipping of archives");
        }
    }

    public static Path getArchivesDirLocation(GraphContext graphContext) {
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)graphContext);
        String windupOutputFolder = cfg.getOutputPath().getFilePath();
        return Paths.get(windupOutputFolder, ARCHIVES);
    }

    private void unzipToTempDirectory(GraphRewrite event, EvaluationContext context, Path tempFolder, File inputZipFile, ArchiveModel archiveModel, boolean subArchivesOnly) {
        this.checkCancelled(event);
        FileService fileService = new FileService(event.getGraphContext());
        String appArchiveName = archiveModel.getArchiveName();
        if (null == appArchiveName) {
            throw new IllegalStateException("Archive model doesn't have an archiveName: " + archiveModel.getFilePath());
        }
        Path appArchiveFolder = UnzipArchiveToOutputFolder.getNonexistentDirForAppArchive(tempFolder, appArchiveName);
        UnzipArchiveToOutputFolder.ensureDirIsCreated(appArchiveFolder);
        LOG.info("Unzipping " + inputZipFile.getPath() + " to " + appArchiveFolder.toString());
        try {
            ZipUtil.unzipToFolder((File)inputZipFile, (File)appArchiveFolder.toFile());
        }
        catch (Throwable e) {
            ArchiveModel canonicalArchive = archiveModel;
            if (canonicalArchive instanceof DuplicateArchiveModel) {
                canonicalArchive = ((DuplicateArchiveModel)canonicalArchive).getCanonicalArchive();
            }
            ClassificationService classificationService = new ClassificationService(event.getGraphContext());
            List badArchives = (List)event.getRewriteContext().get((Object)KEY_BAD_ARCHIVES);
            badArchives.add(inputZipFile.getPath());
            String badArchivesString = badArchives.stream().map(s -> " * `" + s + "`\n").collect(Collectors.joining());
            classificationService.attachClassification(event, context, (FileModel)canonicalArchive, MALFORMED_ARCHIVE, "Cannot unzip these file(s): \n\n" + badArchivesString);
            archiveModel.setParseError("Cannot unzip the file: " + e.getMessage());
            LOG.warning("Cannot unzip the file " + inputZipFile.getPath() + " to " + appArchiveFolder.toString() + ". The ArchiveModel was classified as malformed.");
            return;
        }
        archiveModel.setUnzippedDirectory(appArchiveFolder.toString());
        this.recurseAndAddFiles(event, context, tempFolder, fileService, archiveModel, (FileModel)archiveModel, subArchivesOnly);
    }

    private void recurseAndAddFiles(GraphRewrite event, EvaluationContext context, Path tempFolder, FileService fileService, ArchiveModel archiveModel, FileModel parentFileModel, boolean subArchivesOnly) {
        File fileReference;
        File[] subFiles;
        boolean shouldBeIgnored;
        this.checkCancelled(event);
        int numberAdded = 0;
        WindupJavaConfigurationService windupJavaConfigurationService = new WindupJavaConfigurationService(event.getGraphContext());
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
        List inputPaths = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext()).getInputPaths();
        String archiveModelFilePath = archiveModel.getFilePath();
        boolean isInputApp = inputPaths.stream().anyMatch(inputPath -> inputPath.getFilePath().equals(archiveModelFilePath));
        String hash = archiveModel.getSHA1Hash();
        Coordinate coordinate = this.archiveIdentificationService.getCoordinate(hash);
        boolean isKnownLibrary = archiveModel instanceof IgnoredFileModel || coordinate != null;
        boolean analyseKnownLibraries = cfg.isAnalyzeKnownLibraries();
        boolean bl = shouldBeIgnored = isKnownLibrary && !analyseKnownLibraries && !isInputApp;
        if (shouldBeIgnored) {
            LOG.info(String.format("Library will be ignored: %s", archiveModel.getArchiveName()));
            GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)archiveModel, IgnoredArchiveModel.class);
        }
        LOG.log(Level.FINE, String.format("Library %s (coordinates %s) with hash %s will be inspected in sub folder %s", archiveModelFilePath, coordinate, hash, parentFileModel.getFilePath()));
        Object filter = TrueFileFilter.TRUE;
        if (archiveModel instanceof IdentifiedArchiveModel) {
            filter = new IdentifiedArchiveFileFilter(archiveModel);
        }
        if ((subFiles = (fileReference = parentFileModel instanceof ArchiveModel ? new File(((ArchiveModel)parentFileModel).getUnzippedDirectory()) : parentFileModel.asFile()).listFiles()) == null) {
            return;
        }
        for (File subFile : subFiles) {
            FileModel subFileModel;
            if (shouldBeIgnored || !filter.accept(subFile) || subArchivesOnly && !ZipUtil.endsWithZipExtension((String)subFile.getAbsolutePath()) || windupJavaConfigurationService.checkRegexAndIgnore(event, subFileModel = fileService.createByFilePath(parentFileModel, subFile.getAbsolutePath()))) continue;
            if (++numberAdded % 250 == 0) {
                event.getGraphContext().commit();
            }
            if (subFile.isFile() && ZipUtil.endsWithZipExtension((String)subFileModel.getFilePath())) {
                File newZipFile = subFileModel.asFile();
                ArchiveModel newArchiveModel = (ArchiveModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)subFileModel, ArchiveModel.class);
                newArchiveModel.setParentArchive(archiveModel);
                newArchiveModel.setArchiveName(newZipFile.getName());
                newArchiveModel = (ArchiveModel)GraphService.refresh((GraphContext)event.getGraphContext(), (WindupVertexFrame)newArchiveModel);
                ArchiveModel canonicalArchiveModel = null;
                for (FileModel otherMatches : fileService.findAllByProperty("sha1Hash", (Object)newArchiveModel.getSHA1Hash())) {
                    if (!(otherMatches instanceof ArchiveModel) || otherMatches.equals(newArchiveModel) || otherMatches instanceof DuplicateArchiveModel) continue;
                    canonicalArchiveModel = (ArchiveModel)otherMatches;
                    break;
                }
                if (canonicalArchiveModel != null) {
                    DuplicateArchiveModel duplicateArchive = (DuplicateArchiveModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)newArchiveModel, DuplicateArchiveModel.class);
                    duplicateArchive.setCanonicalArchive(canonicalArchiveModel);
                    this.unzipToTempDirectory(event, context, tempFolder, newZipFile, (ArchiveModel)duplicateArchive, true);
                    continue;
                }
                this.unzipToTempDirectory(event, context, tempFolder, newZipFile, newArchiveModel, false);
                continue;
            }
            if (!subFile.isDirectory()) continue;
            this.recurseAndAddFiles(event, context, tempFolder, fileService, archiveModel, subFileModel, false);
        }
    }

    private static Path getNonexistentDirForAppArchive(Path tempFolder, String appArchiveName) {
        Path appArchiveFolder = Paths.get(tempFolder.toString(), appArchiveName);
        int fileIdx = 1;
        while (Files.exists(appArchiveFolder, new LinkOption[0])) {
            appArchiveFolder = Paths.get(tempFolder.toString(), appArchiveName + "." + fileIdx);
            ++fileIdx;
        }
        return appArchiveFolder;
    }

    private static void ensureDirIsCreated(Path windupTempUnzippedArchiveFolder) throws WindupException {
        if (!Files.isDirectory(windupTempUnzippedArchiveFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(windupTempUnzippedArchiveFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new WindupException("Failed to create temporary folder for archives: " + windupTempUnzippedArchiveFolder + System.lineSeparator() + "\tdue to: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String toString() {
        return UnzipArchiveToOutputFolder.class.getSimpleName();
    }
}

