/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.dependencyreport;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.DuplicateArchiveModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.java.dependencyreport.DependenciesReportModel;
import org.jboss.windup.rules.apps.java.dependencyreport.DependencyReportDependencyGroupModel;
import org.jboss.windup.rules.apps.java.dependencyreport.DependencyReportToArchiveEdgeModel;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ReportGenerationPhase.class, id="Create Java Dependency Report")
public class CreateDependencyReportRuleProvider
extends AbstractRuleProvider {
    public static final String REPORT_NAME = "Dependencies";
    public static final String TEMPLATE = "/reports/templates/dependency_report.ftl";
    public static final String REPORT_DESCRIPTION = "This report lists all found Java libraries embedded within the analyzed application.";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                int count = 0;
                for (FileModel inputPath : configurationModel.getInputPaths()) {
                    ProjectModel projectModel = inputPath.getProjectModel();
                    CreateDependencyReportRuleProvider.this.createReport(event.getGraphContext(), projectModel);
                    ++count;
                }
                if (count > 1) {
                    CreateDependencyReportRuleProvider.this.createGlobalReport(event.getGraphContext(), configurationModel);
                }
            }

            public String toString() {
                return "CreateDependencyReport";
            }
        });
    }

    private void addAll(GraphContext context, DependenciesReportModel reportModel, ProjectModelTraversal traversal, Map<String, DependencyReportDependencyGroupModel> groupsBySHA1) {
        boolean isRootProject;
        FileModel rootFileModel = traversal.getCurrent().getRootFileModel();
        boolean bl = isRootProject = traversal.getCurrent().getParentProject() == null;
        if (!isRootProject && rootFileModel instanceof ArchiveModel) {
            ArchiveModel archiveModel = (ArchiveModel)rootFileModel;
            ArchiveModel canonicalArchive = archiveModel instanceof DuplicateArchiveModel ? ((DuplicateArchiveModel)archiveModel).getCanonicalArchive() : archiveModel;
            String sha1 = archiveModel.getSHA1Hash();
            DependencyReportDependencyGroupModel groupModel = groupsBySHA1.get(sha1);
            if (groupModel == null) {
                groupModel = (DependencyReportDependencyGroupModel)context.service(DependencyReportDependencyGroupModel.class).create();
                groupModel.setSHA1(sha1);
                groupModel.setCanonicalProject(canonicalArchive.getProjectModel());
                reportModel.addArchiveGroup(groupModel);
                groupsBySHA1.put(sha1, groupModel);
            }
            String path = traversal.getFilePath(rootFileModel);
            boolean archiveAlreadyLinked = false;
            for (DependencyReportToArchiveEdgeModel groupEdge : groupModel.getArchives()) {
                if (!StringUtils.equals((CharSequence)groupEdge.getFullPath(), (CharSequence)path)) continue;
                archiveAlreadyLinked = true;
                break;
            }
            if (!archiveAlreadyLinked) {
                DependencyReportToArchiveEdgeModel edge = groupModel.addArchiveModel(archiveModel);
                edge.setFullPath(path);
            }
        }
        for (ProjectModelTraversal child : traversal.getChildren()) {
            this.addAll(context, reportModel, child, groupsBySHA1);
        }
    }

    private void createGlobalReport(GraphContext context, WindupConfigurationModel configuration) {
        ReportService reportService = new ReportService(context);
        DependenciesReportModel reportModel = this.createReportModel(context);
        HashMap<String, DependencyReportDependencyGroupModel> sha1ToGroup = new HashMap<String, DependencyReportDependencyGroupModel>();
        for (FileModel inputApplication : configuration.getInputPaths()) {
            ProjectModel projectModel = inputApplication.getProjectModel();
            if (StringUtils.equals((CharSequence)projectModel.getUniqueID(), (CharSequence)"<shared-libs>")) continue;
            ProjectModelTraversal traversal = new ProjectModelTraversal(inputApplication.getProjectModel());
            this.addAll(context, reportModel, traversal, sha1ToGroup);
        }
        reportModel.setDisplayInGlobalApplicationIndex(Boolean.TRUE);
        reportService.setUniqueFilename((ReportModel)reportModel, "dependency_report_global", "html");
    }

    private void createReport(GraphContext context, ProjectModel application) {
        ReportService reportService = new ReportService(context);
        DependenciesReportModel reportModel = this.createReportModel(context);
        this.addAll(context, reportModel, new ProjectModelTraversal(application), new HashMap<String, DependencyReportDependencyGroupModel>());
        reportModel.setProjectModel(application);
        reportService.setUniqueFilename((ReportModel)reportModel, "dependency_report_" + application.getName(), "html");
    }

    private DependenciesReportModel createReportModel(GraphContext context) {
        ApplicationReportService service = new ApplicationReportService(context);
        DependenciesReportModel applicationReportModel = (DependenciesReportModel)context.service(DependenciesReportModel.class).addTypeToModel((WindupVertexFrame)service.create());
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.TRUE);
        applicationReportModel.setReportPriority(120);
        applicationReportModel.setReportName(REPORT_NAME);
        applicationReportModel.setDescription(REPORT_DESCRIPTION);
        applicationReportModel.setReportIconClass("glyphicon glyphicon-retweet");
        applicationReportModel.setTemplatePath(TEMPLATE);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        return applicationReportModel;
    }
}

