/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.decompiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CleanFromMultipleSourceFiles
extends GraphOperation {
    public void perform(GraphRewrite event, EvaluationContext context) {
        GraphContext graphContext = event.getGraphContext();
        List javaSourceGroups = graphContext.getQuery(JavaSourceFileModel.class).getRawTraversal().group().by(v -> this.groupByProjectModelFunction(graphContext, (Vertex)v)).toList();
        GraphService service = new GraphService(event.getGraphContext(), JavaSourceFileModel.class);
        for (Map duplicateLists : javaSourceGroups) {
            for (Object duplicateListObject : duplicateLists.values()) {
                List duplicateList = (List)duplicateListObject;
                List<JavaSourceFileModel> toDelete = this.returnVerticesToDelete((GraphService<JavaSourceFileModel>)service, duplicateList);
                toDelete.forEach(javaSourceFileModel -> javaSourceFileModel.remove());
            }
        }
    }

    private String groupByProjectModelFunction(GraphContext context, Vertex vertex) {
        JavaSourceFileModel javaModel = (JavaSourceFileModel)context.getFramed().frameElement((Element)vertex, JavaSourceFileModel.class);
        ProjectModel projectModel = javaModel.getProjectModel();
        String projectModelID = projectModel == null ? "" : projectModel.getId().toString();
        String packageName = javaModel.getPackageName() == null ? "" : javaModel.getPackageName();
        return projectModelID + "_" + packageName + "_" + javaModel.getFileName();
    }

    private List<JavaSourceFileModel> returnVerticesToDelete(GraphService<JavaSourceFileModel> service, Collection<Vertex> javaSourceVertices) {
        boolean uniqueClassFound = false;
        ArrayList<JavaSourceFileModel> verticesToBeDeleted = new ArrayList<JavaSourceFileModel>();
        if (javaSourceVertices.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<Vertex> iterator = javaSourceVertices.iterator();
        while (iterator.hasNext()) {
            Vertex v = iterator.next();
            JavaSourceFileModel javaModel = (JavaSourceFileModel)service.frame(v);
            if (javaModel.isWindupGenerated() != null && javaModel.isWindupGenerated().booleanValue() && !uniqueClassFound) {
                uniqueClassFound = true;
                continue;
            }
            if (!iterator.hasNext() && !uniqueClassFound) {
                uniqueClassFound = true;
                continue;
            }
            verticesToBeDeleted.add(javaModel);
        }
        return verticesToBeDeleted;
    }
}

