/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.syncleus.ferma.ElementFrame;
import com.syncleus.ferma.FramedGraph;
import com.syncleus.ferma.TEdge;
import com.syncleus.ferma.VertexFrame;
import com.syncleus.ferma.framefactories.annotation.AbstractMethodHandler;
import com.syncleus.ferma.framefactories.annotation.CachesReflection;
import com.syncleus.ferma.framefactories.annotation.MethodHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.graph.MapInAdjacentVertices;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.exception.WindupException;

public class MapInAdjacentVerticesHandler
extends AbstractMethodHandler
implements MethodHandler {
    public Class<MapInAdjacentVertices> getAnnotationType() {
        return MapInAdjacentVertices.class;
    }

    public <E> DynamicType.Builder<E> processMethod(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return this.createInterceptor(builder, method);
        }
        if (methodName.startsWith("set")) {
            return this.createInterceptor(builder, method);
        }
        throw new WindupException("Only get* and set* method names are supported.");
    }

    private <E> DynamicType.Builder<E> createInterceptor(DynamicType.Builder<E> builder, Method method) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(MapInAdjacentVerticesInterceptor.class));
    }

    public static final class MapInAdjacentVerticesInterceptor {
        @RuntimeType
        public static Object execute(@This ElementFrame thisFrame, @Origin Method method, @RuntimeType @AllArguments Object[] args) {
            MapInAdjacentVertices ann = (MapInAdjacentVertices)((CachesReflection)thisFrame).getReflectionCache().getAnnotation(method, MapInAdjacentVertices.class);
            Element thisElement = thisFrame.getElement();
            if (!(thisElement instanceof Vertex)) {
                throw new WindupException("Element is not of supported type, must be Vertex, but was: " + thisElement.getClass().getCanonicalName());
            }
            Vertex vertex = (Vertex)thisElement;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                return MapInAdjacentVerticesInterceptor.handleGetter(vertex, method, args, ann, thisFrame.getGraph());
            }
            if (methodName.startsWith("set")) {
                MapInAdjacentVerticesInterceptor.handleSetter((VertexFrame)thisFrame, method, args, ann, thisFrame.getGraph());
                return null;
            }
            throw new WindupException("Only get* and set* method names are supported.");
        }

        private static Map<String, WindupVertexFrame> handleGetter(Vertex vertex, Method method, Object[] arguments, MapInAdjacentVertices annotation, FramedGraph framedGraph) {
            if (arguments != null && arguments.length != 0) {
                throw new WindupException("Method must take zero arguments: " + method.getName());
            }
            HashMap<String, WindupVertexFrame> result = new HashMap<String, WindupVertexFrame>();
            Iterator edges = vertex.edges(Direction.IN, new String[]{annotation.label()});
            while (edges.hasNext()) {
                Edge edge = (Edge)edges.next();
                Property property = edge.property(annotation.mapKeyField());
                if (property == null) continue;
                Vertex v = edge.outVertex();
                WindupVertexFrame frame = (WindupVertexFrame)framedGraph.frameElement((Element)v, WindupVertexFrame.class);
                result.put((String)property.value(), frame);
            }
            return result;
        }

        private static void handleSetter(VertexFrame vertexFrame, Method method, Object[] arguments, MapInAdjacentVertices annotation, FramedGraph framedGraph) {
            if (arguments == null || arguments.length != 1) {
                throw new WindupException("Method must take only one argument: " + method.getName());
            }
            Iterator edges = vertexFrame.getElement().edges(Direction.IN, new String[]{annotation.label()});
            while (edges.hasNext()) {
                Edge edge = (Edge)edges.next();
                edge.remove();
            }
            Map map = (Map)arguments[0];
            for (Map.Entry entry : map.entrySet()) {
                TEdge edge = framedGraph.addFramedEdge((VertexFrame)entry.getValue(), vertexFrame, annotation.label());
                edge.setProperty(annotation.mapKeyField(), entry.getKey());
            }
        }
    }
}

