/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.syncleus.ferma.ElementFrame;
import com.syncleus.ferma.FramedGraph;
import com.syncleus.ferma.WrappedFramedGraph;
import com.syncleus.ferma.framefactories.annotation.AbstractMethodHandler;
import com.syncleus.ferma.framefactories.annotation.CachesReflection;
import com.syncleus.ferma.framefactories.annotation.MethodHandler;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.jboss.windup.graph.MapInAdjacentProperties;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;

public class MapInAdjacentPropertiesHandler
extends AbstractMethodHandler
implements MethodHandler {
    private static final Logger log = Logging.get(MapInAdjacentPropertiesHandler.class);

    public Class<MapInAdjacentProperties> getAnnotationType() {
        return MapInAdjacentProperties.class;
    }

    public <E> DynamicType.Builder<E> processMethod(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return this.createInterceptor(builder, method);
        }
        if (methodName.startsWith("set")) {
            return this.createInterceptor(builder, method);
        }
        throw new WindupException("Only get* and set* method names are supported for @" + MapInAdjacentProperties.class.getSimpleName());
    }

    private <E> DynamicType.Builder<E> createInterceptor(DynamicType.Builder<E> builder, Method method) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(MapInAdjacentPropertiesInterceptor.class));
    }

    public static final class MapInAdjacentPropertiesInterceptor {
        @RuntimeType
        public static Object execute(@This ElementFrame thisFrame, @Origin Method method, @RuntimeType @AllArguments Object[] args) {
            MapInAdjacentProperties ann = (MapInAdjacentProperties)((CachesReflection)thisFrame).getReflectionCache().getAnnotation(method, MapInAdjacentProperties.class);
            Element thisElement = thisFrame.getElement();
            if (!(thisElement instanceof Vertex)) {
                throw new WindupException("Element is not of supported type, must be Vertex, but was: " + thisElement.getClass().getCanonicalName());
            }
            Vertex vertex = (Vertex)thisElement;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                return MapInAdjacentPropertiesInterceptor.handleGetter(vertex, method, args, ann);
            }
            if (methodName.startsWith("set")) {
                MapInAdjacentPropertiesInterceptor.handleSetter(vertex, method, args, ann, thisFrame.getGraph());
                return null;
            }
            throw new WindupException("Only get* and set* method names are supported for @" + MapInAdjacentProperties.class.getSimpleName());
        }

        private static Map<String, Serializable> handleGetter(Vertex vertex, Method method, Object[] args, MapInAdjacentProperties ann) {
            if (args != null && args.length != 0) {
                throw new WindupException("Method must take no arguments: " + method.getName());
            }
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            Iterator it = vertex.vertices(Direction.OUT, new String[]{ann.label()});
            Vertex mapVertex = null;
            if (!it.hasNext()) {
                return map;
            }
            mapVertex = (Vertex)it.next();
            if (it.hasNext()) {
                log.warning("Found multiple vertices for a map, using only first one; for: " + method.getName());
            }
            Set keys = mapVertex.keys();
            for (String key : keys) {
                VertexProperty val = mapVertex.property(key);
                if (!val.isPresent() || !(val.value() instanceof String)) {
                    log.warning("@InProperties is meant for Map<String,Serializable>, but the value was: " + val.getClass());
                }
                map.put(key, (Serializable)((Object)("" + val.value())));
            }
            return map;
        }

        private static void handleSetter(Vertex vertex, Method method, Object[] args, MapInAdjacentProperties ann, FramedGraph framedGraph) {
            if (args == null || args.length != 1) {
                throw new WindupException("Method must take one argument: " + method.getName());
            }
            if (!(args[0] instanceof Map)) {
                throw new WindupException("Argument of " + method.getName() + " must be a Map, but is: " + args[0].getClass());
            }
            if (!(framedGraph instanceof WrappedFramedGraph)) {
                throw new WindupException("Framed graph must be an instance of " + WrappedFramedGraph.class.getCanonicalName());
            }
            Graph graph = (Graph)((WrappedFramedGraph)framedGraph).getBaseGraph();
            Map map = (Map)args[0];
            Iterator it = vertex.vertices(Direction.OUT, new String[]{ann.label()});
            Vertex mapVertex = null;
            if (!it.hasNext()) {
                mapVertex = graph.addVertex(new Object[0]);
                vertex.addEdge(ann.label(), mapVertex, new Object[0]);
            } else {
                mapVertex = (Vertex)it.next();
                if (it.hasNext()) {
                    log.warning("Found multiple vertices for a map, using only first one; for: " + method.getName());
                }
            }
            Set keys = mapVertex.keys();
            Set mapKeys = map.keySet();
            for (String key : keys) {
                VertexProperty val = mapVertex.property(key);
                if (!val.isPresent() || !(val.value() instanceof String)) {
                    log.warning("@InProperties is meant for Map<String,Serializable>, but the value was: " + val.getClass());
                }
                if (map.containsKey(key)) {
                    mapVertex.property(key, (Object)((Serializable)map.get(key)));
                    mapKeys.remove(key);
                    continue;
                }
                val.remove();
            }
            for (String key : mapKeys) {
                mapVertex.property(key, (Object)((Serializable)map.get(key)));
            }
        }
    }
}

