/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec;

import javax.enterprise.inject.Vetoed;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.config.RuleUtils;
import org.jboss.windup.config.metadata.RuleMetadataType;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.util.ThemeProvider;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.Context;
import org.ocpsoft.rewrite.context.EvaluationContext;

@Vetoed
class DefaultRuleLifecycleListener
implements RuleLifecycleListener {
    private final WindupProgressMonitor progressMonitor;
    private final Configuration configuration;
    private String lastRuleProgressMessage = null;

    public DefaultRuleLifecycleListener(WindupProgressMonitor progressMonitor, Configuration configuration) {
        this.progressMonitor = progressMonitor;
        this.configuration = configuration;
    }

    public void beforeExecution(GraphRewrite event) {
        MutableInt count = new MutableInt(0);
        for (Rule rule : this.configuration.getRules()) {
            Context ruleContext;
            count.increment();
            Context context = ruleContext = rule instanceof Context ? (Context)rule : null;
            if (rule == null) {
                return;
            }
            AbstractRuleProvider ruleProvider = (AbstractRuleProvider)ruleContext.get((Object)RuleMetadataType.RULE_PROVIDER);
            if (ruleProvider == null) {
                return;
            }
            if (!ruleProvider.getMetadata().isDisabled()) continue;
            count.decrement();
        }
        this.progressMonitor.beginTask("Executing " + ThemeProvider.getInstance().getTheme().getBrandNameAcronym(), count.intValue());
        this.progressMonitor.worked(1);
    }

    public boolean beforeRuleEvaluation(GraphRewrite event, Rule rule, EvaluationContext context) {
        this.progressMonitor.subTask(RuleUtils.prettyPrintRule((Rule)rule));
        return this.progressMonitor.isCancelled();
    }

    public boolean ruleEvaluationProgress(GraphRewrite event, String name, int currentPosition, int total, int timeRemainingInSeconds) {
        int percentage = (int)(100.0 * ((double)currentPosition / (double)total));
        String timeRemaining = this.formatTimeRemaining(timeRemainingInSeconds);
        Object newProgressMessage = "(" + percentage + "%) " + name + ", Estimated time until next Rule: " + timeRemaining;
        if (!((String)newProgressMessage).equals(this.lastRuleProgressMessage)) {
            if (this.lastRuleProgressMessage != null && this.lastRuleProgressMessage.length() > ((String)newProgressMessage).length()) {
                newProgressMessage = String.format("%1$-" + this.lastRuleProgressMessage.length() + "s", newProgressMessage);
            }
            this.lastRuleProgressMessage = newProgressMessage;
            this.progressMonitor.subTask((String)newProgressMessage + "\r");
        }
        return this.progressMonitor.isCancelled();
    }

    private String formatTimeRemaining(int timeRemainingInSeconds) {
        int hours = timeRemainingInSeconds / 60 / 60;
        int minutes = (timeRemainingInSeconds - hours * 60 * 60) / 60;
        int seconds = timeRemainingInSeconds % 60;
        StringBuilder result = new StringBuilder();
        if (hours > 0) {
            result.append(hours).append(" hours, ");
        }
        if (hours > 0 || minutes > 0) {
            result.append(minutes).append(" minutes, ");
        }
        result.append(seconds).append(" seconds");
        return result.toString();
    }

    public void afterRuleConditionEvaluation(GraphRewrite event, EvaluationContext context, Rule rule, boolean result) {
        if (!result) {
            this.progressMonitor.worked(1);
        }
    }

    public boolean beforeRuleOperationsPerformed(GraphRewrite event, EvaluationContext context, Rule rule) {
        return this.progressMonitor.isCancelled();
    }

    public void afterRuleOperationsPerformed(GraphRewrite event, EvaluationContext context, Rule rule) {
        this.progressMonitor.worked(1);
    }

    public void afterRuleExecutionFailed(GraphRewrite event, EvaluationContext context, Rule rule, Throwable failureCause) {
    }

    public void afterExecution(GraphRewrite event) {
        this.progressMonitor.done();
    }

    public boolean shouldWindupStop() {
        return this.progressMonitor.isCancelled();
    }
}

