/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.generics;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.generics.TypeArgument;
import com.ibm.wala.types.generics.TypeSignature;
import java.util.StringTokenizer;

public class ClassTypeSignature
extends TypeSignature {
    ClassTypeSignature(String s) throws IllegalArgumentException {
        super(s);
        if (s.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (s.charAt(0) != 'L') {
            throw new IllegalArgumentException(s);
        }
        if (s.charAt(s.length() - 1) != ';') {
            throw new IllegalArgumentException(s);
        }
    }

    public static ClassTypeSignature makeClassTypeSig(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        return new ClassTypeSignature(s);
    }

    @Override
    public boolean isTypeVariable() {
        return false;
    }

    @Override
    public boolean isClassTypeSignature() {
        return true;
    }

    @Override
    public boolean isArrayTypeSignature() {
        return false;
    }

    public TypeName getRawName() {
        StringBuilder s = new StringBuilder();
        StringTokenizer t = new StringTokenizer(this.rawString(), ".");
        while (t.hasMoreTokens()) {
            String x = t.nextToken();
            s.append(x.replaceAll("<.*>", "").replace(";", ""));
            if (!t.hasMoreElements()) continue;
            s.append('$');
        }
        return TypeName.string2TypeName(s.toString());
    }

    public TypeArgument[] getTypeArguments() {
        int lastDot = this.rawString().lastIndexOf(46);
        if (this.rawString().indexOf(60, lastDot) == -1) {
            return null;
        }
        int start = this.rawString().indexOf(60, lastDot);
        int end = this.endOfTypeArguments();
        return TypeArgument.make(this.rawString().substring(start, end));
    }

    private int endOfTypeArguments() {
        int lastDot = this.rawString().lastIndexOf(46);
        int i = this.rawString().indexOf(60, lastDot) + 1;
        assert (i > 0);
        int depth = 1;
        while (depth > 0) {
            if (this.rawString().charAt(i) == '>') {
                --depth;
            }
            if (this.rawString().charAt(i) == '<') {
                ++depth;
            }
            ++i;
        }
        return i;
    }

    @Override
    public boolean isBaseType() {
        return false;
    }

    public static IClass lookupClass(IClassHierarchy cha, ClassTypeSignature sig) {
        if (sig == null) {
            throw new IllegalArgumentException("sig is null");
        }
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        TypeReference t = TypeReference.findOrCreate(ClassLoaderReference.Application, sig.getRawName());
        return cha.lookupClass(t);
    }
}

