/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyMethodTargetSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.ipa.summaries.SummarizedMethodWithNames;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BypassMethodTargetSelector
implements MethodTargetSelector {
    static final boolean DEBUG = false;
    private final Map<MethodReference, MethodSummary> methodSummaries;
    private final Set<Atom> ignoredPackages;
    protected final IClassHierarchy cha;
    protected final MethodTargetSelector parent;
    private final ClassHierarchyMethodTargetSelector chaMethodTargetSelector;
    private final HashMap<MethodReference, SummarizedMethod> syntheticMethods = HashMapFactory.make();

    public BypassMethodTargetSelector(MethodTargetSelector parent, Map<MethodReference, MethodSummary> methodSummaries, Set<Atom> ignoredPackages, IClassHierarchy cha) {
        this.methodSummaries = methodSummaries;
        this.ignoredPackages = ignoredPackages;
        this.parent = parent;
        this.cha = cha;
        this.chaMethodTargetSelector = new ClassHierarchyMethodTargetSelector(cha);
    }

    @Override
    public IMethod getCalleeTarget(CGNode caller, CallSiteReference site, IClass dispatchType) {
        IMethod target;
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        MethodReference ref = site.getDeclaredTarget();
        IMethod chaTarget = this.chaMethodTargetSelector.getCalleeTarget(caller, site, dispatchType);
        IMethod iMethod = target = chaTarget == null ? this.findOrCreateSyntheticMethod(ref, site.isStatic()) : this.findOrCreateSyntheticMethod(chaTarget, site.isStatic());
        if (dispatchType != null) {
            ref = MethodReference.findOrCreate(dispatchType.getReference(), ref.getSelector());
            chaTarget = this.chaMethodTargetSelector.getCalleeTarget(caller, site, dispatchType);
            IMethod iMethod2 = target = chaTarget == null ? this.findOrCreateSyntheticMethod(ref, site.isStatic()) : this.findOrCreateSyntheticMethod(chaTarget, site.isStatic());
        }
        if (target != null) {
            return target;
        }
        if (this.canIgnore(site.getDeclaredTarget())) {
            return this.findOrCreateSyntheticMethod(site.getDeclaredTarget(), site.isStatic());
        }
        if (this.parent.getClass() == ClassHierarchyMethodTargetSelector.class) {
            return chaTarget;
        }
        target = this.parent.getCalleeTarget(caller, site, dispatchType);
        if (target != null) {
            SyntheticMethod bypassTarget = this.findOrCreateSyntheticMethod(target, site.isStatic());
            return bypassTarget == null ? target : bypassTarget;
        }
        return target;
    }

    protected SyntheticMethod findOrCreateSyntheticMethod(MethodReference m, boolean isStatic) {
        IClass C;
        TypeReference T;
        if (this.syntheticMethods.containsKey(m)) {
            return this.syntheticMethods.get(m);
        }
        MethodSummary summ = null;
        if (this.canIgnore(m)) {
            T = m.getDeclaringClass();
            C = this.cha.lookupClass(T);
            if (C == null) {
                this.syntheticMethods.put(m, null);
                return null;
            }
            summ = this.generateNoOp(m, isStatic);
        } else {
            summ = this.findSummary(m);
        }
        if (summ != null) {
            T = m.getDeclaringClass();
            C = this.cha.lookupClass(T);
            if (C == null) {
                this.syntheticMethods.put(m, null);
                return null;
            }
            SummarizedMethodWithNames n = new SummarizedMethodWithNames(m, summ, C);
            this.syntheticMethods.put(m, n);
            return n;
        }
        this.syntheticMethods.put(m, null);
        return null;
    }

    protected SyntheticMethod findOrCreateSyntheticMethod(IMethod m, boolean isStatic) {
        MethodReference ref = m.getReference();
        if (this.syntheticMethods.containsKey(ref)) {
            return this.syntheticMethods.get(ref);
        }
        MethodSummary summ = null;
        summ = this.canIgnore(ref) ? this.generateNoOp(ref, isStatic) : this.findSummary(ref);
        if (summ != null) {
            SummarizedMethod n = new SummarizedMethod(ref, summ, m.getDeclaringClass());
            this.syntheticMethods.put(ref, n);
            return n;
        }
        this.syntheticMethods.put(ref, null);
        return null;
    }

    public static MethodSummary generateStandardNoOp(Language l, MethodReference m, boolean isStatic) {
        return new NoOpSummary(l, m, isStatic);
    }

    public MethodSummary generateNoOp(MethodReference m, boolean isStatic) {
        Language l = this.cha.resolveMethod(m).getDeclaringClass().getClassLoader().getLanguage();
        return new NoOpSummary(l, m, isStatic);
    }

    protected boolean canIgnore(MemberReference m) {
        TypeReference T = m.getDeclaringClass();
        TypeName n = T.getName();
        Atom p = n.getPackage();
        return this.ignoredPackages.contains(p);
    }

    private MethodSummary findSummary(MemberReference m) {
        return this.methodSummaries.get(m);
    }

    protected IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    private static class NoOpSummary
    extends MethodSummary {
        private final Language l;

        public NoOpSummary(Language l, MethodReference method, boolean isStatic) {
            super(method);
            this.setStatic(isStatic);
            this.l = l;
        }

        @Override
        public SSAInstruction[] getStatements() {
            if (this.getReturnType().equals(TypeReference.Void)) {
                return NO_STATEMENTS;
            }
            int nullValue = this.getNumberOfParameters() + 1;
            SSAInstruction[] result = new SSAInstruction[1];
            SSAInstructionFactory insts = this.l.instructionFactory();
            result[0] = insts.ReturnInstruction(0, nullValue, this.getReturnType().isPrimitiveType());
            return result;
        }
    }
}

