/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCallee;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCaller;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.ISDG;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.NormalReturnCallee;
import com.ibm.wala.ipa.slicer.NormalReturnCaller;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.PDG;
import com.ibm.wala.ipa.slicer.ParamCallee;
import com.ibm.wala.ipa.slicer.ParamCaller;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.IteratorUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.SlowNumberedNodeManager;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class SDG<T extends InstanceKey>
extends AbstractNumberedGraph<Statement>
implements ISDG {
    private static final boolean DEBUG_LAZY = false;
    private final Nodes nodeMgr = new Nodes();
    private final Edges edgeMgr = new Edges();
    private final CallGraph cg;
    private final PointerAnalysis<T> pa;
    private final Map<CGNode, PDG<T>> pdgMap = HashMapFactory.make();
    private final Slicer.DataDependenceOptions dOptions;
    private final Slicer.ControlDependenceOptions cOptions;
    private final Map<CGNode, OrdinalSet<PointerKey>> mod;
    private final Map<CGNode, OrdinalSet<PointerKey>> ref;
    private final Collection<CGNode> statementsAdded = HashSetFactory.make();
    private final HeapExclusions heapExclude;
    private final ModRef<T> modRef;
    private boolean eagerComputed = false;

    public SDG(CallGraph cg, PointerAnalysis<T> pa, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions) {
        this(cg, pa, new ModRef(), dOptions, cOptions, null);
    }

    public SDG(CallGraph cg, PointerAnalysis<T> pa, ModRef<T> modRef, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions) {
        this(cg, pa, modRef, dOptions, cOptions, null);
    }

    public SDG(CallGraph cg, PointerAnalysis<T> pa, ModRef<T> modRef, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions, HeapExclusions heapExclude) throws IllegalArgumentException {
        if (dOptions == null) {
            throw new IllegalArgumentException("dOptions must not be null");
        }
        this.modRef = modRef;
        this.cg = cg;
        this.pa = pa;
        this.mod = dOptions.isIgnoreHeap() ? null : modRef.computeMod(cg, pa, heapExclude);
        this.ref = dOptions.isIgnoreHeap() ? null : modRef.computeRef(cg, pa, heapExclude);
        this.dOptions = dOptions;
        this.cOptions = cOptions;
        this.heapExclude = heapExclude;
    }

    public String toString() {
        this.eagerConstruction();
        return super.toString();
    }

    private void eagerConstruction() {
        if (!this.eagerComputed) {
            this.eagerComputed = true;
            this.computeAllPDGs();
            for (PDG<T> pdg : this.pdgMap.values()) {
                this.addPDGStatementNodes(pdg.getCallGraphNode());
            }
        }
    }

    private void addPDGStatementNodes(CGNode node) {
        if (!this.statementsAdded.contains(node)) {
            this.statementsAdded.add(node);
            PDG<T> pdg = this.getPDG(node);
            Iterator<Statement> iterator = pdg.iterator();
            while (iterator.hasNext()) {
                Statement statement = iterator.next();
                this.addNode(statement);
            }
        }
    }

    private void computeAllPDGs() {
        Iterator iterator = this.cg.iterator();
        while (iterator.hasNext()) {
            CGNode n = (CGNode)iterator.next();
            this.getPDG(n);
        }
    }

    @Override
    public Iterator<? extends Statement> iterateLazyNodes() {
        return this.nodeMgr.iterateLazyNodes();
    }

    protected NumberedEdgeManager<Statement> getEdgeManager() {
        return this.edgeMgr;
    }

    public NumberedNodeManager<Statement> getNodeManager() {
        return this.nodeMgr;
    }

    public PDG<T> getPDG(CGNode node) {
        PDG<T> result = this.pdgMap.get(node);
        if (result == null) {
            result = new PDG<T>(node, this.pa, this.mod, this.ref, this.dOptions, this.cOptions, this.heapExclude, this.cg, this.modRef);
            this.pdgMap.put(node, result);
        }
        return result;
    }

    @Override
    public Slicer.ControlDependenceOptions getCOptions() {
        return this.cOptions;
    }

    public Slicer.DataDependenceOptions getDOptions() {
        return this.dOptions;
    }

    public CallGraph getCallGraph() {
        return this.cg;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cg.getClassHierarchy();
    }

    public PointerAnalysis<T> getPointerAnalysis() {
        return this.pa;
    }

    private class Edges
    implements NumberedEdgeManager<Statement> {
        private Edges() {
        }

        public void addEdge(Statement src, Statement dst) {
            Assertions.UNREACHABLE();
        }

        public int getPredNodeCount(Statement N) {
            return IteratorUtil.count(this.getPredNodes(N));
        }

        public Iterator<Statement> getPredNodes(Statement N) {
            if (SDG.this.dOptions.isIgnoreExceptions()) {
                assert (!N.getKind().equals((Object)Statement.Kind.EXC_RET_CALLEE));
                assert (!N.getKind().equals((Object)Statement.Kind.EXC_RET_CALLER));
            }
            SDG.this.addPDGStatementNodes(N.getNode());
            switch (N.getKind()) {
                case NORMAL: 
                case PHI: 
                case PI: 
                case EXC_RET_CALLEE: 
                case NORMAL_RET_CALLEE: 
                case PARAM_CALLER: 
                case HEAP_PARAM_CALLER: 
                case HEAP_RET_CALLEE: 
                case CATCH: 
                case METHOD_EXIT: {
                    return SDG.this.getPDG(N.getNode()).getPredNodes(N);
                }
                case EXC_RET_CALLER: {
                    ExceptionalReturnCaller nrc = (ExceptionalReturnCaller)N;
                    SSAAbstractInvokeInstruction call = nrc.getInstruction();
                    Iterator2Set result = Iterator2Collection.toSet(SDG.this.getPDG(N.getNode()).getPredNodes(N));
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode t : SDG.this.cg.getPossibleTargets(N.getNode(), call.getCallSite())) {
                            ExceptionalReturnCallee s = new ExceptionalReturnCallee(t);
                            SDG.this.addNode(s);
                            result.add(s);
                        }
                    }
                    return result.iterator();
                }
                case NORMAL_RET_CALLER: {
                    NormalReturnCaller nrc = (NormalReturnCaller)N;
                    SSAAbstractInvokeInstruction call = nrc.getInstruction();
                    Iterator2Set result = Iterator2Collection.toSet(SDG.this.getPDG(N.getNode()).getPredNodes(N));
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode t : SDG.this.cg.getPossibleTargets(N.getNode(), call.getCallSite())) {
                            NormalReturnCallee s = new NormalReturnCallee(t);
                            SDG.this.addNode(s);
                            result.add(s);
                        }
                    }
                    return result.iterator();
                }
                case HEAP_RET_CALLER: {
                    HeapStatement.HeapReturnCaller r = (HeapStatement.HeapReturnCaller)N;
                    SSAAbstractInvokeInstruction call = r.getCall();
                    Iterator2Set result = Iterator2Collection.toSet(SDG.this.getPDG(N.getNode()).getPredNodes(N));
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode t : SDG.this.cg.getPossibleTargets(N.getNode(), call.getCallSite())) {
                            if (!((OrdinalSet)SDG.this.mod.get(t)).contains((Object)r.getLocation())) continue;
                            HeapStatement.HeapReturnCallee s = new HeapStatement.HeapReturnCallee(t, r.getLocation());
                            SDG.this.addNode(s);
                            result.add(s);
                        }
                    }
                    return result.iterator();
                }
                case PARAM_CALLEE: {
                    ParamCallee pac = (ParamCallee)N;
                    int parameterIndex = pac.getValueNumber() - 1;
                    HashSet result = HashSetFactory.make((int)5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        if (SDG.this.dOptions.isTerminateAtCast() && !pac.getNode().getMethod().isStatic() && pac.getValueNumber() == 1) {
                            return EmptyIterator.instance();
                        }
                        if (SDG.this.dOptions.isTerminateAtCast() && this.isUninformativeForReflection(pac.getNode())) {
                            return EmptyIterator.instance();
                        }
                        for (CGNode caller : Iterator2Iterable.make((Iterator)SDG.this.cg.getPredNodes(N.getNode()))) {
                            for (CallSiteReference site : Iterator2Iterable.make(SDG.this.cg.getPossibleSites(caller, N.getNode()))) {
                                IR ir = caller.getIR();
                                IntSet indices = ir.getCallInstructionIndices(site);
                                IntIterator ii = indices.intIterator();
                                while (ii.hasNext()) {
                                    int i = ii.next();
                                    SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)ir.getInstructions()[i];
                                    if (call.getNumberOfUses() <= parameterIndex) continue;
                                    int p = call.getUse(parameterIndex);
                                    ParamCaller s = new ParamCaller(caller, i, p);
                                    SDG.this.addNode(s);
                                    result.add(s);
                                }
                            }
                        }
                    }
                    return result.iterator();
                }
                case HEAP_PARAM_CALLEE: {
                    HeapStatement.HeapParamCallee hpc = (HeapStatement.HeapParamCallee)N;
                    HashSet result = HashSetFactory.make((int)5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode caller : Iterator2Iterable.make((Iterator)SDG.this.cg.getPredNodes(N.getNode()))) {
                            for (CallSiteReference site : Iterator2Iterable.make(SDG.this.cg.getPossibleSites(caller, N.getNode()))) {
                                IR ir = caller.getIR();
                                IntSet indices = ir.getCallInstructionIndices(site);
                                IntIterator ii = indices.intIterator();
                                while (ii.hasNext()) {
                                    int i = ii.next();
                                    HeapStatement.HeapParamCaller s = new HeapStatement.HeapParamCaller(caller, i, hpc.getLocation());
                                    SDG.this.addNode(s);
                                    result.add(s);
                                }
                            }
                        }
                    }
                    return result.iterator();
                }
                case METHOD_ENTRY: {
                    HashSet result = HashSetFactory.make((int)5);
                    if (!SDG.this.cOptions.isIgnoreInterproc()) {
                        for (CGNode caller : Iterator2Iterable.make((Iterator)SDG.this.cg.getPredNodes(N.getNode()))) {
                            for (CallSiteReference site : Iterator2Iterable.make(SDG.this.cg.getPossibleSites(caller, N.getNode()))) {
                                IR ir = caller.getIR();
                                IntSet indices = ir.getCallInstructionIndices(site);
                                IntIterator ii = indices.intIterator();
                                while (ii.hasNext()) {
                                    int i = ii.next();
                                    NormalStatement s = new NormalStatement(caller, i);
                                    SDG.this.addNode(s);
                                    result.add(s);
                                }
                            }
                        }
                    }
                    return result.iterator();
                }
            }
            Assertions.UNREACHABLE((String)N.getKind().toString());
            return null;
        }

        public int getSuccNodeCount(Statement N) {
            return IteratorUtil.count(this.getSuccNodes(N));
        }

        public Iterator<Statement> getSuccNodes(Statement N) {
            if (SDG.this.dOptions.isTerminateAtCast() && this.isUninformativeForReflection(N.getNode())) {
                return EmptyIterator.instance();
            }
            SDG.this.addPDGStatementNodes(N.getNode());
            switch (N.getKind()) {
                case NORMAL: {
                    if (SDG.this.cOptions.isIgnoreInterproc()) {
                        return SDG.this.getPDG(N.getNode()).getSuccNodes(N);
                    }
                    NormalStatement ns = (NormalStatement)N;
                    if (ns.getInstruction() instanceof SSAAbstractInvokeInstruction) {
                        HashSet result = HashSetFactory.make();
                        SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)ns.getInstruction();
                        for (CGNode t : SDG.this.cg.getPossibleTargets(N.getNode(), call.getCallSite())) {
                            MethodEntryStatement s = new MethodEntryStatement(t);
                            SDG.this.addNode(s);
                            result.add(s);
                        }
                        return new CompoundIterator(result.iterator(), SDG.this.getPDG(N.getNode()).getSuccNodes(N));
                    }
                    return SDG.this.getPDG(N.getNode()).getSuccNodes(N);
                }
                case PHI: 
                case PI: 
                case CATCH: 
                case METHOD_EXIT: 
                case EXC_RET_CALLER: 
                case NORMAL_RET_CALLER: 
                case HEAP_RET_CALLER: 
                case PARAM_CALLEE: 
                case HEAP_PARAM_CALLEE: 
                case METHOD_ENTRY: {
                    return SDG.this.getPDG(N.getNode()).getSuccNodes(N);
                }
                case EXC_RET_CALLEE: {
                    HashSet result = HashSetFactory.make((int)5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode caller : Iterator2Iterable.make((Iterator)SDG.this.cg.getPredNodes(N.getNode()))) {
                            for (CallSiteReference site : Iterator2Iterable.make(SDG.this.cg.getPossibleSites(caller, N.getNode()))) {
                                IR ir = caller.getIR();
                                IntSet indices = ir.getCallInstructionIndices(site);
                                IntIterator ii = indices.intIterator();
                                while (ii.hasNext()) {
                                    int i = ii.next();
                                    ExceptionalReturnCaller s = new ExceptionalReturnCaller(caller, i);
                                    SDG.this.addNode(s);
                                    result.add(s);
                                }
                            }
                        }
                    }
                    return result.iterator();
                }
                case NORMAL_RET_CALLEE: {
                    HashSet result = HashSetFactory.make((int)5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode caller : Iterator2Iterable.make((Iterator)SDG.this.cg.getPredNodes(N.getNode()))) {
                            for (CallSiteReference site : Iterator2Iterable.make(SDG.this.cg.getPossibleSites(caller, N.getNode()))) {
                                IR ir = caller.getIR();
                                IntSet indices = ir.getCallInstructionIndices(site);
                                IntIterator ii = indices.intIterator();
                                while (ii.hasNext()) {
                                    int i = ii.next();
                                    NormalReturnCaller s = new NormalReturnCaller(caller, i);
                                    SDG.this.addNode(s);
                                    result.add(s);
                                }
                            }
                        }
                    }
                    return result.iterator();
                }
                case HEAP_RET_CALLEE: {
                    HeapStatement.HeapReturnCallee r = (HeapStatement.HeapReturnCallee)N;
                    HashSet result = HashSetFactory.make((int)5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode caller : Iterator2Iterable.make((Iterator)SDG.this.cg.getPredNodes(N.getNode()))) {
                            for (CallSiteReference site : Iterator2Iterable.make(SDG.this.cg.getPossibleSites(caller, N.getNode()))) {
                                IR ir = caller.getIR();
                                IntSet indices = ir.getCallInstructionIndices(site);
                                IntIterator ii = indices.intIterator();
                                while (ii.hasNext()) {
                                    int i = ii.next();
                                    HeapStatement.HeapReturnCaller s = new HeapStatement.HeapReturnCaller(caller, i, r.getLocation());
                                    SDG.this.addNode(s);
                                    result.add(s);
                                }
                            }
                        }
                    }
                    return result.iterator();
                }
                case PARAM_CALLER: {
                    ParamCaller pac = (ParamCaller)N;
                    SSAAbstractInvokeInstruction call = pac.getInstruction();
                    int numParamsPassed = call.getNumberOfUses();
                    HashSet result = HashSetFactory.make((int)5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode t : SDG.this.cg.getPossibleTargets(N.getNode(), call.getCallSite())) {
                            for (int i = 0; i < t.getMethod().getNumberOfParameters() && i < numParamsPassed; ++i) {
                                if (SDG.this.dOptions.isTerminateAtCast() && call.isDispatch() && pac.getValueNumber() == call.getReceiver() || SDG.this.dOptions.isTerminateAtCast() && this.isUninformativeForReflection(t) || call.getUse(i) != pac.getValueNumber()) continue;
                                ParamCallee s = new ParamCallee(t, i + 1);
                                SDG.this.addNode(s);
                                result.add(s);
                            }
                        }
                    }
                    return result.iterator();
                }
                case HEAP_PARAM_CALLER: {
                    HeapStatement.HeapParamCaller pc = (HeapStatement.HeapParamCaller)N;
                    SSAAbstractInvokeInstruction call = pc.getCall();
                    HashSet result = HashSetFactory.make((int)5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode t : SDG.this.cg.getPossibleTargets(N.getNode(), call.getCallSite())) {
                            if (!((OrdinalSet)SDG.this.ref.get(t)).contains((Object)pc.getLocation())) continue;
                            HeapStatement.HeapParamCallee s = new HeapStatement.HeapParamCallee(t, pc.getLocation());
                            SDG.this.addNode(s);
                            result.add(s);
                        }
                    }
                    return result.iterator();
                }
            }
            Assertions.UNREACHABLE((String)N.getKind().toString());
            return null;
        }

        private boolean isUninformativeForReflection(CGNode t) {
            if (t.getMethod().getDeclaringClass().getReference().equals(TypeReference.JavaLangReflectMethod)) {
                return true;
            }
            if (t.getMethod().getDeclaringClass().getReference().equals(TypeReference.JavaLangReflectConstructor)) {
                return true;
            }
            return t.getMethod().getSelector().equals(MethodReference.equalsSelector);
        }

        public boolean hasEdge(Statement src, Statement dst) {
            SDG.this.addPDGStatementNodes(src.getNode());
            SDG.this.addPDGStatementNodes(dst.getNode());
            switch (src.getKind()) {
                case NORMAL: {
                    if (SDG.this.cOptions.isIgnoreInterproc()) {
                        return SDG.this.getPDG(src.getNode()).hasEdge(src, dst);
                    }
                    NormalStatement ns = (NormalStatement)src;
                    if (dst instanceof MethodEntryStatement) {
                        if (ns.getInstruction() instanceof SSAAbstractInvokeInstruction) {
                            SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)ns.getInstruction();
                            return SDG.this.cg.getPossibleTargets(src.getNode(), call.getCallSite()).contains(dst.getNode());
                        }
                        return false;
                    }
                    return SDG.this.getPDG(src.getNode()).hasEdge(src, dst);
                }
                case PHI: 
                case PI: 
                case METHOD_EXIT: 
                case EXC_RET_CALLER: 
                case NORMAL_RET_CALLER: 
                case HEAP_RET_CALLER: 
                case PARAM_CALLEE: 
                case HEAP_PARAM_CALLEE: 
                case METHOD_ENTRY: {
                    return SDG.this.getPDG(src.getNode()).hasEdge(src, dst);
                }
                case EXC_RET_CALLEE: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (dst.getKind().equals((Object)Statement.Kind.EXC_RET_CALLER)) {
                        ExceptionalReturnCaller r = (ExceptionalReturnCaller)dst;
                        return SDG.this.cg.getPossibleTargets(r.getNode(), r.getInstruction().getCallSite()).contains(src.getNode());
                    }
                    return false;
                }
                case NORMAL_RET_CALLEE: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (dst.getKind().equals((Object)Statement.Kind.NORMAL_RET_CALLER)) {
                        NormalReturnCaller r = (NormalReturnCaller)dst;
                        return SDG.this.cg.getPossibleTargets(r.getNode(), r.getInstruction().getCallSite()).contains(src.getNode());
                    }
                    return false;
                }
                case HEAP_RET_CALLEE: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (dst.getKind().equals((Object)Statement.Kind.HEAP_RET_CALLER)) {
                        HeapStatement.HeapReturnCaller r = (HeapStatement.HeapReturnCaller)dst;
                        HeapStatement h = (HeapStatement)src;
                        return h.getLocation().equals(r.getLocation()) && SDG.this.cg.getPossibleTargets(r.getNode(), r.getCall().getCallSite()).contains(src.getNode());
                    }
                    return false;
                }
                case PARAM_CALLER: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (dst.getKind().equals((Object)Statement.Kind.PARAM_CALLEE)) {
                        ParamCallee callee = (ParamCallee)dst;
                        ParamCaller caller = (ParamCaller)src;
                        SSAAbstractInvokeInstruction call = caller.getInstruction();
                        CGNode calleeNode = callee.getNode();
                        if (!SDG.this.cg.getPossibleTargets(caller.getNode(), call.getCallSite()).contains(calleeNode)) {
                            return false;
                        }
                        if (SDG.this.dOptions.isTerminateAtCast() && call.isDispatch() && caller.getValueNumber() == call.getReceiver()) {
                            return false;
                        }
                        if (SDG.this.dOptions.isTerminateAtCast() && this.isUninformativeForReflection(calleeNode)) {
                            return false;
                        }
                        for (int i = 0; i < call.getNumberOfPositionalParameters(); ++i) {
                            if (call.getUse(i) != caller.getValueNumber() || callee.getValueNumber() != i + 1) continue;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                case HEAP_PARAM_CALLER: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (dst.getKind().equals((Object)Statement.Kind.HEAP_PARAM_CALLEE)) {
                        HeapStatement.HeapParamCallee callee = (HeapStatement.HeapParamCallee)dst;
                        HeapStatement.HeapParamCaller caller = (HeapStatement.HeapParamCaller)src;
                        return caller.getLocation().equals(callee.getLocation()) && SDG.this.cg.getPossibleTargets(caller.getNode(), caller.getCall().getCallSite()).contains(callee.getNode());
                    }
                    return false;
                }
            }
            Assertions.UNREACHABLE((Object)((Object)src.getKind()));
            return false;
        }

        public void removeAllIncidentEdges(Statement node) {
            Assertions.UNREACHABLE();
        }

        public void removeEdge(Statement src, Statement dst) {
            Assertions.UNREACHABLE();
        }

        public void removeIncomingEdges(Statement node) {
            Assertions.UNREACHABLE();
        }

        public void removeOutgoingEdges(Statement node) {
            Assertions.UNREACHABLE();
        }

        public IntSet getPredNodeNumbers(Statement node) {
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            for (Statement s : Iterator2Iterable.make(this.getPredNodes(node))) {
                result.add(SDG.this.getNumber(s));
            }
            return result;
        }

        public IntSet getSuccNodeNumbers(Statement node) {
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            for (Statement s : Iterator2Iterable.make(this.getSuccNodes(node))) {
                result.add(SDG.this.getNumber(s));
            }
            return result;
        }
    }

    private class Nodes
    extends SlowNumberedNodeManager<Statement> {
        private static final long serialVersionUID = -1450214776332091211L;

        private Nodes() {
        }

        public boolean containsNode(Statement N) {
            if (super.containsNode((Object)N)) {
                return true;
            }
            SDG.this.eagerConstruction();
            return super.containsNode((Object)N);
        }

        public int getMaxNumber() {
            SDG.this.eagerConstruction();
            return super.getMaxNumber();
        }

        public Statement getNode(int number) {
            Statement s = this.getNodeLazy(number);
            if (s != null) {
                return s;
            }
            SDG.this.eagerConstruction();
            return (Statement)super.getNode(number);
        }

        public int getNumber(Statement s) {
            CGNode n = s.getNode();
            SDG.this.addPDGStatementNodes(n);
            return super.getNumber((Object)s);
        }

        public Iterator<Statement> iterateNodes(IntSet s) {
            Assertions.UNREACHABLE();
            return super.iterateNodes(s);
        }

        public Iterator<Statement> iterator() {
            SDG.this.eagerConstruction();
            return super.iterator();
        }

        Iterator<? extends Statement> iterateLazyNodes() {
            return super.iterator();
        }

        public Statement getNodeLazy(int number) {
            return (Statement)super.getNode(number);
        }

        public int getNumberOfNodes() {
            SDG.this.eagerConstruction();
            return super.getNumberOfNodes();
        }
    }
}

