/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.analysis.reflection.JavaTypeContext;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverInstanceContext;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.DelegatingNumberedNodeManager;
import com.ibm.wala.util.graph.impl.NodeWithNumber;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class BasicCallGraph<T>
extends AbstractNumberedGraph<CGNode>
implements CallGraph {
    private static final boolean DEBUG = false;
    private final DelegatingNumberedNodeManager<CGNode> nodeManager = new DelegatingNumberedNodeManager();
    private CGNode fakeRoot;
    private CGNode fakeWorldClinit;
    private T interpreter;
    private final Set<CGNode> entrypointNodes = HashSetFactory.make();
    private final Map<Key, CGNode> nodes = HashMapFactory.make();
    protected final Map<MethodReference, Set<CGNode>> mr2Nodes = HashMapFactory.make();

    public void init() throws CancelException {
        this.fakeRoot = this.makeFakeRootNode();
        Key k = new Key(this.fakeRoot.getMethod(), this.fakeRoot.getContext());
        this.registerNode(k, this.fakeRoot);
        this.fakeWorldClinit = this.makeFakeWorldClinitNode();
        if (this.fakeWorldClinit != null) {
            k = new Key(this.fakeWorldClinit.getMethod(), this.fakeWorldClinit.getContext());
            this.registerNode(k, this.fakeWorldClinit);
            CallSiteReference site = CallSiteReference.make(1, this.fakeWorldClinit.getMethod().getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
            site = ((AbstractRootMethod)this.fakeRoot.getMethod()).addInvocation(null, site).getCallSite();
            this.fakeRoot.addTarget(site, this.fakeWorldClinit);
        }
    }

    protected abstract CGNode makeFakeRootNode() throws CancelException;

    protected abstract CGNode makeFakeWorldClinitNode() throws CancelException;

    public abstract CGNode findOrCreateNode(IMethod var1, Context var2) throws CancelException;

    protected void registerNode(Key K, CGNode N) {
        this.nodes.put(K, N);
        this.addNode(N);
        Set<CGNode> s = this.findOrCreateMr2Nodes(K.m);
        s.add(N);
    }

    private Set<CGNode> findOrCreateMr2Nodes(IMethod method) {
        HashSet result = this.mr2Nodes.get(method.getReference());
        if (result == null) {
            result = HashSetFactory.make((int)3);
            this.mr2Nodes.put(method.getReference(), result);
        }
        return result;
    }

    protected CGNode getNode(Key K) {
        return this.nodes.get(K);
    }

    @Override
    public CGNode getFakeRootNode() {
        return this.fakeRoot;
    }

    @Override
    public CGNode getFakeWorldClinitNode() {
        return this.fakeWorldClinit;
    }

    public void registerEntrypoint(CGNode node) {
        this.entrypointNodes.add(node);
    }

    @Override
    public Collection<CGNode> getEntrypointNodes() {
        return this.entrypointNodes;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (CGNode n : Iterator2Iterable.make((Iterator)DFS.iterateDiscoverTime((Graph)this, (Iterator)new NonNullSingletonIterator((Object)this.getFakeRootNode())))) {
            result.append(BasicCallGraph.nodeToString(this, n)).append('\n');
        }
        return result.toString();
    }

    public static String nodeToString(CallGraph CG, CGNode n) {
        StringBuilder result = new StringBuilder(n.toString() + '\n');
        if (n.getMethod() != null) {
            for (CallSiteReference site : Iterator2Iterable.make(n.iterateCallSites())) {
                Iterator<CGNode> targets = CG.getPossibleTargets(n, site).iterator();
                if (targets.hasNext()) {
                    result.append(" - ").append(site).append('\n');
                }
                for (CGNode target : Iterator2Iterable.make(targets)) {
                    result.append("     -> ").append(target).append('\n');
                }
            }
        }
        return result.toString();
    }

    public void removeNodeAndEdges(CGNode N) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public CGNode getNode(IMethod method, Context C) {
        Key key = new Key(method, C);
        return this.getNode(key);
    }

    @Override
    public Set<CGNode> getNodes(MethodReference m) {
        Set<CGNode> result;
        IMethod im = this.getClassHierarchy().resolveMethod(m);
        if (im != null) {
            m = im.getReference();
        }
        return (result = this.mr2Nodes.get(m)) == null ? Collections.emptySet() : result;
    }

    protected T getInterpreter(CGNode node) {
        if (this.interpreter == null) {
            throw new IllegalStateException("must register an interpreter for this call graph");
        }
        return this.interpreter;
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public Iterator<CGNode> iterator() {
        return this.nodes.values().iterator();
    }

    public boolean containsNode(CGNode N) {
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        return this.getNode(N.getMethod(), N.getContext()) != null;
    }

    public void setInterpreter(T interpreter) {
        this.interpreter = interpreter;
    }

    protected NumberedNodeManager<CGNode> getNodeManager() {
        return this.nodeManager;
    }

    public void summarizeByPackage() {
        HashMap packages = HashMapFactory.make();
        Iterator<Object> iterator = this.iterator();
        block0: while (iterator.hasNext()) {
            CGNode cGNode = iterator.next();
            StringBuilder nmBuilder = new StringBuilder(cGNode.getMethod().getDeclaringClass().getName().toString()).append('/').append(cGNode.getMethod().getName()).append('/').append(cGNode.getContext().getClass().toString());
            if (cGNode.getContext().isA(ReceiverInstanceContext.class)) {
                nmBuilder.append('/').append(((InstanceKey)cGNode.getContext().get(ContextKey.RECEIVER)).getConcreteType().getName());
            } else if (cGNode.getContext() instanceof JavaTypeContext) {
                nmBuilder.append('/').append(((TypeAbstraction)cGNode.getContext().get(ContextKey.RECEIVER)).getTypeReference().getName());
            }
            String nm = nmBuilder.toString();
            while (true) {
                if (packages.containsKey(nm)) {
                    packages.put(nm, 1 + (Integer)packages.get(nm));
                } else {
                    packages.put(nm, 1);
                }
                if (nm.indexOf(47) < 0) continue block0;
                nm = nm.substring(0, nm.lastIndexOf(47));
            }
        }
        System.err.println("dump of CG");
        for (Map.Entry entry : packages.entrySet()) {
            System.err.println(entry + " " + (String)entry.getKey());
        }
    }

    protected static final class Key {
        private final IMethod m;
        private final Context C;

        public Key(IMethod m, Context C) {
            assert (m != null) : "null method";
            assert (C != null) : "null context";
            this.m = m;
            this.C = C;
        }

        public int hashCode() {
            return 17 * this.m.hashCode() + this.C.hashCode();
        }

        public boolean equals(Object o) {
            assert (o instanceof Key);
            Key other = (Key)o;
            return this.m.equals(other.m) && this.C.equals(other.C);
        }

        public String toString() {
            return "{" + this.m + ',' + this.C + '}';
        }
    }

    public static abstract class NodeImpl
    extends NodeWithNumber
    implements CGNode {
        protected final IMethod method;
        private final Context context;

        protected NodeImpl(IMethod method, Context C) {
            this.method = method;
            this.context = C;
            if (method != null && !method.isWalaSynthetic() && method.isAbstract()) assert (!method.isAbstract()) : "Abstract method " + method;
            assert (C != null);
        }

        @Override
        public IMethod getMethod() {
            return this.method;
        }

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        public String toString() {
            return "Node: " + this.method.toString() + " Context: " + this.context.toString();
        }

        @Override
        public Context getContext() {
            return this.context;
        }

        @Override
        public IClassHierarchy getClassHierarchy() {
            return this.method.getClassHierarchy();
        }
    }
}

