/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg;

import com.ibm.wala.analysis.reflection.InstanceKeyWithNode;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.demandpa.alg.AbstractDemandPointsTo;
import com.ibm.wala.demandpa.alg.BudgetExceededException;
import com.ibm.wala.demandpa.alg.InstanceFieldKeyAndState;
import com.ibm.wala.demandpa.alg.InstanceKeyAndState;
import com.ibm.wala.demandpa.alg.PointerKeyAndState;
import com.ibm.wala.demandpa.alg.ThisFilteringHeapModel;
import com.ibm.wala.demandpa.alg.WithState;
import com.ibm.wala.demandpa.alg.refinepolicy.NeverRefineCGPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.NeverRefineFieldsPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicyFactory;
import com.ibm.wala.demandpa.alg.refinepolicy.SinglePassRefinementPolicy;
import com.ibm.wala.demandpa.alg.statemachine.StateMachine;
import com.ibm.wala.demandpa.alg.statemachine.StateMachineFactory;
import com.ibm.wala.demandpa.alg.statemachine.StatesMergedException;
import com.ibm.wala.demandpa.flowgraph.AbstractFlowGraph;
import com.ibm.wala.demandpa.flowgraph.AbstractFlowLabelVisitor;
import com.ibm.wala.demandpa.flowgraph.AssignBarLabel;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalBarLabel;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.DemandPointerFlowGraph;
import com.ibm.wala.demandpa.flowgraph.GetFieldLabel;
import com.ibm.wala.demandpa.flowgraph.IFlowGraph;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.flowgraph.IFlowLabelWithFilter;
import com.ibm.wala.demandpa.flowgraph.MatchBarLabel;
import com.ibm.wala.demandpa.flowgraph.MatchLabel;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.flowgraph.ParamBarLabel;
import com.ibm.wala.demandpa.flowgraph.ParamLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldLabel;
import com.ibm.wala.demandpa.flowgraph.ReturnBarLabel;
import com.ibm.wala.demandpa.flowgraph.ReturnLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.demandpa.util.PointerParamValueNumIterator;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ExceptionReturnValueKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.util.collections.ArraySet;
import com.ibm.wala.util.collections.ArraySetMultiMap;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.HashSetMultiMap;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.collections.MultiMap;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.collections.Util;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class DemandRefinementPointsTo
extends AbstractDemandPointsTo {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_TOPLEVEL = false;
    private static final boolean PARANOID = false;
    private static final boolean MEASURE_MEMORY_USAGE = false;
    protected final IFlowGraph g;
    private StateMachineFactory<IFlowLabel> stateMachineFactory;
    private StateMachine<IFlowLabel> stateMachine;
    protected RefinementPolicy refinementPolicy;
    private RefinementPolicyFactory refinementPolicyFactory;
    public long lastQueryMemoryUse;

    public RefinementPolicy getRefinementPolicy() {
        return this.refinementPolicy;
    }

    private DemandRefinementPointsTo(CallGraph cg, ThisFilteringHeapModel model, MemoryAccessMap fam, IClassHierarchy cha, AnalysisOptions options, StateMachineFactory<IFlowLabel> stateMachineFactory, IFlowGraph flowGraph) {
        super(cg, model, fam, cha, options);
        this.stateMachineFactory = stateMachineFactory;
        this.g = flowGraph;
        this.refinementPolicyFactory = new SinglePassRefinementPolicy.Factory(new NeverRefineFieldsPolicy(), new NeverRefineCGPolicy());
        this.sanityCheckCG();
    }

    private void sanityCheckCG() {
    }

    protected void startNewQuery() {
        this.refinementPolicy = this.refinementPolicyFactory.make();
        this.stateMachine = this.stateMachineFactory.make();
    }

    public Pair<PointsToResult, Collection<InstanceKey>> getPointsTo(PointerKey pk, Predicate<InstanceKey> ikeyPred) throws IllegalArgumentException {
        Pair<PointsToResult, Collection<InstanceKeyAndState>> p = this.getPointsToWithStates(pk, ikeyPred);
        Collection p2SetWithStates = (Collection)p.snd;
        Collection finalP2Set = p2SetWithStates != null ? DemandRefinementPointsTo.removeStates(p2SetWithStates) : Collections.emptySet();
        return Pair.make((Object)p.fst, finalP2Set);
    }

    private Pair<PointsToResult, Collection<InstanceKeyAndState>> getPointsToWithStates(PointerKey pk, Predicate<InstanceKey> ikeyPred) {
        if (!(pk instanceof LocalPointerKey)) {
            throw new IllegalArgumentException("only locals for now");
        }
        LocalPointerKey queriedPk = (LocalPointerKey)pk;
        this.startNewQuery();
        Pair<PointsToResult, Collection<InstanceKeyAndState>> p = this.outerRefinementLoop(new PointerKeyAndState(queriedPk, this.stateMachine.getStartState()), ikeyPred);
        return p;
    }

    private static <T> Collection<T> removeStates(Collection<? extends WithState<T>> p2SetWithStates) {
        if (p2SetWithStates == null) {
            throw new IllegalArgumentException("p2SetWithStates == null");
        }
        Iterator2Set finalP2Set = Iterator2Collection.toSet((Iterator)new MapIterator(p2SetWithStates.iterator(), WithState::getWrapped));
        return finalP2Set;
    }

    public static DemandRefinementPointsTo makeWithDefaultFlowGraph(CallGraph cg, HeapModel model, MemoryAccessMap mam, IClassHierarchy cha, AnalysisOptions options, StateMachineFactory<IFlowLabel> stateMachineFactory) {
        ThisFilteringHeapModel thisFilteringHeapModel = new ThisFilteringHeapModel(model, cha);
        return new DemandRefinementPointsTo(cg, thisFilteringHeapModel, mam, cha, options, stateMachineFactory, new DemandPointerFlowGraph(cg, (HeapModel)thisFilteringHeapModel, mam, cha));
    }

    private Pair<PointsToResult, Collection<InstanceKeyAndState>> outerRefinementLoop(PointerKeyAndState queried, Predicate<InstanceKey> ikeyPred) {
        int passNum;
        Collection<InstanceKeyAndState> lastP2Set = null;
        boolean succeeded = false;
        int numPasses = this.refinementPolicy.getNumPasses();
        for (passNum = 0; passNum < numPasses; ++passNum) {
            this.setNumNodesTraversed(0);
            this.setTraversalBudget(this.refinementPolicy.getBudgetForPass(passNum));
            Collection<InstanceKeyAndState> curP2Set = null;
            PointsToComputer computer = null;
            boolean completedPassInBudget = false;
            try {
                while (true) {
                    try {
                        computer = new PointsToComputer(queried);
                        computer.compute();
                        curP2Set = computer.getComputedP2Set(queried);
                        completedPassInBudget = true;
                    }
                    catch (StatesMergedException statesMergedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (BudgetExceededException budgetExceededException) {
                // empty catch block
            }
            if (curP2Set != null) {
                if (lastP2Set == null) {
                    lastP2Set = curP2Set;
                } else if (lastP2Set.size() > curP2Set.size()) {
                    assert (DemandRefinementPointsTo.removeStates(lastP2Set).containsAll(DemandRefinementPointsTo.removeStates(curP2Set)));
                    lastP2Set = curP2Set;
                } else assert (DemandRefinementPointsTo.removeStates(curP2Set).containsAll(DemandRefinementPointsTo.removeStates(lastP2Set)));
                if (curP2Set.isEmpty() || DemandRefinementPointsTo.passesPred(curP2Set, ikeyPred)) {
                    succeeded = true;
                    break;
                }
                if (completedPassInBudget) {
                    // empty if block
                }
            }
            if (!this.refinementPolicy.nextPass()) break;
        }
        PointsToResult result = null;
        result = succeeded ? PointsToResult.SUCCESS : (passNum == numPasses ? PointsToResult.BUDGETEXCEEDED : (lastP2Set != null ? PointsToResult.NOMOREREFINE : PointsToResult.BUDGETEXCEEDED));
        return Pair.make((Object)((Object)result), lastP2Set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PointsToResult pointsToPassesPred(PointerKey pk, Predicate<InstanceKey> ikeyPred, PointerAnalysis<InstanceKey> pa) throws IllegalArgumentException {
        int passNum;
        if (!(pk instanceof LocalPointerKey)) {
            throw new IllegalArgumentException("only locals for now");
        }
        LocalPointerKey queriedPk = (LocalPointerKey)pk;
        boolean succeeded = false;
        this.startNewQuery();
        int numPasses = this.refinementPolicy.getNumPasses();
        boolean completedSomePass = false;
        for (passNum = 0; passNum < numPasses; ++passNum) {
            this.setNumNodesTraversed(0);
            this.setTraversalBudget(this.refinementPolicy.getBudgetForPass(passNum));
            boolean completedPassInBudget = false;
            boolean passed = false;
            long initialMemory = 0L;
            try {
                while (true) {
                    try {
                        PointsToComputer computer = new PointsToComputer(queriedPk);
                        passed = this.doTopLevelTraversal(queriedPk, ikeyPred, computer, pa);
                        completedPassInBudget = true;
                        completedSomePass = true;
                    }
                    catch (StatesMergedException statesMergedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (BudgetExceededException budgetExceededException) {
                // empty catch block
            }
            if (completedPassInBudget && passed) {
                succeeded = true;
                break;
            }
            if (!this.refinementPolicy.nextPass()) break;
        }
        PointsToResult result = null;
        if (succeeded) {
            return PointsToResult.SUCCESS;
        }
        if (passNum == numPasses) {
            return PointsToResult.BUDGETEXCEEDED;
        }
        return completedSomePass ? PointsToResult.NOMOREREFINE : PointsToResult.BUDGETEXCEEDED;
    }

    private static boolean passesPred(Collection<InstanceKeyAndState> curP2Set, Predicate<InstanceKey> ikeyPred) {
        return Util.forAll(curP2Set, t -> ikeyPred.test(t.getInstanceKey()));
    }

    @Override
    public Collection<InstanceKey> getPointsTo(PointerKey pk) {
        return (Collection)this.getPointsTo((PointerKey)pk, (Predicate<InstanceKey>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getPointsTo$1(com.ibm.wala.ipa.callgraph.propagation.InstanceKey ), (Lcom/ibm/wala/ipa/callgraph/propagation/InstanceKey;)Z)()).snd;
    }

    public Collection<InstanceKeyAndState> getPointsToWithStates(PointerKey pk) {
        return (Collection)this.getPointsToWithStates((PointerKey)pk, (Predicate<InstanceKey>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getPointsToWithStates$2(com.ibm.wala.ipa.callgraph.propagation.InstanceKey ), (Lcom/ibm/wala/ipa/callgraph/propagation/InstanceKey;)Z)()).snd;
    }

    public Pair<PointsToResult, Collection<PointerKey>> getFlowsTo(InstanceKey ik) {
        this.startNewQuery();
        return this.getFlowsToInternal(new InstanceKeyAndState(ik, this.stateMachine.getStartState()));
    }

    public Pair<PointsToResult, Collection<PointerKey>> getFlowsTo(InstanceKeyAndState ikAndState) {
        this.startNewQuery();
        return this.getFlowsToInternal(ikAndState);
    }

    private Pair<PointsToResult, Collection<PointerKey>> getFlowsToInternal(InstanceKeyAndState ikAndState) {
        int passNum;
        InstanceKey ik = ikAndState.getInstanceKey();
        if (!(ik instanceof InstanceKeyWithNode)) assert (false) : "TODO: handle " + ik.getClass();
        Collection<PointerKeyAndState> lastFlowsToSet = null;
        boolean succeeded = false;
        int numPasses = this.refinementPolicy.getNumPasses();
        for (passNum = 0; passNum < numPasses; ++passNum) {
            this.setNumNodesTraversed(0);
            this.setTraversalBudget(this.refinementPolicy.getBudgetForPass(passNum));
            Collection<PointerKeyAndState> curFlowsToSet = null;
            FlowsToComputer computer = null;
            try {
                while (true) {
                    try {
                        computer = new FlowsToComputer(ikAndState);
                        computer.compute();
                        curFlowsToSet = computer.getComputedFlowsToSet();
                    }
                    catch (StatesMergedException statesMergedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (BudgetExceededException budgetExceededException) {
                // empty catch block
            }
            if (curFlowsToSet != null) {
                if (lastFlowsToSet == null) {
                    lastFlowsToSet = curFlowsToSet;
                } else if (lastFlowsToSet.size() > curFlowsToSet.size()) {
                    assert (DemandRefinementPointsTo.removeStates(lastFlowsToSet).containsAll(DemandRefinementPointsTo.removeStates(curFlowsToSet)));
                    lastFlowsToSet = curFlowsToSet;
                }
                if (curFlowsToSet.isEmpty()) {
                    succeeded = true;
                    break;
                }
            }
            if (!this.refinementPolicy.nextPass()) break;
        }
        PointsToResult result = null;
        result = succeeded ? PointsToResult.SUCCESS : (passNum == numPasses ? PointsToResult.BUDGETEXCEEDED : (lastFlowsToSet != null ? PointsToResult.NOMOREREFINE : PointsToResult.BUDGETEXCEEDED));
        return Pair.make((Object)((Object)result), lastFlowsToSet == null ? null : DemandRefinementPointsTo.removeStates(lastFlowsToSet));
    }

    private static SSAAbstractInvokeInstruction[] getCallInstrs(CGNode node, CallSiteReference site) {
        return node.getIR().getCalls(site);
    }

    private static boolean hasNullIR(CGNode node) {
        boolean ret = node.getMethod().isNative();
        assert (node.getIR() != null || ret);
        return ret;
    }

    private Object doTransition(StateMachine.State curState, IFlowLabel label, Function<StateMachine.State, Object> func) {
        StateMachine.State nextState = this.stateMachine.transition(curState, label);
        Object ret = null;
        if (nextState != StateMachine.ERROR) {
            ret = func.apply(nextState);
        }
        return ret;
    }

    public StateMachineFactory<IFlowLabel> getStateMachineFactory() {
        return this.stateMachineFactory;
    }

    public void setStateMachineFactory(StateMachineFactory<IFlowLabel> stateMachineFactory) {
        this.stateMachineFactory = stateMachineFactory;
    }

    public RefinementPolicyFactory getRefinementPolicyFactory() {
        return this.refinementPolicyFactory;
    }

    public void setRefinementPolicyFactory(RefinementPolicyFactory refinementPolicyFactory) {
        this.refinementPolicyFactory = refinementPolicyFactory;
    }

    private boolean doTopLevelTraversal(PointerKey pk, final Predicate<InstanceKey> pred, final PointsToComputer ptoComputer, PointerAnalysis<InstanceKey> pa) {
        final HashSet visited = HashSetFactory.make();
        final LinkedList worklist = new LinkedList();
        class Helper {
            private final MultiMap<CallerSiteContext, IMethod> callToOTFTargets = ArraySetMultiMap.make();

            Helper() {
            }

            void propagate(PointerKeyAndState pkAndState) {
                if (visited.add(pkAndState)) {
                    assert (this.graphContainsNode(pkAndState.getPointerKey()));
                    worklist.addLast(pkAndState);
                }
            }

            private boolean graphContainsNode(PointerKey pointerKey) {
                if (pointerKey instanceof LocalPointerKey) {
                    LocalPointerKey lpk = (LocalPointerKey)pointerKey;
                    return DemandRefinementPointsTo.this.g.hasSubgraphForNode(lpk.getNode());
                }
                return true;
            }

            private Collection<IMethod> getOTFTargets(CallerSiteContext callSiteAndCGNode, SSAAbstractInvokeInstruction[] callInstrs, StateMachine.State callerState) {
                CallSiteReference call = callSiteAndCGNode.getCallSite();
                CGNode caller = callSiteAndCGNode.getCaller();
                HashSet result = HashSetFactory.make();
                for (SSAAbstractInvokeInstruction callInstr : callInstrs) {
                    PointerKey thisArg = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(0));
                    PointerKeyAndState thisArgAndState = new PointerKeyAndState(thisArg, callerState);
                    OrdinalSet<InstanceKeyAndState> thisPToSet = this.getPToSetFromComputer(ptoComputer, thisArgAndState);
                    for (InstanceKeyAndState ikAndState : thisPToSet) {
                        InstanceKey ik = ikAndState.getInstanceKey();
                        IMethod targetMethod = DemandRefinementPointsTo.this.options.getMethodTargetSelector().getCalleeTarget(caller, call, ik.getConcreteType());
                        if (targetMethod == null) continue;
                        result.add(targetMethod);
                    }
                }
                return result;
            }

            public void handleTopLevelForwInterproc(PointerKeyAndState curPkAndState) {
                block9: {
                    SSAAbstractInvokeInstruction callInstr;
                    PointerKey curPk = curPkAndState.getPointerKey();
                    final StateMachine.State curState = curPkAndState.getState();
                    if (!(curPk instanceof LocalPointerKey)) break block9;
                    final LocalPointerKey localPk = (LocalPointerKey)curPk;
                    if (DemandRefinementPointsTo.this.g.isParam(localPk)) {
                        final CGNode callee = localPk.getNode();
                        final int paramPos = localPk.getValueNumber() - 1;
                        for (final CallerSiteContext callSiteAndCGNode : DemandRefinementPointsTo.this.g.getPotentialCallers(localPk)) {
                            final CGNode caller = callSiteAndCGNode.getCaller();
                            final CallSiteReference call = callSiteAndCGNode.getCallSite();
                            if (DemandRefinementPointsTo.hasNullIR(caller)) continue;
                            final ParamLabel paramLabel = ParamLabel.make(callSiteAndCGNode);
                            DemandRefinementPointsTo.this.doTransition(curPkAndState.getState(), paramLabel, new Function<StateMachine.State, Object>(){

                                private void propagateToCallee() {
                                    SSAAbstractInvokeInstruction[] callInstrs;
                                    DemandRefinementPointsTo.this.g.addSubgraphForNode(caller);
                                    for (SSAAbstractInvokeInstruction callInstr : callInstrs = DemandRefinementPointsTo.getCallInstrs(caller, call)) {
                                        PointerKey actualPk = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(paramPos));
                                        assert (DemandRefinementPointsTo.this.g.containsNode(actualPk));
                                        assert (DemandRefinementPointsTo.this.g.containsNode(localPk));
                                        DemandRefinementPointsTo.this.doTransition(curState, paramLabel, nextState -> {
                                            this.propagate(new PointerKeyAndState(actualPk, (StateMachine.State)nextState));
                                            return null;
                                        });
                                    }
                                }

                                @Override
                                public Object apply(StateMachine.State callerState) {
                                    SSAAbstractInvokeInstruction[] callInstrs = DemandRefinementPointsTo.getCallInstrs(caller, call);
                                    SSAAbstractInvokeInstruction callInstr = callInstrs[0];
                                    PointerKey actualPk = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(paramPos));
                                    Set<CGNode> possibleTargets = DemandRefinementPointsTo.this.g.getPossibleTargets(caller, call, (LocalPointerKey)actualPk);
                                    if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleTargets)) {
                                        this.propagateToCallee();
                                    } else {
                                        Collection otfTargets = this.getOTFTargets(callSiteAndCGNode, callInstrs, callerState);
                                        if (otfTargets.contains(callee.getMethod())) {
                                            this.propagateToCallee();
                                        }
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                    if ((callInstr = DemandRefinementPointsTo.this.g.getInstrReturningTo(localPk)) != null) {
                        Set<CGNode> possibleCallees;
                        CGNode caller = localPk.getNode();
                        boolean isExceptional = localPk.getValueNumber() == callInstr.getException();
                        CallSiteReference callSiteRef = callInstr.getCallSite();
                        CallerSiteContext callSiteAndCGNode = new CallerSiteContext(caller, callSiteRef);
                        if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleCallees = DemandRefinementPointsTo.this.g.getPossibleTargets(caller, callSiteRef, localPk))) {
                            for (CGNode callee : possibleCallees) {
                                PointerKey retVal;
                                if (DemandRefinementPointsTo.hasNullIR(callee)) continue;
                                DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                                PointerKey pointerKey = retVal = isExceptional ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(callee) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(callee);
                                assert (DemandRefinementPointsTo.this.g.containsNode(retVal));
                                DemandRefinementPointsTo.this.doTransition(curState, ReturnLabel.make(callSiteAndCGNode), nextState -> {
                                    this.propagate(new PointerKeyAndState(retVal, (StateMachine.State)nextState));
                                    return null;
                                });
                            }
                        } else {
                            Collection<IMethod> otfTargets = this.getOTFTargets(callSiteAndCGNode, DemandRefinementPointsTo.getCallInstrs(caller, callSiteAndCGNode.getCallSite()), curPkAndState.getState());
                            for (CGNode callee : possibleCallees) {
                                PointerKey retVal;
                                if (!otfTargets.contains(callee.getMethod()) || DemandRefinementPointsTo.hasNullIR(callee)) continue;
                                DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                                PointerKey pointerKey = retVal = isExceptional ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(callee) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(callee);
                                assert (DemandRefinementPointsTo.this.g.containsNode(retVal));
                                DemandRefinementPointsTo.this.doTransition(curState, ReturnLabel.make(callSiteAndCGNode), nextState -> {
                                    this.propagate(new PointerKeyAndState(retVal, (StateMachine.State)nextState));
                                    return null;
                                });
                            }
                        }
                    }
                }
            }

            private OrdinalSet<InstanceKeyAndState> getPToSetFromComputer(PointsToComputer ptoComputer2, PointerKeyAndState pointerKeyAndState) {
                if (pointerKeyAndState.getPointerKey() instanceof LocalPointerKey) {
                    LocalPointerKey lpk = (LocalPointerKey)pointerKeyAndState.getPointerKey();
                    DemandRefinementPointsTo.this.g.addSubgraphForNode(lpk.getNode());
                }
                ptoComputer2.addToInitWorklist(pointerKeyAndState);
                ptoComputer2.worklistLoop();
                MutableIntSet intP2Set = ptoComputer2.pkToP2Set.get(pointerKeyAndState);
                if (intP2Set == null) {
                    return OrdinalSet.empty();
                }
                return ptoComputer2.makeOrdinalSet((IntSet)intP2Set);
            }

            private void computeFlowsTo(PointsToComputer ptoComputer2, OrdinalSet<InstanceKeyAndState> basePToSet) {
                for (InstanceKeyAndState ikAndState : basePToSet) {
                    ptoComputer2.addPredsOfIKeyAndStateToTrackedPointsTo(ikAndState);
                }
                assert (ptoComputer2.initWorklist.isEmpty());
                assert (ptoComputer2.pointsToWorklist.isEmpty());
                ptoComputer2.worklistLoop();
            }

            private Collection<StateMachine.State> getFlowedToStates(PointsToComputer ptoComputer2, OrdinalSet<InstanceKeyAndState> basePToSet, PointerKey putfieldBase) {
                HashSet result = HashSetFactory.make();
                Set trackedStates = ptoComputer2.trackedQueried.get((Object)putfieldBase);
                for (StateMachine.State trackedState : trackedStates) {
                    PointerKeyAndState pkAndState = new PointerKeyAndState(putfieldBase, trackedState);
                    if (!ptoComputer2.makeOrdinalSet((IntSet)ptoComputer2.pkToTrackedSet.get(pkAndState)).containsAny(basePToSet)) continue;
                    result.add(trackedState);
                }
                return result;
            }
        }
        final Helper h = new Helper();
        PointerKeyAndState initPkAndState = new PointerKeyAndState(pk, this.stateMachine.getStartState());
        if (pk instanceof LocalPointerKey) {
            this.g.addSubgraphForNode(((LocalPointerKey)pk).getNode());
        }
        h.propagate(initPkAndState);
        while (!worklist.isEmpty()) {
            this.incrementNumNodesTraversed();
            PointerKeyAndState curPkAndState = (PointerKeyAndState)worklist.removeFirst();
            final PointerKey curPk = curPkAndState.getPointerKey();
            final StateMachine.State curState = curPkAndState.getState();
            if (DemandRefinementPointsTo.predHoldsForPk(curPk, pred, pa)) continue;
            class MyFlowLabelVisitor
            extends AbstractFlowLabelVisitor {
                boolean foundBadInstanceKey;

                MyFlowLabelVisitor() {
                }

                @Override
                public void visitNew(NewLabel label, Object dst) {
                    InstanceKey ik = (InstanceKey)dst;
                    DemandRefinementPointsTo.this.doTransition(curState, label, newState -> {
                        if (!pred.test(ik)) {
                            this.foundBadInstanceKey = true;
                        }
                        return null;
                    });
                }

                @Override
                public void visitGetField(GetFieldLabel label, Object dst) {
                    PointerKey loadBase;
                    IField field = label.getField();
                    if (DemandRefinementPointsTo.this.refineFieldAccesses(field, loadBase = (PointerKey)dst, curPk, label, curState)) {
                        OrdinalSet basePToSet = h.getPToSetFromComputer(ptoComputer, new PointerKeyAndState(loadBase, curState));
                        h.computeFlowsTo(ptoComputer, (OrdinalSet<InstanceKeyAndState>)basePToSet);
                        for (MemoryAccess fieldWrite : this.getWrites(field, loadBase)) {
                            Collection<Pair<PointerKey, PointerKey>> baseAndStoredPairs = this.getBaseAndStored(fieldWrite, field);
                            if (baseAndStoredPairs == null) continue;
                            for (Pair<PointerKey, PointerKey> p : baseAndStoredPairs) {
                                PointerKey base = (PointerKey)p.fst;
                                PointerKey stored = (PointerKey)p.snd;
                                Collection reachedFlowStates = h.getFlowedToStates(ptoComputer, (OrdinalSet<InstanceKeyAndState>)basePToSet, base);
                                for (StateMachine.State nextState2 : reachedFlowStates) {
                                    h.propagate(new PointerKeyAndState(stored, nextState2));
                                }
                            }
                        }
                    } else {
                        for (PointerKey writtenPk : Iterator2Iterable.make(DemandRefinementPointsTo.this.g.getWritesToInstanceField(loadBase, field))) {
                            DemandRefinementPointsTo.this.doTransition(curState, MatchLabel.v(), nextState -> {
                                h.propagate(new PointerKeyAndState(writtenPk, (StateMachine.State)nextState));
                                return null;
                            });
                        }
                    }
                }

                private Collection<Pair<PointerKey, PointerKey>> getBaseAndStored(MemoryAccess fieldWrite, IField field) {
                    CGNode node = fieldWrite.getNode();
                    if (!DemandRefinementPointsTo.this.g.hasSubgraphForNode(node)) {
                        return null;
                    }
                    IR ir = node.getIR();
                    PointerKey base = null;
                    PointerKey stored = null;
                    if (field == ArrayContents.v()) {
                        SSAInstruction instruction = ir.getInstructions()[fieldWrite.getInstructionIndex()];
                        if (instruction == null) {
                            return null;
                        }
                        if (instruction instanceof SSANewInstruction) {
                            return DemandPointerFlowGraph.getInfoForNewMultiDim((SSANewInstruction)((SSANewInstruction)instruction), (HeapModel)DemandRefinementPointsTo.this.heapModel, (CGNode)fieldWrite.getNode()).arrStoreInstrs;
                        }
                        SSAArrayStoreInstruction s = (SSAArrayStoreInstruction)instruction;
                        base = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(fieldWrite.getNode(), s.getArrayRef());
                        stored = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(fieldWrite.getNode(), s.getValue());
                    } else {
                        SSAPutInstruction s = (SSAPutInstruction)ir.getInstructions()[fieldWrite.getInstructionIndex()];
                        if (s == null) {
                            return null;
                        }
                        base = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(fieldWrite.getNode(), s.getRef());
                        stored = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(fieldWrite.getNode(), s.getVal());
                    }
                    return Collections.singleton(Pair.make((Object)base, (Object)stored));
                }

                private Collection<MemoryAccess> getWrites(IField field, PointerKey loadBase) {
                    PointerKey convertedBase = DemandRefinementPointsTo.convertToHeapModel(loadBase, DemandRefinementPointsTo.this.mam.getHeapModel());
                    if (field == ArrayContents.v()) {
                        return DemandRefinementPointsTo.this.mam.getArrayWrites(loadBase);
                    }
                    return DemandRefinementPointsTo.this.mam.getFieldWrites(convertedBase, field);
                }

                @Override
                public void visitAssignGlobal(AssignGlobalLabel label, Object dst) {
                    for (Object writeToStaticField : Iterator2Iterable.make(DemandRefinementPointsTo.this.g.getWritesToStaticField((StaticFieldKey)dst))) {
                        PointerKey writtenPk = (PointerKey)writeToStaticField;
                        DemandRefinementPointsTo.this.doTransition(curState, label, nextState -> {
                            h.propagate(new PointerKeyAndState(writtenPk, (StateMachine.State)nextState));
                            return null;
                        });
                    }
                }

                @Override
                public void visitAssign(AssignLabel label, Object dst) {
                    PointerKey succPk = (PointerKey)dst;
                    DemandRefinementPointsTo.this.doTransition(curState, label, nextState -> {
                        h.propagate(new PointerKeyAndState(succPk, (StateMachine.State)nextState));
                        return null;
                    });
                }
            }
            MyFlowLabelVisitor v = new MyFlowLabelVisitor();
            this.g.visitSuccs(curPk, v);
            if (v.foundBadInstanceKey) {
                return false;
            }
            h.handleTopLevelForwInterproc(curPkAndState);
        }
        return true;
    }

    private static boolean predHoldsForPk(PointerKey curPk, Predicate<InstanceKey> pred, PointerAnalysis<InstanceKey> pa) {
        PointerKey curPkForPAHeapModel = DemandRefinementPointsTo.convertToHeapModel(curPk, pa.getHeapModel());
        OrdinalSet<InstanceKey> pointsToSet = pa.getPointsToSet(curPkForPAHeapModel);
        for (InstanceKey ik : pointsToSet) {
            if (pred.test(ik)) continue;
            return false;
        }
        return true;
    }

    private static PointerKey convertToHeapModel(PointerKey curPk, HeapModel heapModel) {
        return AbstractFlowGraph.convertPointerKeyToHeapModel(curPk, heapModel);
    }

    private boolean refineFieldAccesses(IField field, PointerKey basePtr, PointerKey val, IFlowLabel label, StateMachine.State state) {
        boolean shouldRefine = this.refinementPolicy.getFieldRefinePolicy().shouldRefine(field, basePtr, val, label, state);
        return shouldRefine;
    }

    private boolean noOnTheFlyNeeded(CallerSiteContext call, Set<CGNode> possibleTargets) {
        if (!this.refinementPolicy.getCallGraphRefinePolicy().shouldRefine(call)) {
            return true;
        }
        HashSet<IMethod> methodTargets = new HashSet<IMethod>();
        for (CGNode node : possibleTargets) {
            methodTargets.add(node.getMethod());
        }
        return methodTargets.size() <= 1;
    }

    private static /* synthetic */ boolean lambda$getPointsToWithStates$2(InstanceKey k) {
        return false;
    }

    private static /* synthetic */ boolean lambda$getPointsTo$1(InstanceKey k) {
        return false;
    }

    protected class FlowsToComputer
    extends PointsToComputer {
        private final InstanceKeyAndState queriedIkAndState;
        private final int queriedIkAndStateNum;
        private final Collection<PointerKeyAndState> theFlowsToSet;

        public FlowsToComputer(InstanceKeyAndState ikAndState) {
            this.theFlowsToSet = HashSetFactory.make();
            this.queriedIkAndState = ikAndState;
            this.queriedIkAndStateNum = this.ikAndStates.add((Object)this.queriedIkAndState);
        }

        @Override
        protected void compute() {
            InstanceKey ik = this.queriedIkAndState.getInstanceKey();
            DemandRefinementPointsTo.this.g.addSubgraphForNode(((InstanceKeyWithNode)ik).getNode());
            for (Object pred : Iterator2Iterable.make((Iterator)DemandRefinementPointsTo.this.g.getPredNodes(ik, NewLabel.v()))) {
                PointerKey predPk = (PointerKey)pred;
                PointerKeyAndState predPkAndState = new PointerKeyAndState(predPk, this.queriedIkAndState.getState());
                this.theFlowsToSet.add(predPkAndState);
                this.findOrCreate(this.pkToTrackedSet, predPkAndState).add(this.queriedIkAndStateNum);
                this.addToTrackedPToWorklist(predPkAndState);
            }
            this.worklistLoop();
        }

        public Collection<PointerKeyAndState> getComputedFlowsToSet() {
            return this.theFlowsToSet;
        }

        @Override
        protected boolean handleTrackedPred(MutableIntSet curTrackedSet, PointerKeyAndState predPkAndState, IFlowLabel label) {
            boolean result = super.handleTrackedPred(curTrackedSet, predPkAndState, label);
            if (result && this.find(this.pkToTrackedSet, predPkAndState).contains(this.queriedIkAndStateNum)) {
                this.theFlowsToSet.add(predPkAndState);
            }
            return result;
        }
    }

    protected class PointsToComputer {
        protected final PointerKeyAndState queriedPkAndState;
        private final MultiMap<PointerKey, StateMachine.State> pointsToQueried = HashSetMultiMap.make();
        private final MultiMap<PointerKey, StateMachine.State> trackedQueried = HashSetMultiMap.make();
        private final Collection<PointerKeyAndState> initWorklist = new LinkedHashSet<PointerKeyAndState>();
        private final Collection<PointerKeyAndState> pointsToWorklist = new LinkedHashSet<PointerKeyAndState>();
        private final Collection<PointerKeyAndState> trackedPointsToWorklist = new LinkedHashSet<PointerKeyAndState>();
        private final MultiMap<PointerKeyAndState, CallerSiteContext> pkToOTFCalls = HashSetMultiMap.make();
        private final MultiMap<CallerSiteContext, IMethod> callToOTFTargets = ArraySetMultiMap.make();
        private final MultiMap<InstanceKeyAndState, IField> forwInstKeyToFields = HashSetMultiMap.make();
        private final MultiMap<InstanceKeyAndState, IField> backInstKeyToFields = HashSetMultiMap.make();
        protected final Map<PointerKeyAndState, MutableIntSet> pkToP2Set = HashMapFactory.make();
        protected final Map<PointerKeyAndState, MutableIntSet> pkToTrackedSet = HashMapFactory.make();
        private final Map<InstanceFieldKeyAndState, MutableIntSet> instFieldKeyToP2Set = HashMapFactory.make();
        private final Map<InstanceFieldKeyAndState, MutableIntSet> instFieldKeyToTrackedSet = HashMapFactory.make();
        protected final OrdinalSetMapping<InstanceKeyAndState> ikAndStates = MutableMapping.make();
        private final MutableIntSetFactory<MutableSparseIntSet> intSetFactory = new MutableSparseIntSetFactory();
        private final HashSet<StoreEdge> encounteredStores = HashSetFactory.make();
        private final HashSet<LoadEdge> encounteredLoads = HashSetFactory.make();
        private final MutableIntSet emptySet = this.intSetFactory.make();

        protected PointsToComputer() {
            this.queriedPkAndState = null;
        }

        protected PointsToComputer(PointerKey pk) {
            this.queriedPkAndState = new PointerKeyAndState(pk, DemandRefinementPointsTo.this.stateMachine.getStartState());
        }

        protected PointsToComputer(PointerKeyAndState pkAndState) {
            this.queriedPkAndState = pkAndState;
        }

        private OrdinalSet<InstanceKeyAndState> makeOrdinalSet(IntSet intSet) {
            return new OrdinalSet((IntSet)this.intSetFactory.makeCopy(intSet), this.ikAndStates);
        }

        public Collection<InstanceKeyAndState> getComputedP2Set(PointerKeyAndState queried) {
            return Iterator2Collection.toSet((Iterator)this.makeOrdinalSet((IntSet)this.find(this.pkToP2Set, queried)).iterator());
        }

        protected boolean addAllToP2Set(Map<PointerKeyAndState, MutableIntSet> p2setMap, PointerKeyAndState pkAndState, IntSet vals, IFlowLabel label) {
            FilteredPointerKey.TypeFilter typeFilter;
            PointerKey pk = pkAndState.getPointerKey();
            if (pk instanceof FilteredPointerKey) {
                typeFilter = ((FilteredPointerKey)pk).getTypeFilter();
                vals = this.updateValsForFilter(vals, typeFilter);
            }
            if (label instanceof IFlowLabelWithFilter && (typeFilter = ((IFlowLabelWithFilter)label).getFilter()) != null) {
                vals = this.updateValsForFilter(vals, typeFilter);
            }
            boolean added = this.findOrCreate(p2setMap, pkAndState).addAll(vals);
            return added;
        }

        private IntSet updateValsForFilter(IntSet vals, FilteredPointerKey.TypeFilter typeFilter) {
            if (typeFilter instanceof FilteredPointerKey.SingleClassFilter) {
                IClass concreteType = ((FilteredPointerKey.SingleClassFilter)typeFilter).getConcreteType();
                MutableIntSet tmp = this.intSetFactory.make();
                vals.foreach(x -> {
                    InstanceKeyAndState ikAndState = (InstanceKeyAndState)this.ikAndStates.getMappedObject(x);
                    if (DemandRefinementPointsTo.this.cha.isAssignableFrom(concreteType, ikAndState.getInstanceKey().getConcreteType())) {
                        tmp.add(x);
                    }
                });
                vals = tmp;
            } else if (typeFilter instanceof FilteredPointerKey.MultipleClassesFilter) {
                MutableIntSet tmp = this.intSetFactory.make();
                vals.foreach(x -> {
                    InstanceKeyAndState ikAndState = (InstanceKeyAndState)this.ikAndStates.getMappedObject(x);
                    for (IClass t : ((FilteredPointerKey.MultipleClassesFilter)typeFilter).getConcreteTypes()) {
                        if (!DemandRefinementPointsTo.this.cha.isAssignableFrom(t, ikAndState.getInstanceKey().getConcreteType())) continue;
                        tmp.add(x);
                    }
                });
                vals = tmp;
            } else if (typeFilter instanceof FilteredPointerKey.SingleInstanceFilter) {
                InstanceKey theOnlyInstanceKey = ((FilteredPointerKey.SingleInstanceFilter)typeFilter).getInstance();
                MutableIntSet tmp = this.intSetFactory.make();
                vals.foreach(x -> {
                    InstanceKeyAndState ikAndState = (InstanceKeyAndState)this.ikAndStates.getMappedObject(x);
                    if (ikAndState.getInstanceKey().equals(theOnlyInstanceKey)) {
                        tmp.add(x);
                    }
                });
                vals = tmp;
            } else {
                Assertions.UNREACHABLE();
            }
            return vals;
        }

        protected void compute() {
            CGNode node = ((LocalPointerKey)this.queriedPkAndState.getPointerKey()).getNode();
            if (DemandRefinementPointsTo.hasNullIR(node)) {
                return;
            }
            DemandRefinementPointsTo.this.g.addSubgraphForNode(node);
            this.addToInitWorklist(this.queriedPkAndState);
            this.worklistLoop();
        }

        protected void worklistLoop() {
            while (true) {
                if (!(this.initWorklist.isEmpty() && this.pointsToWorklist.isEmpty() && this.trackedPointsToWorklist.isEmpty())) {
                    this.handleInitWorklist();
                    this.handlePointsToWorklist();
                    this.handleTrackedPointsToWorklist();
                    continue;
                }
                this.makePassOverFieldStmts();
                if (this.initWorklist.isEmpty() && this.pointsToWorklist.isEmpty() && this.trackedPointsToWorklist.isEmpty()) break;
            }
        }

        void handleCopy(PointerKeyAndState curPkAndState, PointerKey succPk, IFlowLabel label) {
            assert (!label.isBarred());
            StateMachine.State curState = curPkAndState.getState();
            DemandRefinementPointsTo.this.doTransition(curState, label, nextState -> {
                PointerKeyAndState succPkAndState = new PointerKeyAndState(succPk, (StateMachine.State)nextState);
                this.handleCopy(curPkAndState, succPkAndState, label);
                return null;
            });
        }

        void handleCopy(PointerKeyAndState curPkAndState, PointerKeyAndState succPkAndState, IFlowLabel label) {
            if (!this.addToInitWorklist(succPkAndState) && this.addAllToP2Set(this.pkToP2Set, curPkAndState, (IntSet)this.find(this.pkToP2Set, succPkAndState), label)) {
                this.addToPToWorklist(curPkAndState);
            }
        }

        void handleAllCopies(PointerKeyAndState curPk, Iterator<? extends Object> succNodes, IFlowLabel label) {
            while (succNodes.hasNext()) {
                this.handleCopy(curPk, (PointerKey)succNodes.next(), label);
            }
        }

        protected Collection<PointerKeyAndState> matchingPToQueried(PointerKeyAndState curPkAndState, PointerKey predPk, IFlowLabel label) {
            ArraySet ret = ArraySet.make();
            assert (label.isBarred());
            IFlowLabel unbarredLabel = label.bar();
            StateMachine.State curState = curPkAndState.getState();
            Set predPkStates = this.pointsToQueried.get((Object)predPk);
            for (StateMachine.State predState : predPkStates) {
                StateMachine.State transState = DemandRefinementPointsTo.this.stateMachine.transition(predState, unbarredLabel);
                if (!transState.equals(curState)) continue;
                ret.add(new PointerKeyAndState(predPk, predState));
            }
            return ret;
        }

        Collection<PointerKeyAndState> matchingTrackedQueried(PointerKeyAndState curPkAndState, PointerKey succPk, IFlowLabel label) {
            ArraySet ret = ArraySet.make();
            assert (label.isBarred());
            StateMachine.State curState = curPkAndState.getState();
            Set succPkStates = this.trackedQueried.get((Object)succPk);
            for (StateMachine.State succState : succPkStates) {
                StateMachine.State transState = DemandRefinementPointsTo.this.stateMachine.transition(succState, label);
                if (!transState.equals(curState)) continue;
                ret.add(new PointerKeyAndState(succPk, succState));
            }
            return ret;
        }

        protected void handleBackCopy(PointerKeyAndState curPkAndState, PointerKey predPk, IFlowLabel label) {
            for (PointerKeyAndState predPkAndState : this.matchingPToQueried(curPkAndState, predPk, label)) {
                if (!this.addAllToP2Set(this.pkToP2Set, predPkAndState, (IntSet)this.find(this.pkToP2Set, curPkAndState), label)) continue;
                this.addToPToWorklist(predPkAndState);
            }
        }

        void handleAllBackCopies(PointerKeyAndState curPkAndState, Iterator<? extends Object> predNodes, IFlowLabel label) {
            while (predNodes.hasNext()) {
                this.handleBackCopy(curPkAndState, (PointerKey)predNodes.next(), label);
            }
        }

        void addToPToWorklist(PointerKeyAndState pkAndState) {
            this.pointsToWorklist.add(pkAndState);
            Set otfCalls = this.pkToOTFCalls.get((Object)pkAndState);
            for (CallerSiteContext callSiteAndCGNode : otfCalls) {
                this.propTargets(pkAndState, callSiteAndCGNode);
            }
        }

        boolean addToInitWorklist(PointerKeyAndState pkAndState) {
            if (this.pointsToQueried.put((Object)pkAndState.getPointerKey(), (Object)pkAndState.getState())) {
                CGNode node;
                if (pkAndState.getPointerKey() instanceof AbstractLocalPointerKey && !DemandRefinementPointsTo.this.g.hasSubgraphForNode(node = ((AbstractLocalPointerKey)pkAndState.getPointerKey()).getNode())) assert (false) : "missing constraints for " + node;
                this.initWorklist.add(pkAndState);
                return true;
            }
            return false;
        }

        protected void addToTrackedPToWorklist(PointerKeyAndState pkAndState) {
            CGNode node;
            if (pkAndState.getPointerKey() instanceof AbstractLocalPointerKey && !DemandRefinementPointsTo.this.g.hasSubgraphForNode(node = ((AbstractLocalPointerKey)pkAndState.getPointerKey()).getNode())) assert (false) : "missing constraints for " + node;
            this.trackedQueried.put((Object)pkAndState.getPointerKey(), (Object)pkAndState.getState());
            this.trackedPointsToWorklist.add(pkAndState);
        }

        void propTargets(PointerKeyAndState receiverAndState, CallerSiteContext callSiteAndCGNode) {
            CGNode caller = callSiteAndCGNode.getCaller();
            CallSiteReference call = callSiteAndCGNode.getCallSite();
            StateMachine.State receiverState = receiverAndState.getState();
            OrdinalSet<InstanceKeyAndState> p2set = this.makeOrdinalSet((IntSet)this.find(this.pkToP2Set, receiverAndState));
            for (InstanceKeyAndState ikAndState : p2set) {
                InstanceKey ik = ikAndState.getInstanceKey();
                IMethod targetMethod = DemandRefinementPointsTo.this.options.getMethodTargetSelector().getCalleeTarget(caller, call, ik.getConcreteType());
                if (targetMethod == null || this.callToOTFTargets.get((Object)callSiteAndCGNode).contains(targetMethod)) continue;
                this.callToOTFTargets.put((Object)callSiteAndCGNode, (Object)targetMethod);
                Set<CGNode> targetCGNodes = DemandRefinementPointsTo.this.cg.getNodes(targetMethod.getReference());
                for (CGNode targetForCall : targetCGNodes) {
                    SSAAbstractInvokeInstruction[] calls;
                    if (DemandRefinementPointsTo.hasNullIR(targetForCall)) continue;
                    DemandRefinementPointsTo.this.g.addSubgraphForNode(targetForCall);
                    for (SSAAbstractInvokeInstruction invokeInstr : calls = DemandRefinementPointsTo.getCallInstrs(caller, call)) {
                        ReturnLabel returnLabel = ReturnLabel.make(new CallerSiteContext(caller, call));
                        if (invokeInstr.hasDef()) {
                            PointerKeyAndState defAndState = new PointerKeyAndState(DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, invokeInstr.getDef()), receiverState);
                            PointerKey ret = DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(targetForCall);
                            DemandRefinementPointsTo.this.doTransition(receiverState, returnLabel, retState -> {
                                this.repropCallArg(defAndState, new PointerKeyAndState(ret, (StateMachine.State)retState), returnLabel.bar());
                                return null;
                            });
                        }
                        PointerKeyAndState exc = new PointerKeyAndState(DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, invokeInstr.getException()), receiverState);
                        PointerKey excRet = DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(targetForCall);
                        DemandRefinementPointsTo.this.doTransition(receiverState, returnLabel, excRetState -> {
                            this.repropCallArg(exc, new PointerKeyAndState(excRet, (StateMachine.State)excRetState), returnLabel.bar());
                            return null;
                        });
                        Iterator iterator = Iterator2Iterable.make((Iterator)new PointerParamValueNumIterator(targetForCall)).iterator();
                        while (iterator.hasNext()) {
                            int formalNum = (Integer)iterator.next();
                            int actualNum = formalNum - 1;
                            ParamBarLabel paramBarLabel = ParamBarLabel.make(new CallerSiteContext(caller, call));
                            DemandRefinementPointsTo.this.doTransition(receiverState, paramBarLabel, formalState -> {
                                this.repropCallArg(new PointerKeyAndState(DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(targetForCall, formalNum), (StateMachine.State)formalState), new PointerKeyAndState(DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, invokeInstr.getUse(actualNum)), receiverState), paramBarLabel);
                                return null;
                            });
                        }
                    }
                }
            }
        }

        private void repropCallArg(PointerKeyAndState src, PointerKeyAndState dst, IFlowLabel dstToSrcLabel) {
            for (PointerKeyAndState srcToHandle : this.matchingPToQueried(dst, src.getPointerKey(), dstToSrcLabel)) {
                this.handleCopy(srcToHandle, dst, dstToSrcLabel.bar());
            }
            for (PointerKeyAndState dstToHandle : this.matchingTrackedQueried(src, dst.getPointerKey(), dstToSrcLabel)) {
                MutableIntSet trackedSet = this.find(this.pkToTrackedSet, dstToHandle);
                if (trackedSet.isEmpty() || !this.findOrCreate(this.pkToTrackedSet, src).addAll((IntSet)trackedSet)) continue;
                this.addToTrackedPToWorklist(src);
            }
        }

        void handleInitWorklist() {
            while (!this.initWorklist.isEmpty()) {
                DemandRefinementPointsTo.this.incrementNumNodesTraversed();
                final PointerKeyAndState curPkAndState = this.initWorklist.iterator().next();
                this.initWorklist.remove(curPkAndState);
                final PointerKey curPk = curPkAndState.getPointerKey();
                final StateMachine.State curState = curPkAndState.getState();
                if (curPk instanceof LocalPointerKey) assert (DemandRefinementPointsTo.this.g.hasSubgraphForNode(((LocalPointerKey)curPk).getNode()));
                AbstractFlowLabelVisitor v = new AbstractFlowLabelVisitor(){

                    @Override
                    public void visitNew(NewLabel label, Object dst) {
                        InstanceKey ik = (InstanceKey)dst;
                        DemandRefinementPointsTo.this.doTransition(curState, label, newState -> {
                            InstanceKeyAndState ikAndState = new InstanceKeyAndState(ik, (StateMachine.State)newState);
                            int n = PointsToComputer.this.ikAndStates.add((Object)ikAndState);
                            PointsToComputer.this.findOrCreate(PointsToComputer.this.pkToP2Set, curPkAndState).add(n);
                            PointsToComputer.this.addToPToWorklist(curPkAndState);
                            return null;
                        });
                    }

                    @Override
                    public void visitGetField(GetFieldLabel label, Object dst) {
                        PointerKey loadBase;
                        IField field = label.getField();
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(field, loadBase = (PointerKey)dst, curPk, label, curState)) {
                            PointerKeyAndState loadBaseAndState = new PointerKeyAndState(loadBase, curState);
                            PointsToComputer.this.addEncounteredLoad(new LoadEdge(loadBaseAndState, field, curPkAndState));
                            if (!PointsToComputer.this.addToInitWorklist(loadBaseAndState)) {
                                for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet((IntSet)PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, loadBaseAndState))) {
                                    PointsToComputer.this.trackInstanceField(ikAndState, field, (MultiMap<InstanceKeyAndState, IField>)PointsToComputer.this.forwInstKeyToFields);
                                }
                            }
                        } else {
                            PointsToComputer.this.handleAllCopies(curPkAndState, DemandRefinementPointsTo.this.g.getWritesToInstanceField(loadBase, field), MatchLabel.v());
                        }
                    }

                    @Override
                    public void visitAssignGlobal(AssignGlobalLabel label, Object dst) {
                        PointsToComputer.this.handleAllCopies(curPkAndState, DemandRefinementPointsTo.this.g.getWritesToStaticField((StaticFieldKey)dst), AssignGlobalLabel.v());
                    }

                    @Override
                    public void visitAssign(AssignLabel label, Object dst) {
                        PointsToComputer.this.handleCopy(curPkAndState, (PointerKey)dst, (IFlowLabel)AssignLabel.noFilter());
                    }
                };
                DemandRefinementPointsTo.this.g.visitSuccs(curPk, v);
                this.handleForwInterproc(curPkAndState, new CopyHandler(){

                    @Override
                    void handle(PointerKeyAndState src, PointerKey dst, IFlowLabel label) {
                        PointsToComputer.this.handleCopy(src, dst, label);
                    }
                });
            }
        }

        private void handleForwInterproc(final PointerKeyAndState curPkAndState, final CopyHandler handler) {
            PointerKey curPk = curPkAndState.getPointerKey();
            if (curPk instanceof LocalPointerKey) {
                SSAAbstractInvokeInstruction callInstr;
                final LocalPointerKey localPk = (LocalPointerKey)curPk;
                if (DemandRefinementPointsTo.this.g.isParam(localPk)) {
                    final CGNode callee = localPk.getNode();
                    final int paramPos = localPk.getValueNumber() - 1;
                    for (final CallerSiteContext callSiteAndCGNode : DemandRefinementPointsTo.this.g.getPotentialCallers(localPk)) {
                        final CGNode caller = callSiteAndCGNode.getCaller();
                        final CallSiteReference call = callSiteAndCGNode.getCallSite();
                        if (DemandRefinementPointsTo.hasNullIR(caller)) continue;
                        final ParamLabel paramLabel = ParamLabel.make(callSiteAndCGNode);
                        DemandRefinementPointsTo.this.doTransition(curPkAndState.getState(), paramLabel, new Function<StateMachine.State, Object>(){

                            private void propagateToCallee() {
                                SSAAbstractInvokeInstruction[] callInstrs;
                                DemandRefinementPointsTo.this.g.addSubgraphForNode(caller);
                                for (SSAAbstractInvokeInstruction callInstr : callInstrs = DemandRefinementPointsTo.getCallInstrs(caller, call)) {
                                    PointerKey actualPk = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(paramPos));
                                    assert (DemandRefinementPointsTo.this.g.containsNode(actualPk));
                                    assert (DemandRefinementPointsTo.this.g.containsNode(localPk));
                                    handler.handle(curPkAndState, actualPk, paramLabel);
                                }
                            }

                            @Override
                            public Object apply(StateMachine.State callerState) {
                                SSAAbstractInvokeInstruction[] callInstrs = DemandRefinementPointsTo.getCallInstrs(caller, call);
                                SSAAbstractInvokeInstruction callInstr = callInstrs[0];
                                PointerKey actualPk = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(paramPos));
                                Set<CGNode> possibleTargets = DemandRefinementPointsTo.this.g.getPossibleTargets(caller, call, (LocalPointerKey)actualPk);
                                if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleTargets)) {
                                    this.propagateToCallee();
                                } else if (PointsToComputer.this.callToOTFTargets.get((Object)callSiteAndCGNode).contains(callee.getMethod())) {
                                    this.propagateToCallee();
                                } else {
                                    PointsToComputer.this.queryCallTargets(callSiteAndCGNode, callInstrs, callerState);
                                }
                                return null;
                            }
                        });
                    }
                }
                if ((callInstr = DemandRefinementPointsTo.this.g.getInstrReturningTo(localPk)) != null) {
                    Set<CGNode> possibleCallees;
                    CGNode caller = localPk.getNode();
                    boolean isExceptional = localPk.getValueNumber() == callInstr.getException();
                    CallSiteReference callSiteRef = callInstr.getCallSite();
                    CallerSiteContext callSiteAndCGNode = new CallerSiteContext(caller, callSiteRef);
                    if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleCallees = DemandRefinementPointsTo.this.g.getPossibleTargets(caller, callSiteRef, localPk))) {
                        for (CGNode callee : possibleCallees) {
                            PointerKey retVal;
                            if (DemandRefinementPointsTo.hasNullIR(callee)) continue;
                            DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                            PointerKey pointerKey = retVal = isExceptional ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(callee) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(callee);
                            assert (DemandRefinementPointsTo.this.g.containsNode(retVal));
                            handler.handle(curPkAndState, retVal, ReturnLabel.make(callSiteAndCGNode));
                        }
                    } else if (this.callToOTFTargets.containsKey((Object)callSiteAndCGNode)) {
                        Set targetMethods = this.callToOTFTargets.get((Object)callSiteAndCGNode);
                        for (CGNode callee : possibleCallees) {
                            PointerKey retVal;
                            if (!targetMethods.contains(callee.getMethod()) || DemandRefinementPointsTo.hasNullIR(callee)) continue;
                            DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                            PointerKey pointerKey = retVal = isExceptional ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(callee) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(callee);
                            assert (DemandRefinementPointsTo.this.g.containsNode(retVal));
                            handler.handle(curPkAndState, retVal, ReturnLabel.make(callSiteAndCGNode));
                        }
                    } else {
                        this.queryCallTargets(callSiteAndCGNode, DemandRefinementPointsTo.getCallInstrs(caller, callSiteAndCGNode.getCallSite()), curPkAndState.getState());
                    }
                }
            }
        }

        private void trackInstanceField(InstanceKeyAndState ikAndState, IField field, MultiMap<InstanceKeyAndState, IField> ikToFields) {
            ikToFields.put((Object)ikAndState, (Object)field);
            this.addPredsOfIKeyAndStateToTrackedPointsTo(ikAndState);
        }

        private void addPredsOfIKeyAndStateToTrackedPointsTo(InstanceKeyAndState ikAndState) throws UnimplementedError {
            for (Object o : Iterator2Iterable.make((Iterator)DemandRefinementPointsTo.this.g.getPredNodes(ikAndState.getInstanceKey(), NewLabel.v()))) {
                PointerKey ikPred = (PointerKey)o;
                PointerKeyAndState ikPredAndState = new PointerKeyAndState(ikPred, ikAndState.getState());
                int mappedIndex = this.ikAndStates.getMappedIndex((Object)ikAndState);
                assert (mappedIndex != -1);
                if (!this.findOrCreate(this.pkToTrackedSet, ikPredAndState).add(mappedIndex)) continue;
                this.addToTrackedPToWorklist(ikPredAndState);
            }
        }

        private void queryCallTargets(CallerSiteContext callSiteAndCGNode, SSAAbstractInvokeInstruction[] callInstrs, StateMachine.State callerState) {
            CGNode caller = callSiteAndCGNode.getCaller();
            for (SSAAbstractInvokeInstruction callInstr : callInstrs) {
                PointerKey thisArg = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(0));
                PointerKeyAndState thisArgAndState = new PointerKeyAndState(thisArg, callerState);
                if (this.pkToOTFCalls.put((Object)thisArgAndState, (Object)callSiteAndCGNode)) {
                    CGNode node = ((LocalPointerKey)thisArg).getNode();
                    if (DemandRefinementPointsTo.hasNullIR(node)) {
                        return;
                    }
                    DemandRefinementPointsTo.this.g.addSubgraphForNode(node);
                    if (this.addToInitWorklist(thisArgAndState)) continue;
                    this.propTargets(thisArgAndState, callSiteAndCGNode);
                    continue;
                }
                this.propTargets(thisArgAndState, callSiteAndCGNode);
            }
        }

        void handlePointsToWorklist() {
            while (!this.pointsToWorklist.isEmpty()) {
                DemandRefinementPointsTo.this.incrementNumNodesTraversed();
                final PointerKeyAndState curPkAndState = this.pointsToWorklist.iterator().next();
                this.pointsToWorklist.remove(curPkAndState);
                final PointerKey curPk = curPkAndState.getPointerKey();
                final StateMachine.State curState = curPkAndState.getState();
                AbstractFlowLabelVisitor predVisitor = new AbstractFlowLabelVisitor(){

                    @Override
                    public void visitPutField(PutFieldLabel label, Object dst) {
                        PointerKey storeBase;
                        IField field = label.getField();
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(field, storeBase = (PointerKey)dst, curPk, label, curState)) {
                            PointerKeyAndState storeBaseAndState = new PointerKeyAndState(storeBase, curState);
                            PointsToComputer.this.encounteredStores.add(new StoreEdge(storeBaseAndState, field, curPkAndState));
                            for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet((IntSet)PointsToComputer.this.find(PointsToComputer.this.pkToTrackedSet, storeBaseAndState))) {
                                if (!PointsToComputer.this.forwInstKeyToFields.get((Object)ikAndState).contains(field)) continue;
                                InstanceFieldKeyAndState ifKeyAndState = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToP2Set, ifKeyAndState).addAll((IntSet)PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, curPkAndState));
                            }
                        } else {
                            PointsToComputer.this.handleAllBackCopies(curPkAndState, DemandRefinementPointsTo.this.g.getReadsOfInstanceField(storeBase, field), MatchBarLabel.v());
                        }
                    }

                    @Override
                    public void visitGetField(GetFieldLabel label, Object dst) {
                        PointerKey dstPtrKey;
                        IField field = label.getField();
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(field, curPk, dstPtrKey = (PointerKey)dst, label, curState)) {
                            PointerKeyAndState loadDefAndState = new PointerKeyAndState(dstPtrKey, curState);
                            PointsToComputer.this.addEncounteredLoad(new LoadEdge(curPkAndState, field, loadDefAndState));
                            if (PointsToComputer.this.pointsToQueried.get((Object)dstPtrKey).contains(curState)) {
                                for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet((IntSet)PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, curPkAndState))) {
                                    PointsToComputer.this.trackInstanceField(ikAndState, field, (MultiMap<InstanceKeyAndState, IField>)PointsToComputer.this.forwInstKeyToFields);
                                }
                            }
                        }
                    }

                    @Override
                    public void visitAssignGlobal(AssignGlobalLabel label, Object dst) {
                        PointsToComputer.this.handleAllBackCopies(curPkAndState, DemandRefinementPointsTo.this.g.getReadsOfStaticField((StaticFieldKey)dst), label.bar());
                    }

                    @Override
                    public void visitAssign(AssignLabel label, Object dst) {
                        PointsToComputer.this.handleBackCopy(curPkAndState, (PointerKey)dst, label.bar());
                    }
                };
                DemandRefinementPointsTo.this.g.visitPreds(curPk, predVisitor);
                AbstractFlowLabelVisitor succVisitor = new AbstractFlowLabelVisitor(){

                    @Override
                    public void visitPutField(PutFieldLabel label, Object dst) {
                        PointerKey dstPtrKey;
                        IField field = label.getField();
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(field, curPk, dstPtrKey = (PointerKey)dst, label.bar(), curState)) {
                            PointerKeyAndState storeDst = new PointerKeyAndState(dstPtrKey, curState);
                            PointsToComputer.this.encounteredStores.add(new StoreEdge(curPkAndState, field, storeDst));
                            MutableIntSet trackedSet = PointsToComputer.this.find(PointsToComputer.this.pkToTrackedSet, storeDst);
                            if (!trackedSet.isEmpty()) {
                                for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet((IntSet)PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, curPkAndState))) {
                                    InstanceFieldKeyAndState ifk = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                    PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToTrackedSet, ifk).addAll((IntSet)trackedSet);
                                    PointsToComputer.this.trackInstanceField(ikAndState, field, (MultiMap<InstanceKeyAndState, IField>)PointsToComputer.this.backInstKeyToFields);
                                }
                            }
                        }
                    }
                };
                DemandRefinementPointsTo.this.g.visitSuccs(curPk, succVisitor);
                this.handleBackInterproc(curPkAndState, new CopyHandler(){

                    @Override
                    void handle(PointerKeyAndState src, PointerKey dst, IFlowLabel label) {
                        PointsToComputer.this.handleBackCopy(src, dst, label);
                    }
                }, false);
            }
        }

        private void handleBackInterproc(final PointerKeyAndState curPkAndState, final CopyHandler handler, boolean addGraphs) {
            PointerKey curPk = curPkAndState.getPointerKey();
            StateMachine.State curState = curPkAndState.getState();
            if (curPk instanceof ReturnValueKey) {
                final ReturnValueKey returnKey = (ReturnValueKey)curPk;
                final CGNode callee = returnKey.getNode();
                final boolean isExceptional = returnKey instanceof ExceptionReturnValueKey;
                for (final CallerSiteContext callSiteAndCGNode : DemandRefinementPointsTo.this.g.getPotentialCallers(returnKey)) {
                    final CGNode caller = callSiteAndCGNode.getCaller();
                    if (DemandRefinementPointsTo.hasNullIR(caller)) continue;
                    final CallSiteReference call = callSiteAndCGNode.getCallSite();
                    if (this.calleeSubGraphMissingAndShouldNotBeAdded(addGraphs, callee, curPkAndState)) continue;
                    final ReturnBarLabel returnBarLabel = ReturnBarLabel.make(callSiteAndCGNode);
                    DemandRefinementPointsTo.this.doTransition(curState, returnBarLabel, new Function<StateMachine.State, Object>(){

                        private void propagateToCaller() {
                            SSAAbstractInvokeInstruction[] callInstrs;
                            DemandRefinementPointsTo.this.g.addSubgraphForNode(caller);
                            for (SSAAbstractInvokeInstruction callInstr : callInstrs = DemandRefinementPointsTo.getCallInstrs(caller, call)) {
                                PointerKey returnAtCallerKey = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, isExceptional ? callInstr.getException() : callInstr.getDef());
                                assert (DemandRefinementPointsTo.this.g.containsNode(returnAtCallerKey));
                                assert (DemandRefinementPointsTo.this.g.containsNode(returnKey));
                                handler.handle(curPkAndState, returnAtCallerKey, returnBarLabel);
                            }
                        }

                        @Override
                        public Object apply(StateMachine.State callerState) {
                            SSAAbstractInvokeInstruction[] callInstrs = DemandRefinementPointsTo.getCallInstrs(caller, call);
                            SSAAbstractInvokeInstruction callInstr = callInstrs[0];
                            PointerKey returnAtCallerKey = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, isExceptional ? callInstr.getException() : callInstr.getDef());
                            Set<CGNode> possibleTargets = DemandRefinementPointsTo.this.g.getPossibleTargets(caller, call, (LocalPointerKey)returnAtCallerKey);
                            if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleTargets)) {
                                this.propagateToCaller();
                            } else if (PointsToComputer.this.callToOTFTargets.get((Object)callSiteAndCGNode).contains(callee.getMethod())) {
                                this.propagateToCaller();
                            } else {
                                PointsToComputer.this.queryCallTargets(callSiteAndCGNode, callInstrs, callerState);
                            }
                            return null;
                        }
                    });
                }
            }
            if (curPk instanceof LocalPointerKey) {
                LocalPointerKey localPk = (LocalPointerKey)curPk;
                CGNode caller = localPk.getNode();
                for (SSAAbstractInvokeInstruction callInstr : Iterator2Iterable.make(DemandRefinementPointsTo.this.g.getInstrsPassingParam(localPk))) {
                    for (int i = 0; i < callInstr.getNumberOfUses(); ++i) {
                        Set<CGNode> possibleCallees;
                        if (localPk.getValueNumber() != callInstr.getUse(i)) continue;
                        CallSiteReference callSiteRef = callInstr.getCallSite();
                        CallerSiteContext callSiteAndCGNode = new CallerSiteContext(caller, callSiteRef);
                        if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleCallees = DemandRefinementPointsTo.this.g.getPossibleTargets(caller, callSiteRef, localPk))) {
                            for (CGNode callee : possibleCallees) {
                                if (this.calleeSubGraphMissingAndShouldNotBeAdded(addGraphs, callee, curPkAndState) || DemandRefinementPointsTo.hasNullIR(callee)) continue;
                                DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                                PointerKey paramVal = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(callee, i + 1);
                                assert (DemandRefinementPointsTo.this.g.containsNode(paramVal));
                                handler.handle(curPkAndState, paramVal, ParamBarLabel.make(callSiteAndCGNode));
                            }
                            continue;
                        }
                        if (this.callToOTFTargets.containsKey((Object)callSiteAndCGNode)) {
                            Set targetMethods = this.callToOTFTargets.get((Object)callSiteAndCGNode);
                            for (CGNode callee : possibleCallees) {
                                if (!targetMethods.contains(callee.getMethod()) || DemandRefinementPointsTo.hasNullIR(callee)) continue;
                                DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                                PointerKey paramVal = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(callee, i + 1);
                                assert (DemandRefinementPointsTo.this.g.containsNode(paramVal));
                                handler.handle(curPkAndState, paramVal, ParamBarLabel.make(callSiteAndCGNode));
                            }
                            continue;
                        }
                        this.queryCallTargets(callSiteAndCGNode, DemandRefinementPointsTo.getCallInstrs(caller, callSiteAndCGNode.getCallSite()), curState);
                    }
                }
            }
        }

        protected boolean calleeSubGraphMissingAndShouldNotBeAdded(boolean addGraphs, CGNode callee, PointerKeyAndState pkAndState) {
            return !addGraphs && !DemandRefinementPointsTo.this.g.hasSubgraphForNode(callee);
        }

        public void handleTrackedPointsToWorklist() {
            while (!this.trackedPointsToWorklist.isEmpty()) {
                DemandRefinementPointsTo.this.incrementNumNodesTraversed();
                final PointerKeyAndState curPkAndState = this.trackedPointsToWorklist.iterator().next();
                this.trackedPointsToWorklist.remove(curPkAndState);
                final PointerKey curPk = curPkAndState.getPointerKey();
                final StateMachine.State curState = curPkAndState.getState();
                final MutableIntSet trackedSet = this.find(this.pkToTrackedSet, curPkAndState);
                AbstractFlowLabelVisitor succVisitor = new AbstractFlowLabelVisitor(){

                    @Override
                    public void visitPutField(PutFieldLabel label, Object dst) {
                        PointerKey dstPtrKey;
                        IField field = label.getField();
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(field, curPk, dstPtrKey = (PointerKey)dst, label, curState)) {
                            for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet((IntSet)trackedSet)) {
                                boolean needField = PointsToComputer.this.forwInstKeyToFields.get((Object)ikAndState).contains(field);
                                PointerKeyAndState storeDst = new PointerKeyAndState(dstPtrKey, curState);
                                PointsToComputer.this.encounteredStores.add(new StoreEdge(curPkAndState, field, storeDst));
                                if (!needField || PointsToComputer.this.addToInitWorklist(storeDst)) continue;
                                InstanceFieldKeyAndState ifk = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToP2Set, ifk).addAll((IntSet)PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, storeDst));
                            }
                        }
                    }
                };
                DemandRefinementPointsTo.this.g.visitSuccs(curPk, succVisitor);
                AbstractFlowLabelVisitor predVisitor = new AbstractFlowLabelVisitor(){

                    @Override
                    public void visitAssignGlobal(AssignGlobalLabel label, Object dst) {
                        for (Object o : Iterator2Iterable.make(DemandRefinementPointsTo.this.g.getReadsOfStaticField((StaticFieldKey)dst))) {
                            PointerKey predPk = (PointerKey)o;
                            DemandRefinementPointsTo.this.doTransition(curState, AssignGlobalBarLabel.v(), predPkState -> {
                                PointerKeyAndState predPkAndState = new PointerKeyAndState(predPk, (StateMachine.State)predPkState);
                                PointsToComputer.this.handleTrackedPred(trackedSet, predPkAndState, AssignGlobalBarLabel.v());
                                return null;
                            });
                        }
                    }

                    @Override
                    public void visitPutField(PutFieldLabel label, Object dst) {
                        block3: {
                            PointerKey storeBase;
                            IField field;
                            block2: {
                                field = label.getField();
                                if (!DemandRefinementPointsTo.this.refineFieldAccesses(field, storeBase = (PointerKey)dst, curPk, label.bar(), curState)) break block2;
                                PointerKeyAndState storeBaseAndState = new PointerKeyAndState(storeBase, curState);
                                PointsToComputer.this.encounteredStores.add(new StoreEdge(storeBaseAndState, field, curPkAndState));
                                if (PointsToComputer.this.addToInitWorklist(storeBaseAndState)) break block3;
                                for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet((IntSet)PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, storeBaseAndState))) {
                                    InstanceFieldKeyAndState ifk = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                    PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToTrackedSet, ifk).addAll((IntSet)trackedSet);
                                    PointsToComputer.this.trackInstanceField(ikAndState, field, (MultiMap<InstanceKeyAndState, IField>)PointsToComputer.this.backInstKeyToFields);
                                }
                                break block3;
                            }
                            for (PointerKey predPk : Iterator2Iterable.make(DemandRefinementPointsTo.this.g.getReadsOfInstanceField(storeBase, field))) {
                                DemandRefinementPointsTo.this.doTransition(curState, MatchBarLabel.v(), predPkState -> {
                                    PointerKeyAndState predPkAndState = new PointerKeyAndState(predPk, (StateMachine.State)predPkState);
                                    PointsToComputer.this.handleTrackedPred(trackedSet, predPkAndState, MatchBarLabel.v());
                                    return null;
                                });
                            }
                        }
                    }

                    @Override
                    public void visitGetField(GetFieldLabel label, Object dst) {
                        PointerKey dstPtrKey;
                        IField field = label.getField();
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(field, curPk, dstPtrKey = (PointerKey)dst, label.bar(), curState)) {
                            for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet((IntSet)trackedSet)) {
                                boolean needField = PointsToComputer.this.backInstKeyToFields.get((Object)ikAndState).contains(field);
                                PointerKeyAndState loadedVal = new PointerKeyAndState(dstPtrKey, curState);
                                PointsToComputer.this.addEncounteredLoad(new LoadEdge(curPkAndState, field, loadedVal));
                                if (!needField) continue;
                                InstanceFieldKeyAndState ifk = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                PointsToComputer.this.handleTrackedPred(PointsToComputer.this.find(PointsToComputer.this.instFieldKeyToTrackedSet, ifk), loadedVal, AssignBarLabel.noFilter());
                            }
                        }
                    }

                    @Override
                    public void visitAssign(AssignLabel label, Object dst) {
                        PointerKey predPk = (PointerKey)dst;
                        DemandRefinementPointsTo.this.doTransition(curState, label.bar(), predPkState -> {
                            PointerKeyAndState predPkAndState = new PointerKeyAndState(predPk, (StateMachine.State)predPkState);
                            PointsToComputer.this.handleTrackedPred(trackedSet, predPkAndState, label.bar());
                            return null;
                        });
                    }
                };
                DemandRefinementPointsTo.this.g.visitPreds(curPk, predVisitor);
                this.handleBackInterproc(curPkAndState, new CopyHandler(){

                    @Override
                    void handle(PointerKeyAndState src, PointerKey dst, IFlowLabel label) {
                        assert (src == curPkAndState);
                        DemandRefinementPointsTo.this.doTransition(curState, label, dstState -> {
                            PointerKeyAndState dstAndState = new PointerKeyAndState(dst, (StateMachine.State)dstState);
                            PointsToComputer.this.handleTrackedPred(trackedSet, dstAndState, label);
                            return null;
                        });
                    }
                }, true);
            }
        }

        private void addEncounteredLoad(LoadEdge loadEdge) {
            if (this.encounteredLoads.add(loadEdge)) {
                // empty if block
            }
        }

        public void makePassOverFieldStmts() {
            IField field;
            for (StoreEdge storeEdge : this.encounteredStores) {
                PointerKeyAndState storedValAndState = storeEdge.val;
                field = storeEdge.field;
                PointerKeyAndState baseAndState = storeEdge.base;
                MutableIntSet trackedSet = this.find(this.pkToTrackedSet, baseAndState);
                for (InstanceKeyAndState ikAndState : this.makeOrdinalSet((IntSet)trackedSet)) {
                    if (!this.forwInstKeyToFields.get((Object)ikAndState).contains(field) || this.addToInitWorklist(storedValAndState)) continue;
                    InstanceFieldKeyAndState ifk = this.getInstFieldKey(ikAndState, field);
                    this.findOrCreate(this.instFieldKeyToP2Set, ifk).addAll((IntSet)this.find(this.pkToP2Set, storedValAndState));
                }
            }
            for (LoadEdge loadEdge : this.encounteredLoads) {
                boolean basePointerOkay;
                PointerKeyAndState loadedValAndState = loadEdge.val;
                field = loadEdge.field;
                PointerKey basePointerKey = loadEdge.base.getPointerKey();
                StateMachine.State loadDstState = loadedValAndState.getState();
                PointerKeyAndState baseAndStateToHandle = new PointerKeyAndState(basePointerKey, loadDstState);
                boolean bl = basePointerOkay = this.pointsToQueried.get((Object)basePointerKey).contains(loadDstState) || !this.pointsToQueried.get((Object)loadedValAndState.getPointerKey()).contains(loadDstState) || this.initWorklist.contains(loadedValAndState);
                if (!basePointerOkay) {
                    // empty if block
                }
                MutableIntSet curP2Set = this.find(this.pkToP2Set, baseAndStateToHandle);
                for (InstanceKeyAndState ikAndState : this.makeOrdinalSet((IntSet)curP2Set)) {
                    InstanceFieldKeyAndState ifk = this.getInstFieldKey(ikAndState, field);
                    if (!this.pointsToQueried.get((Object)loadedValAndState.getPointerKey()).contains(loadedValAndState.getState()) || !this.addAllToP2Set(this.pkToP2Set, loadedValAndState, (IntSet)this.find(this.instFieldKeyToP2Set, ifk), AssignLabel.noFilter())) continue;
                    this.addToPToWorklist(loadedValAndState);
                }
                PointerKeyAndState baseAndState = loadEdge.base;
                for (InstanceKeyAndState ikAndState : this.makeOrdinalSet((IntSet)this.find(this.pkToTrackedSet, baseAndState))) {
                    if (!this.backInstKeyToFields.get((Object)ikAndState).contains(field)) continue;
                    InstanceFieldKeyAndState ifk = this.getInstFieldKey(ikAndState, field);
                    if (!this.findOrCreate(this.pkToTrackedSet, loadedValAndState).addAll((IntSet)this.find(this.instFieldKeyToTrackedSet, ifk))) continue;
                    this.addToTrackedPToWorklist(loadedValAndState);
                }
            }
        }

        private InstanceFieldKeyAndState getInstFieldKey(InstanceKeyAndState ikAndState, IField field) {
            return new InstanceFieldKeyAndState(new InstanceFieldKey(ikAndState.getInstanceKey(), field), ikAndState.getState());
        }

        protected <K> MutableIntSet findOrCreate(Map<K, MutableIntSet> M, K key) {
            MutableIntSet result = M.get(key);
            if (result == null) {
                result = this.intSetFactory.make();
                M.put(key, result);
            }
            return result;
        }

        protected <K> MutableIntSet find(Map<K, MutableIntSet> M, K key) {
            MutableIntSet result = M.get(key);
            if (result == null) {
                result = this.emptySet;
            }
            return result;
        }

        protected boolean handleTrackedPred(MutableIntSet curTrackedSet, PointerKeyAndState predPkAndState, IFlowLabel label) {
            if (this.addAllToP2Set(this.pkToTrackedSet, predPkAndState, (IntSet)curTrackedSet, label)) {
                this.addToTrackedPToWorklist(predPkAndState);
                return true;
            }
            return false;
        }
    }

    private static final class LoadEdge {
        final PointerKeyAndState base;
        final IField field;
        final PointerKeyAndState val;

        public String toString() {
            return this.val + " := " + this.base + ", field " + this.field;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.val.hashCode();
            result = 31 * result + this.field.hashCode();
            result = 31 * result + this.base.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LoadEdge other = (LoadEdge)obj;
            if (!this.val.equals(other.val)) {
                return false;
            }
            if (!this.field.equals(other.field)) {
                return false;
            }
            return this.base.equals(other.base);
        }

        public LoadEdge(PointerKeyAndState base, IField field, PointerKeyAndState val) {
            this.base = base;
            this.field = field;
            this.val = val;
        }
    }

    private static final class StoreEdge {
        final PointerKeyAndState base;
        final IField field;
        final PointerKeyAndState val;

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.val.hashCode();
            result = 31 * result + this.field.hashCode();
            result = 31 * result + this.base.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StoreEdge other = (StoreEdge)obj;
            if (!this.val.equals(other.val)) {
                return false;
            }
            if (!this.field.equals(other.field)) {
                return false;
            }
            return this.base.equals(other.base);
        }

        public StoreEdge(PointerKeyAndState base, IField field, PointerKeyAndState val) {
            this.base = base;
            this.field = field;
            this.val = val;
        }
    }

    private static abstract class CopyHandler {
        private CopyHandler() {
        }

        abstract void handle(PointerKeyAndState var1, PointerKey var2, IFlowLabel var3);
    }

    public static enum PointsToResult {
        SUCCESS,
        NOMOREREFINE,
        BUDGETEXCEEDED;

    }
}

