/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.client;

import com.ibm.wala.analysis.pointers.BasicHeapGraph;
import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.ClassLoaderFactoryImpl;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.client.AnalysisEngine;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.slicer.SDG;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ssa.DefaultIRFactory;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.jar.JarFile;

public abstract class AbstractAnalysisEngine<I extends InstanceKey, X extends CallGraphBuilder<I>, Y>
implements AnalysisEngine {
    public static final String SYNTHETIC_J2SE_MODEL = "SyntheticJ2SEModel.txt";
    protected static final int DEBUG_LEVEL = 1;
    private String exclusionsFile = "J2SEClassHierarchyExclusions.txt";
    protected Collection<? extends Module> moduleFiles;
    protected AnalysisScope scope;
    private AnalysisOptions options;
    private IAnalysisCacheView cache = null;
    protected Module[] j2seLibs;
    private boolean closedWorld = false;
    private IClassHierarchy cha;
    protected CallGraph cg;
    protected PointerAnalysis<I> pointerAnalysis;
    private HeapGraph<?> heapGraph;
    private EntrypointBuilder entrypointBuilder = this::makeDefaultEntrypoints;

    protected abstract X getCallGraphBuilder(IClassHierarchy var1, AnalysisOptions var2, IAnalysisCacheView var3);

    protected X buildCallGraph(IClassHierarchy cha, AnalysisOptions options, boolean savePointerAnalysis, MonitorUtil.IProgressMonitor monitor) throws IllegalArgumentException, CancelException {
        X builder = this.getCallGraphBuilder(cha, options, this.cache);
        this.cg = builder.makeCallGraph(options, monitor);
        if (savePointerAnalysis) {
            this.pointerAnalysis = builder.getPointerAnalysis();
        }
        return builder;
    }

    @Override
    public void setModuleFiles(Collection<? extends Module> moduleFiles) {
        this.moduleFiles = moduleFiles;
    }

    public void buildAnalysisScope() throws IOException {
        if (this.j2seLibs == null) {
            Assertions.UNREACHABLE((String)"no j2selibs specified. You probably did not call AppAnalysisEngine.setJ2SELibrary.");
        }
        this.scope = AnalysisScopeReader.readJavaScope(SYNTHETIC_J2SE_MODEL, new FileProvider().getFile(this.getExclusionsFile()), this.getClass().getClassLoader());
        for (Module j2seLib : this.j2seLibs) {
            this.scope.addToScope(this.scope.getPrimordialLoader(), j2seLib);
        }
        this.addApplicationModulesToScope();
    }

    public IClassHierarchy buildClassHierarchy() {
        ClassHierarchy cha = null;
        ClassLoaderFactory factory = this.makeClassLoaderFactory(this.getScope().getExclusions());
        try {
            cha = ClassHierarchyFactory.make(this.getScope(), factory);
        }
        catch (ClassHierarchyException e) {
            System.err.println("Class Hierarchy construction failed");
            System.err.println(e.toString());
            e.printStackTrace();
        }
        return cha;
    }

    protected ClassLoaderFactory makeClassLoaderFactory(SetOfClasses exclusions) {
        return new ClassLoaderFactoryImpl(exclusions);
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    protected IClassHierarchy setClassHierarchy(IClassHierarchy cha) {
        this.cha = cha;
        return this.cha;
    }

    protected CallGraph getCallGraph() {
        return this.cg;
    }

    protected void addApplicationModulesToScope() {
        ClassLoaderReference app = this.scope.getApplicationLoader();
        for (Module module : this.moduleFiles) {
            if (!(module instanceof Module)) {
                Assertions.UNREACHABLE((String)("Unexpected type: " + module.getClass()));
            }
            Module M = module;
            this.scope.addToScope(app, M);
        }
    }

    @Override
    public void setJ2SELibraries(JarFile[] libs) {
        if (libs == null) {
            throw new IllegalArgumentException("libs is null");
        }
        this.j2seLibs = new Module[libs.length];
        for (int i = 0; i < libs.length; ++i) {
            this.j2seLibs[i] = new JarFileModule(libs[i]);
        }
    }

    @Override
    public void setJ2SELibraries(Module[] libs) {
        if (libs == null) {
            throw new IllegalArgumentException("libs is null");
        }
        this.j2seLibs = (Module[])libs.clone();
    }

    @Override
    public void setClosedWorld(boolean b) {
        this.closedWorld = b;
    }

    public boolean isClosedWorld() {
        return this.closedWorld;
    }

    protected AnalysisScope getScope() {
        return this.scope;
    }

    public PointerAnalysis<? super I> getPointerAnalysis() {
        return this.pointerAnalysis;
    }

    public HeapGraph<?> getHeapGraph() {
        if (this.heapGraph == null) {
            this.heapGraph = new BasicHeapGraph<I>(this.getPointerAnalysis(), this.cg);
        }
        return this.heapGraph;
    }

    public SDG<? super I> getSDG(Slicer.DataDependenceOptions data, Slicer.ControlDependenceOptions ctrl) {
        return new SDG<I>(this.getCallGraph(), this.getPointerAnalysis(), data, ctrl);
    }

    public String getExclusionsFile() {
        return this.exclusionsFile;
    }

    public void setExclusionsFile(String exclusionsFile) {
        this.exclusionsFile = exclusionsFile;
    }

    @Override
    public AnalysisOptions getDefaultOptions(Iterable<Entrypoint> entrypoints) {
        return new AnalysisOptions(this.getScope(), entrypoints);
    }

    public IAnalysisCacheView makeDefaultCache() {
        return new AnalysisCacheImpl(new DefaultIRFactory());
    }

    protected Iterable<Entrypoint> makeDefaultEntrypoints(AnalysisScope scope, IClassHierarchy cha) {
        return Util.makeMainEntrypoints(scope, cha);
    }

    public void setEntrypointBuilder(EntrypointBuilder builder) {
        this.entrypointBuilder = builder;
    }

    public X defaultCallGraphBuilder() throws IllegalArgumentException, IOException {
        this.buildAnalysisScope();
        IClassHierarchy cha = this.buildClassHierarchy();
        this.setClassHierarchy(cha);
        Iterable<Entrypoint> eps = this.entrypointBuilder.createEntrypoints(this.scope, cha);
        this.options = this.getDefaultOptions(eps);
        this.cache = this.makeDefaultCache();
        return this.getCallGraphBuilder(cha, this.options, this.cache);
    }

    public CallGraph buildDefaultCallGraph() throws IllegalArgumentException, CancelException, IOException {
        return this.defaultCallGraphBuilder().makeCallGraph(this.options, null);
    }

    public IAnalysisCacheView getCache() {
        if (this.cache == null) {
            this.cache = this.makeDefaultCache();
        }
        return this.cache;
    }

    public AnalysisOptions getOptions() {
        return this.options;
    }

    public Y performAnalysis(PropagationCallGraphBuilder builder) throws CancelException {
        return null;
    }

    public static interface EntrypointBuilder {
        public Iterable<Entrypoint> createEntrypoints(AnalysisScope var1, IClassHierarchy var2);
    }
}

