/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.maven;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

public class JULMavenTransferListener
extends AbstractTransferListener {
    private final Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();
    private int lastLength;
    protected final Logger out = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void transferInitiated(TransferEvent event) {
        String message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        this.out.info(message + ": " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.out.warning(event.getException().getMessage() + " for " + resource.getRepositoryUrl() + resource.getResourceName());
    }

    public void transferSucceeded(TransferEvent event) {
        this.transferCompleted(event);
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        if (contentLength >= 0L) {
            String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
            String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
            String throughput = "";
            long duration = System.currentTimeMillis() - resource.getTransferStartTime();
            if (duration > 0L) {
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)contentLength / 1024.0 / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            this.out.info(type + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + throughput + ")");
        }
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.downloads.put(resource, event.getTransferredBytes());
        StringBuilder buffer = new StringBuilder(64);
        for (Map.Entry<TransferResource, Long> entry : this.downloads.entrySet()) {
            long total = entry.getKey().getContentLength();
            Long complete = entry.getValue();
            if (complete == null) continue;
            buffer.append(this.getStatus(complete, total)).append("  ");
        }
        int pad = this.lastLength - buffer.length();
        this.lastLength = buffer.length();
        this.pad(buffer, pad);
        buffer.append('\r');
        this.out.info(buffer.toString());
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return this.toKB(complete) + "/" + this.toKB(total) + " KB ";
        }
        if (total >= 0L) {
            return complete + "/" + total + " B ";
        }
        if (complete >= 1024L) {
            return this.toKB(complete) + " KB ";
        }
        return complete + " B ";
    }

    private void pad(StringBuilder buffer, int spaces) {
        String block = "                                        ";
        while (spaces > 0) {
            int n = Math.min(spaces, block.length());
            buffer.append(block, 0, n);
            spaces -= n;
        }
    }

    public void transferFailed(TransferEvent event) {
        this.transferCompleted(event);
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
    }

    private void transferCompleted(TransferEvent event) {
        this.downloads.remove(event.getResource());
        StringBuilder buffer = new StringBuilder(64);
        this.pad(buffer, this.lastLength);
        buffer.append('\r');
        this.out.info(buffer.toString());
    }

    protected long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }
}

