/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.translator.jdt;

import com.ibm.wala.cast.java.translator.jdt.JDT2CAstUtils;
import com.ibm.wala.cast.java.translator.jdt.JDTIdentityMapper;
import com.ibm.wala.cast.java.types.JavaPrimitiveTypeMap;
import com.ibm.wala.cast.java.types.JavaType;
import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.cast.tree.impl.CAstTypeDictionaryImpl;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;

public class JDTTypeDictionary
extends CAstTypeDictionaryImpl<ITypeBinding> {
    protected final AST fAst;
    protected final JDTIdentityMapper fIdentityMapper;

    public JDTTypeDictionary(AST ast, JDTIdentityMapper identityMapper) {
        this.fAst = ast;
        this.fIdentityMapper = identityMapper;
    }

    public CAstType getCAstTypeForUnion(UnionType astType) {
        List types = astType.types();
        HashSet elts = HashSetFactory.make();
        types.forEach(type -> elts.add(this.getCAstTypeFor(((Type)type).resolveBinding())));
        return new JdtUnionType(elts);
    }

    public CAstType getCAstTypeFor(Object astType) {
        ITypeBinding jdtType = JDT2CAstUtils.getErasedType((ITypeBinding)astType, this.fAst);
        Object type = super.getCAstTypeFor(astType);
        if (type == null) {
            if (jdtType.isClass() || jdtType.isEnum() || jdtType.isInterface()) {
                type = new JdtJavaType(jdtType);
            } else if (jdtType.isPrimitive()) {
                type = JavaPrimitiveTypeMap.lookupType((String)jdtType.getName());
            } else if (jdtType.isArray()) {
                type = new JdtJavaArrayType(jdtType);
            } else {
                Assertions.UNREACHABLE((String)"getCAstTypeFor() passed type that is not primitive, array, or class?");
            }
            super.map((Object)((ITypeBinding)astType), type);
        }
        return type;
    }

    public static final class JdtUnionType
    implements CAstType.Union {
        private final Set<CAstType> constituents;

        public JdtUnionType(Set<CAstType> constituents) {
            this.constituents = constituents;
        }

        public CAstType getType() {
            return this;
        }

        public String getName() {
            return "union" + this.constituents.toString();
        }

        public Collection<CAstType> getSupertypes() {
            return Collections.emptySet();
        }

        public Iterable<CAstType> getConstituents() {
            return this.constituents;
        }
    }

    public final class JdtJavaType
    implements JavaType {
        private final ITypeBinding fType;
        private Collection<CAstType> fSuperTypes = null;

        public String toString() {
            return super.toString() + ':' + this.getName();
        }

        public JdtJavaType(ITypeBinding type) {
            this.fType = type;
        }

        public String getName() {
            return JDTTypeDictionary.this.fIdentityMapper.getTypeRef(this.fType).getName().toString();
        }

        public Collection<CAstType> getSupertypes() {
            if (this.fSuperTypes == null) {
                this.buildSuperTypes();
            }
            return this.fSuperTypes;
        }

        private void buildSuperTypes() {
            ITypeBinding superType = this.fType.getSuperclass() == null ? JDTTypeDictionary.this.fAst.resolveWellKnownType("java.lang.Object") : this.fType.getSuperclass();
            int N = this.fType.getInterfaces().length + 1;
            this.fSuperTypes = new ArrayList<CAstType>(N);
            this.fSuperTypes.add(JDTTypeDictionary.this.getCAstTypeFor(superType));
            for (ITypeBinding t : this.fType.getInterfaces()) {
                this.fSuperTypes.add(JDTTypeDictionary.this.getCAstTypeFor(t));
            }
        }

        public Collection<CAstQualifier> getQualifiers() {
            return JDT2CAstUtils.mapModifiersToQualifiers(this.fType.getModifiers(), this.fType.isInterface(), this.fType.isAnnotation());
        }

        public boolean isInterface() {
            return this.fType.isInterface();
        }
    }

    private final class JdtJavaArrayType
    implements CAstType.Array {
        private final ITypeBinding fEltJdtType;
        private final CAstType fEltCAstType;

        private JdtJavaArrayType(ITypeBinding arrayType) {
            this.fEltJdtType = arrayType.getComponentType();
            this.fEltCAstType = JDTTypeDictionary.this.getCAstTypeFor(this.fEltJdtType);
        }

        public int getNumDimensions() {
            return 1;
        }

        public CAstType getElementType() {
            return this.fEltCAstType;
        }

        public String getName() {
            return '[' + this.fEltCAstType.getName();
        }

        public Collection<CAstType> getSupertypes() {
            if (this.fEltJdtType.isPrimitive()) {
                return Collections.singleton(JDTTypeDictionary.this.getCAstTypeFor(JDTTypeDictionary.this.fAst.resolveWellKnownType("java.lang.Object")));
            }
            assert (this.fEltJdtType.isArray() || this.fEltJdtType.isClass()) : "Non-primitive, non-reference array element type!";
            ArrayList<CAstType> supers = new ArrayList<CAstType>();
            for (ITypeBinding type : this.fEltJdtType.getInterfaces()) {
                supers.add(JDTTypeDictionary.this.getCAstTypeFor(type));
            }
            if (this.fEltJdtType.getSuperclass() != null) {
                supers.add(JDTTypeDictionary.this.getCAstTypeFor(this.fEltJdtType.getSuperclass()));
            }
            return supers;
        }
    }
}

