/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.locking.consistentkey;

import java.time.Instant;
import org.janusgraph.diskstorage.ReadBuffer;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.diskstorage.locking.consistentkey.TimestampRid;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.WriteBufferUtil;
import org.janusgraph.diskstorage.util.WriteByteBuffer;
import org.janusgraph.diskstorage.util.time.TimestampProvider;

public class ConsistentKeyLockerSerializer {
    public StaticBuffer toLockKey(StaticBuffer key, StaticBuffer column) {
        WriteByteBuffer b = new WriteByteBuffer(key.length() + column.length() + 4);
        b.putInt(key.length());
        WriteBufferUtil.put((WriteBuffer)b, key);
        WriteBufferUtil.put((WriteBuffer)b, column);
        return b.getStaticBuffer();
    }

    public StaticBuffer toLockCol(Instant ts, StaticBuffer rid, TimestampProvider provider) {
        WriteByteBuffer b = new WriteByteBuffer(rid.length() + 8);
        b.putLong(provider.getTime(ts));
        WriteBufferUtil.put((WriteBuffer)b, rid);
        return b.getStaticBuffer();
    }

    public TimestampRid fromLockColumn(StaticBuffer lockKey, TimestampProvider provider) {
        ReadBuffer r = lockKey.asReadBuffer();
        int len = r.length();
        long tsNS = r.getLong();
        byte[] curRid = new byte[len -= 8];
        int i = 0;
        while (r.hasRemaining()) {
            curRid[i] = r.getByte();
            ++i;
        }
        StaticArrayBuffer rid = new StaticArrayBuffer(curRid);
        Instant time = provider.getTime(tsNS);
        return new TimestampRid(time, rid);
    }
}

