/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.keycolumnvalue;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;

public class KeySliceQuery
extends SliceQuery {
    private final StaticBuffer key;

    public KeySliceQuery(StaticBuffer key, StaticBuffer sliceStart, StaticBuffer sliceEnd) {
        super(sliceStart, sliceEnd);
        this.key = (StaticBuffer)Preconditions.checkNotNull((Object)key);
    }

    public KeySliceQuery(StaticBuffer key, SliceQuery query) {
        super(query);
        this.key = (StaticBuffer)Preconditions.checkNotNull((Object)key);
    }

    public StaticBuffer getKey() {
        return this.key;
    }

    @Override
    public KeySliceQuery setLimit(int limit) {
        super.setLimit(limit);
        return this;
    }

    @Override
    public KeySliceQuery updateLimit(int newLimit) {
        return new KeySliceQuery(this.key, this).setLimit(newLimit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, super.hashCode());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        KeySliceQuery oth = (KeySliceQuery)other;
        return this.key.equals(oth.key) && super.equals(oth);
    }

    public boolean subsumes(KeySliceQuery oth) {
        return this.key.equals(oth.key) && super.subsumes(oth);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("KeySliceQuery(");
        builder.append(this.key).append(")[").append(this.getSliceStart()).append(",").append(this.getSliceEnd()).append(")");
        if (this.hasLimit()) {
            builder.append("@").append(this.getLimit());
        }
        return builder.toString();
    }
}

