/*
 * Decompiled with CFR 0.152.
 */
package io.tackle.diva;

import com.ibm.wala.cast.java.ipa.callgraph.JavaSourceAnalysisScope;
import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.cast.java.translator.jdt.ecj.ECJClassLoaderFactory;
import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphStats;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.config.FileOfClasses;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.warnings.Warnings;
import io.tackle.diva.Constraint;
import io.tackle.diva.Context;
import io.tackle.diva.Framework;
import io.tackle.diva.Util;
import io.tackle.diva.analysis.JDBCAnalysis;
import io.tackle.diva.analysis.JPAAnalysis;
import io.tackle.diva.analysis.ServletAnalysis;
import io.tackle.diva.analysis.SpringBootAnalysis;
import io.tackle.diva.irgen.DivaIRGen;
import io.tackle.diva.irgen.DivaSourceLoaderImpl;
import io.tackle.diva.irgen.FilteredClassHierarchy;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;

public class Standalone {
    private static final String EXCLUSIONS = "java\\/awt\\/.*\njavax\\/awt\\/.*\njavax\\/swing\\/.*\nsun\\/.*\njdk\\/.*\noracle\\/.*\napple\\/.*\nnetscape\\/.*\njavafx\\/.*\norg\\/w3c\\/.*\norg\\/xml\\/.*\norg\\/jcp\\/.*\norg\\/ietf\\/.*\norg\\/omg\\/.*\njava\\/security\\/.*\njava\\/beans\\/.*\njava\\/time\\/.*\njava\\/text\\/.*\njava\\/net\\/.*\njava\\/nio\\/.*\njava\\/math\\/.*\njava\\/applet\\/.*\njava\\/rmi\\/.*\n";

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption("s", "source", true, "source path");
        options.addOption("b", "binary", true, "binary path");
        options.addOption("c", "contexts", true, "contexts yaml file");
        options.addOption("u", "usage", true, "enable usage analysis");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
            if (!cmd.hasOption("source") && !cmd.hasOption("binary")) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            HelpFormatter hf = new HelpFormatter();
            hf.printHelp("[opts]", options);
            return;
        }
        Util.injectedCall(DivaIRGen.advices(), Standalone.class.getName() + ".run", cmd);
    }

    public static void run(CommandLine cmd) throws Exception {
        JavaSourceAnalysisScope scope = new JavaSourceAnalysisScope(){

            public boolean isApplicationLoader(IClassLoader loader) {
                return loader.getReference().equals((Object)ClassLoaderReference.Application) || loader.getReference().equals((Object)JavaSourceAnalysisScope.SOURCE);
            }
        };
        Standalone.addDefaultExclusions((AnalysisScope)scope);
        Path temp = Files.createTempDirectory("diva-temp", new FileAttribute[0]);
        Util.LOGGER.info("tempdir=" + temp);
        final String[] stdlibs = Framework.loadStandardLib((AnalysisScope)scope, temp);
        if (cmd.hasOption("source")) {
            String[] sourceDirs;
            for (String sourceDir : sourceDirs = cmd.getOptionValue("source").split(":")) {
                scope.addToScope(JavaSourceAnalysisScope.SOURCE, (Module)new SourceDirectoryTreeModule(new File(sourceDir)));
            }
        } else if (cmd.hasOption("binary")) {
            ArrayList<String> classRoots = new ArrayList<String>();
            ArrayList<String> jars = new ArrayList<String>();
            String[] binaryFiles = cmd.getOptionValue("binary").split(":");
            for (String s : binaryFiles) {
                if (new File(s).isDirectory()) {
                    classRoots.add(s);
                    continue;
                }
                if (s.endsWith(".ear") || s.endsWith(".war")) {
                    Framework.unpackArchives(s, temp.resolve("unpacked"), classRoots, jars);
                    continue;
                }
                if (Framework.checkSpringBoot(s)) {
                    Framework.unpackArchives(s, temp.resolve("unpacked"), classRoots, jars);
                    continue;
                }
                jars.add(s);
            }
            for (String classRoot : classRoots) {
                scope.addToScope(ClassLoaderReference.Application, (Module)new BinaryDirectoryTreeModule(new File(classRoot)));
            }
            for (String jar : jars) {
                scope.addToScope(ClassLoaderReference.Application, (Module)new JarFileModule(new JarFile(jar)));
            }
        }
        FileUtils.forceDeleteOnExit((File)temp.toFile());
        DivaIRGen.init();
        ClassHierarchy cha = ClassHierarchyFactory.makeWithRoot((AnalysisScope)scope, (ClassLoaderFactory)new ECJClassLoaderFactory(scope.getExclusions()){

            protected JavaSourceLoaderImpl makeSourceLoader(ClassLoaderReference classLoaderReference, IClassHierarchy cha, IClassLoader parent) {
                return new DivaSourceLoaderImpl(classLoaderReference, parent, cha, stdlibs);
            }
        });
        DivaIRGen.loadKnownIntefaces((IClassHierarchy)cha);
        Util.LOGGER.info("Done class hierarchy: " + cha.getNumberOfClasses() + " classes");
        Util.LOGGER.fine(Warnings.asString());
        HashSet<IClass> relevantClasses = new HashSet<IClass>();
        HashSet<IClass> appClasses = new HashSet<IClass>();
        Framework.relevantJarsAnalysis((IClassHierarchy)cha, relevantClasses, appClasses, c -> JDBCAnalysis.checkRelevance(c) || JPAAnalysis.checkRelevance(c) || SpringBootAnalysis.checkRelevance(c));
        FilteredClassHierarchy filteredCha = new FilteredClassHierarchy((IClassHierarchy)cha, appClasses::contains);
        FilteredClassHierarchy relevantCha = new FilteredClassHierarchy((IClassHierarchy)cha, relevantClasses::contains);
        ArrayList<IMethod> entries = new ArrayList<IMethod>();
        entries.addAll(ServletAnalysis.getEntries(filteredCha));
        entries.addAll(SpringBootAnalysis.getEntries(filteredCha));
        ArrayList<IMethod> cgEntries = new ArrayList<IMethod>();
        cgEntries.addAll(entries);
        cgEntries.addAll(SpringBootAnalysis.getInits(relevantCha));
        JPAAnalysis.getEntities((IClassHierarchy)cha);
        if (entries.isEmpty()) {
            Util.LOGGER.info("No entry methods found");
            return;
        }
        CallGraph cg = Standalone.gengraph((AnalysisScope)scope, relevantCha, cgEntries, relevantClasses);
        Framework fw = new Framework((IClassHierarchy)cha, cg, cmd.hasOption("usage"));
        fw.relevanceAnalysis(JDBCAnalysis::checkRelevance, JPAAnalysis::checkRelevance, SpringBootAnalysis::checkRelevance);
        for (CGNode n : cg) {
            if (!entries.contains(n.getMethod()) || !fw.isRelevant(n)) continue;
            fw.recordContraint(new Constraint.EntryConstraint(n));
        }
        fw.traverse((CGNode)cg.getNode(0), ServletAnalysis.getContextualAnalysis(fw));
        List<Context> contexts = !cmd.hasOption("contexts") ? Context.calculateDefaultContexts(fw) : Context.loadContexts(fw, cmd.getOptionValue("contexts"));
        ArrayList<Object> res = new ArrayList<Object>();
        Util.JsonReport report = new Util.JsonReport(res);
        for (Context cxt : contexts) {
            CGNode entry = null;
            for (Constraint c2 : cxt) {
                if (!(c2 instanceof Constraint.EntryConstraint)) continue;
                entry = ((Constraint.EntryConstraint)c2).node();
            }
            if (entry == null) continue;
            CGNode n = entry;
            report.add(map -> {
                for (Constraint c : cxt) {
                    c.report(map);
                }
                map.put("transactions", txs -> fw.calculateTransactions(n, cxt, txs));
            });
        }
        try (FileWriter f = new FileWriter("transaction.json");){
            f.write(Util.JSON_SERIALIZER.writeValueAsString(res));
        }
        f = new FileWriter("transaction.yml");
        var17_26 = null;
        try {
            f.write(Util.YAML_SERIALIZER.writeValueAsString(res));
        }
        catch (Throwable throwable) {
            var17_26 = throwable;
            throw throwable;
        }
        finally {
            if (f != null) {
                if (var17_26 != null) {
                    try {
                        ((Writer)f).close();
                    }
                    catch (Throwable throwable) {
                        var17_26.addSuppressed(throwable);
                    }
                } else {
                    ((Writer)f).close();
                }
            }
        }
    }

    public static CallGraph gengraph(AnalysisScope scope, IClassHierarchy cha, Collection<? extends IMethod> entries, Set<IClass> relevantClasses) throws IOException, CancelException {
        AnalysisOptions options = new AnalysisOptions();
        Supplier<CallGraph> builder = Framework.chaCgBuilder(cha, options, entries, m -> relevantClasses.contains(m.getDeclaringClass()));
        Util.LOGGER.info("building call graph...");
        CallGraph cg = builder.get();
        Util.LOGGER.info("done");
        Util.LOGGER.info(CallGraphStats.getStats((CallGraph)cg));
        return cg;
    }

    public static void addDefaultExclusions(AnalysisScope scope) throws UnsupportedEncodingException, IOException {
        scope.setExclusions((SetOfClasses)new FileOfClasses((InputStream)new ByteArrayInputStream(EXCLUSIONS.getBytes("UTF-8"))));
    }
}

