/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.generation.techreport;

import com.syncleus.ferma.VertexFrame;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.jboss.windup.config.tags.Tag;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.reporting.model.TagModel;
import org.jboss.windup.reporting.model.TechnologyUsageStatisticsModel;
import org.jboss.windup.reporting.service.TagGraphService;
import org.jboss.windup.util.exception.WindupException;

public class TechReportService {
    public static final String MAPPING_OF_PLACEMENT_NAMES = "techReport:mappingOfPlacementTagNames";
    private static final Logger LOG = Logger.getLogger(TechReportService.class.getName());
    private final GraphContext graphContext;

    public TechReportService(GraphContext graphContext) {
        this.graphContext = graphContext;
    }

    private static void mergeToTheRightCell(Map<String, Map<String, Map<Long, Map<String, TechUsageStatSum>>>> matrix, String rowName, String boxName, Long projectKey, String techLabel, TechnologyUsageStatisticsModel stat, boolean maxInsteadOfAdd) {
        Map rowAll = matrix.computeIfAbsent(rowName, k -> new HashMap());
        Map boxAll = rowAll.computeIfAbsent(boxName, k -> new HashMap());
        Map statSum = boxAll.computeIfAbsent(projectKey, k -> new HashMap());
        TechUsageStatSum techUsageStatSum = statSum.computeIfAbsent(techLabel, k -> new TechUsageStatSum(techLabel));
        if (maxInsteadOfAdd) {
            techUsageStatSum.max(stat);
        } else {
            techUsageStatSum.add(stat);
        }
    }

    private static Set<String> getPlacementTags(GraphContext graphContext, Set<String> potentialPlaceTags) {
        TagGraphService tagService = new TagGraphService(graphContext);
        HashSet<String> placeNames = new HashSet<String>();
        potentialPlaceTags.forEach(name -> {
            TagModel placeTag = tagService.getTagByName("place:" + Tag.normalizeName((String)name));
            if (null != placeTag) {
                placeNames.add(placeTag.getName());
            }
        });
        return placeNames;
    }

    private static TechReportPlacement processPlaceLabels(GraphContext graphContext, Set<String> tagNames) {
        TagGraphService tagService = new TagGraphService(graphContext);
        if (tagNames.size() < 3) {
            throw new WindupException("There should always be exactly 3 placement labels - row, sector, column/box. It was: " + tagNames);
        }
        if (tagNames.size() > 3) {
            LOG.severe("There should always be exactly 3 placement labels - row, sector, column/box. It was: " + tagNames);
        }
        TechReportPlacement placement = new TechReportPlacement();
        TagModel placeSectorsTag = tagService.getTagByName("techReport:placeSectors");
        TagModel placeBoxesTag = tagService.getTagByName("techReport:placeBoxes");
        TagModel placeRowsTag = tagService.getTagByName("techReport:placeRows");
        HashSet<String> unknownTags = new HashSet<String>();
        for (String name : tagNames) {
            TagModel tag = tagService.getTagByName(name);
            if (null == tag) continue;
            if (TagGraphService.isTagUnderTagOrSame((TagModel)tag, (TagModel)placeSectorsTag)) {
                placement.sector = tag;
                continue;
            }
            if (TagGraphService.isTagUnderTagOrSame((TagModel)tag, (TagModel)placeBoxesTag)) {
                placement.box = tag;
                continue;
            }
            if (TagGraphService.isTagUnderTagOrSame((TagModel)tag, (TagModel)placeRowsTag)) {
                placement.row = tag;
                continue;
            }
            unknownTags.add(name);
        }
        placement.unknown = unknownTags;
        LOG.fine(String.format("\t\tLabels %s identified as: sector: %s, box: %s, row: %s", tagNames, placement.sector, placement.box, placement.row));
        if (placement.box == null || placement.row == null) {
            LOG.severe(String.format("There should always be exactly 3 placement labels - row, sector, column/box. Found: %s, of which box: %s, row: %s", tagNames, placement.box, placement.row));
        }
        return placement;
    }

    private static TechReportPlacement normalizePlacement(GraphContext graphContext, TechReportPlacement placement) {
        TagGraphService tagService = new TagGraphService(graphContext);
        TechReportPlacement normalPlacement = new TechReportPlacement();
        normalPlacement.sector = TechReportService.getNonPlaceParent(tagService, placement.sector);
        normalPlacement.box = TechReportService.getNonPlaceParent(tagService, placement.box);
        normalPlacement.row = TechReportService.getNonPlaceParent(tagService, placement.row);
        return normalPlacement;
    }

    private static TagModel getNonPlaceParent(TagGraphService tagService, TagModel tag) {
        if (tag == null) {
            return null;
        }
        TagModel placeRoot = tagService.getTagByName(MAPPING_OF_PLACEMENT_NAMES);
        Iterator parents = tag.getDesignatedByTags().iterator();
        if (!parents.hasNext()) {
            throw new WindupException("Tag is not designated by any tags: " + tag);
        }
        TagModel nonPlaceParent = null;
        while (parents.hasNext()) {
            TagModel parentTag = (TagModel)parents.next();
            if (TagGraphService.isTagUnderTagOrSame((TagModel)parentTag, (TagModel)placeRoot)) continue;
            if (nonPlaceParent != null) {
                throw new WindupException(String.format("Tag %s has more than one non-placement parent: %s, %s", tag.getName(), nonPlaceParent, parentTag));
            }
            nonPlaceParent = parentTag;
        }
        return nonPlaceParent;
    }

    public TechStatsMatrix getTechStatsMap(ProjectModel appBeingSummarized) {
        HashMap<String, Map<String, Map<Long, Map<String, TechUsageStatSum>>>> map = new HashMap<String, Map<String, Map<Long, Map<String, TechUsageStatSum>>>>();
        List statModels = this.graphContext.service(TechnologyUsageStatisticsModel.class).findAll();
        for (TechnologyUsageStatisticsModel stat : statModels) {
            if (appBeingSummarized != null) {
                boolean statAppliesToSeveralApps;
                boolean appIsContainedInStatProject = stat.getProjectModel().getApplications().contains(appBeingSummarized);
                boolean appIsASharedLibrary = appBeingSummarized.getName().toLowerCase().contains("shared");
                boolean bl = statAppliesToSeveralApps = stat.getProjectModel().getApplications().size() > 1;
                if (!appIsContainedInStatProject || statAppliesToSeveralApps && !appIsASharedLibrary) {
                    LOG.fine("\t\tThis stat is not for this project, skipping.");
                    continue;
                }
            }
            Set<String> placementTags = TechReportService.getPlacementTags(this.graphContext, stat.getTags());
            TechReportPlacement placement = TechReportService.processPlaceLabels(this.graphContext, placementTags);
            if (placement.box == null || placement.row == null) {
                LOG.severe(String.format("\tPlacement labels not recognized, placement incomplete: %s; stat: %s", placement, stat));
                continue;
            }
            placement = TechReportService.normalizePlacement(this.graphContext, placement);
            if (placement.box == null || placement.row == null) {
                LOG.severe(String.format("\tPlacement labels not recognized, placement incomplete: %s; stat: %s", placement, stat));
                continue;
            }
            TechReportService.mergeToTheRightCell(map, placement.row.getName(), placement.box.getName(), 0L, stat.getName(), stat, false);
            TechReportService.mergeToTheRightCell(map, "", placement.box.getName(), 0L, "", stat, true);
            List<Long> appsToCountTowards = appBeingSummarized == null ? StreamSupport.stream(stat.getProjectModel().getApplications().spliterator(), false).map(VertexFrame::getElement).map(Element::id).map(Long.class::cast).collect(Collectors.toList()) : Collections.singletonList((Long)appBeingSummarized.getId());
            boolean isSharedApp = appsToCountTowards.size() > 1;
            List apps = stat.getProjectModel().getApplications();
            List sharedApps = apps.stream().filter(app -> app.getName().toLowerCase().contains("shared")).collect(Collectors.toList());
            for (Long appToCountTowards : appsToCountTowards) {
                if (isSharedApp && !sharedApps.stream().anyMatch(app -> app.getElement().id().equals(appToCountTowards))) continue;
                TechReportService.mergeToTheRightCell(map, placement.row.getName(), placement.box.getName(), appToCountTowards, stat.getName(), stat, false);
                TechReportService.mergeToTheRightCell(map, "", placement.box.getName(), appToCountTowards, "", stat, false);
            }
        }
        return new TechStatsMatrix(map);
    }

    public static class TechUsageStatSumComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof TechUsageStatSum) || !(o2 instanceof TechUsageStatSum)) {
                throw new ClassCastException();
            }
            if (((TechUsageStatSum)o1).getOccurrenceCount() < ((TechUsageStatSum)o2).getOccurrenceCount()) {
                return -1;
            }
            if (((TechUsageStatSum)o1).getOccurrenceCount() > ((TechUsageStatSum)o2).getOccurrenceCount()) {
                return 1;
            }
            return 0;
        }
    }

    public static class TechUsageStatSum {
        String name;
        int count = 0;
        Set<String> tags = new HashSet<String>();

        public TechUsageStatSum(String name) {
            this.name = name;
        }

        public TechUsageStatSum max(TechnologyUsageStatisticsModel stat) {
            this.count = Math.max(this.count, stat.getOccurrenceCount());
            return this;
        }

        public TechUsageStatSum add(TechnologyUsageStatisticsModel stat) {
            if (!"".equals(this.name) && !this.name.equals(stat.getName())) {
                throw new IllegalArgumentException("Can't add up stats, " + this.name + " != " + stat.getName());
            }
            this.count += stat.getOccurrenceCount();
            this.tags.addAll(stat.getTags());
            return this;
        }

        public TechUsageStatSum add(TechUsageStatSum stat) {
            if (!"".equals(this.name) && !this.name.equals(stat.getName())) {
                throw new IllegalArgumentException("Can't add up stats, " + this.name + " != " + stat.getName());
            }
            this.count += stat.getOccurrenceCount();
            this.tags.addAll(stat.getTags());
            return this;
        }

        public String getName() {
            return this.name;
        }

        public int getOccurrenceCount() {
            return this.count;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public String toString() {
            return "{" + this.name + " " + this.count + "\u00d7, [" + this.tags + "]}";
        }
    }

    public static class TechReportPlacement {
        TagModel sector;
        TagModel box;
        TagModel row;
        Set<String> unknown;

        public String toString() {
            return "TechReportPlacement{sector=" + this.sector + ", box=" + this.box + ", row=" + this.row + ", unknown=" + this.unknown + "}";
        }
    }

    public static class TechStatsMatrix {
        private Map<String, Map<String, Map<Long, Map<String, TechUsageStatSum>>>> map = new HashMap<String, Map<String, Map<Long, Map<String, TechUsageStatSum>>>>();

        public TechStatsMatrix(Map<String, Map<String, Map<Long, Map<String, TechUsageStatSum>>>> map) {
            this.map = map;
        }

        public TechStatsMatrix() {
        }

        public int getMaxForBox(String boxTagName) {
            Map<String, Map<Long, Map<String, TechUsageStatSum>>> rowMap = this.map.get("");
            if (null == rowMap) {
                return 0;
            }
            Map<Long, Map<String, TechUsageStatSum>> boxMap = rowMap.get(boxTagName);
            if (null == boxMap) {
                return 0;
            }
            int max = 0;
            for (Map.Entry<Long, Map<String, TechUsageStatSum>> boxEntry : boxMap.entrySet()) {
                for (Map.Entry<String, TechUsageStatSum> technologyEntry : boxEntry.getValue().entrySet()) {
                    max = Math.max(max, technologyEntry.getValue().count);
                }
            }
            return max;
        }

        public Map<String, TechUsageStatSum> get(String rowTagName, String boxTagName, Long projectId) {
            Map<String, Map<Long, Map<String, TechUsageStatSum>>> rowMap = this.map.get(rowTagName);
            if (null == rowMap) {
                return null;
            }
            Map<Long, Map<String, TechUsageStatSum>> boxMap = rowMap.get(boxTagName);
            if (null == boxMap) {
                return null;
            }
            return boxMap.get(projectId);
        }

        public TechUsageStatSum get(String rowTagName, String boxTagName, Long projectId, String technology) {
            Map<String, TechUsageStatSum> byProject = this.get(rowTagName, boxTagName, projectId);
            if (null == byProject) {
                return null;
            }
            return byProject.get(technology);
        }

        public Map<String, TechUsageStatSum> getSummarizedStatsByTechnology(String boxTagName, Long projectId) {
            Set<String> rowTagNames = this.map.keySet();
            LinkedHashMap interimStatMap = new LinkedHashMap();
            LinkedHashMap<String, TechUsageStatSum> returnStatMap = new LinkedHashMap<String, TechUsageStatSum>();
            rowTagNames.forEach(rowTagName -> {
                Map<String, Map<Long, Map<String, TechUsageStatSum>>> rowMap = this.map.get(rowTagName);
                Map<Long, Map<String, TechUsageStatSum>> boxMap = rowMap.get(boxTagName);
                if (boxMap != null) {
                    Map<String, TechUsageStatSum> statMap = boxMap.get(projectId);
                    Set interimStatKeys = interimStatMap.keySet();
                    if (statMap != null) {
                        statMap.keySet().forEach(statKey -> {
                            if (interimStatKeys.contains(statKey)) {
                                ((TechUsageStatSum)interimStatMap.get((Object)statKey)).count += ((TechUsageStatSum)statMap.get((Object)statKey)).count;
                            } else {
                                interimStatMap.put(statKey, (TechUsageStatSum)statMap.get(statKey));
                            }
                        });
                    }
                }
            });
            returnStatMap.put("", (TechUsageStatSum)interimStatMap.get(""));
            interimStatMap.entrySet().stream().filter(e -> e.getKey() != "").sorted(Map.Entry.comparingByValue(new TechUsageStatSumComparator()).reversed()).forEachOrdered(x -> returnStatMap.put((String)((Map.Entry)x).getKey(), (TechUsageStatSum)((Map.Entry)x).getValue()));
            return returnStatMap;
        }
    }
}

