/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.generation.techreport;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.rules.generation.techreport.TechReportService;
import org.jboss.windup.util.ExecutionStatistics;

public class SortTechUsageStatsMethod
implements WindupFreeMarkerMethod {
    public static final Logger LOG = Logger.getLogger(SortTechUsageStatsMethod.class.getName());
    private static final String NAME = "sortTechUsageStats";
    private GraphContext graphContext;
    private TechReportService techReportService;

    public void setContext(GraphRewrite event) {
        this.graphContext = event.getGraphContext();
        this.techReportService = new TechReportService(this.graphContext);
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Sorts out the TechnologyUsageStatisticsModel-s into columns/boxes and rows defined by techReport-hierarchy.xml as per the tags and labels in the <technology-identified> operations.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        StringModel projectArg;
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() > 1) {
            throw new TemplateModelException("Expected 0 or 1 argument - project.");
        }
        ProjectModel application = null;
        if (arguments.size() == 1 && null != (projectArg = (StringModel)arguments.get(0))) {
            application = (ProjectModel)projectArg.getWrappedObject();
        }
        TechReportService.TechStatsMatrix matrix = this.techReportService.getTechStatsMap(application);
        ExecutionStatistics.get().end(NAME);
        return matrix;
    }
}

