/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.generation.techreport;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.exception.WindupException;

public class GetNumberOfLibrariesMethod
implements WindupFreeMarkerMethod {
    public static final Logger LOG = Logger.getLogger(GetNumberOfLibrariesMethod.class.getName());
    private static final String NAME = "getNumberOfLibraries";
    private GraphContext graphContext;

    public void setContext(GraphRewrite event) {
        this.graphContext = event.getGraphContext();
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes a " + ProjectModel.class.getSimpleName() + " as a parameter and returns a count of the number of libraries contained within";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        ProjectModel projectModel = null;
        if (arguments.size() >= 1) {
            StringModel projectArg = (StringModel)arguments.get(0);
            projectModel = (ProjectModel)projectArg.getWrappedObject();
        }
        if (projectModel == null) {
            String errorMessage = "GetNumberOfLibrariesMethod: No project present to count libraries";
            throw new WindupException(errorMessage);
        }
        Integer result = this.countLibrariesInModel(this.graphContext, projectModel);
        ExecutionStatistics.get().end(NAME);
        return result;
    }

    private Integer countLibrariesInModel(GraphContext graphContext, ProjectModel projectModel) {
        int count = 0;
        for (ProjectModel child : projectModel.getChildProjects()) {
            if (!(child.getRootFileModel() instanceof ArchiveModel)) continue;
            ++count;
            count += this.countLibrariesInModel(graphContext, child).intValue();
        }
        return count;
    }
}

