/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.generation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.PostFinalizePhase;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.reporting.model.rule.ExecutionPhaseModel;
import org.jboss.windup.reporting.model.rule.RuleExecutionModel;
import org.jboss.windup.reporting.model.rule.RuleProviderModel;
import org.jboss.windup.reporting.ruleexecution.RuleExecutionInformation;
import org.jboss.windup.reporting.ruleexecution.RuleExecutionInformationForReading;
import org.jboss.windup.reporting.ruleexecution.RuleExecutionResultsListener;
import org.jboss.windup.reporting.service.rule.ExecutionPhaseService;
import org.jboss.windup.reporting.service.rule.RuleExecutionService;
import org.jboss.windup.reporting.service.rule.RuleProviderService;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=PostFinalizePhase.class)
public class CreateRuleProviderReportRuleProvider
extends AbstractRuleProvider {
    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        GraphOperation addRuleReports = new GraphOperation(){
            Map<String, ExecutionPhaseModel> phaseModelMap;
            GraphContext graphContext;
            RuleProviderService ruleProviderService;
            RuleExecutionService ruleExecutionService;
            ExecutionPhaseService executionPhaseService;

            private void initialize(GraphContext graphContext) {
                this.graphContext = graphContext;
                this.ruleProviderService = new RuleProviderService(this.graphContext);
                this.ruleExecutionService = new RuleExecutionService(this.graphContext);
                this.executionPhaseService = new ExecutionPhaseService(this.graphContext);
                this.phaseModelMap = new HashMap<String, ExecutionPhaseModel>();
            }

            public void perform(GraphRewrite event, EvaluationContext context) {
                this.initialize(event.getGraphContext());
                List ruleProviderList = RuleProviderRegistry.instance((GraphRewrite)event).getProviders();
                for (RuleProvider ruleProvider : ruleProviderList) {
                    if (ruleProvider instanceof RulePhase) {
                        this.addPhase(ruleProvider.getMetadata().getID());
                        continue;
                    }
                    RuleProviderModel ruleProviderModel = (RuleProviderModel)this.ruleProviderService.create();
                    ruleProviderModel.setRuleProviderID(ruleProvider.getMetadata().getID());
                    ExecutionPhaseModel executionPhaseModel = this.getPhaseModel(ruleProvider);
                    executionPhaseModel.addRuleProvider(ruleProviderModel);
                    List ruleProviderInfo = RuleExecutionResultsListener.instance((GraphRewrite)event).getRuleExecutionInformation((AbstractRuleProvider)ruleProvider);
                    for (RuleExecutionInformation ruleInfo : ruleProviderInfo) {
                        if (ruleInfo == null) continue;
                        RuleExecutionModel ruleExecutionModel = (RuleExecutionModel)this.ruleExecutionService.create();
                        ruleExecutionModel.setDataFromRuleInfo((RuleExecutionInformationForReading)ruleInfo);
                        ruleProviderModel.addRule(ruleExecutionModel);
                    }
                }
                this.graphContext.commit();
            }

            private void addPhase(String name) {
                if (!this.phaseModelMap.containsKey(name)) {
                    ExecutionPhaseModel phaseModel = (ExecutionPhaseModel)this.executionPhaseService.create();
                    phaseModel.setName(name);
                    this.phaseModelMap.put(name, phaseModel);
                }
            }

            private ExecutionPhaseModel getPhaseModel(RuleProvider ruleProvider) {
                ExecutionPhaseModel phaseModel;
                Class phase = ruleProvider.getMetadata().getPhase();
                String name = phase.getSimpleName();
                if (!this.phaseModelMap.containsKey(name)) {
                    phaseModel = (ExecutionPhaseModel)this.executionPhaseService.create();
                    phaseModel.setName(name);
                    this.phaseModelMap.put(name, phaseModel);
                }
                phaseModel = this.phaseModelMap.get(name);
                return phaseModel;
            }

            public String toString() {
                return "AddRuleReports";
            }
        };
        return ConfigurationBuilder.begin().addRule().perform((Operation)addRuleReports);
    }
}

