/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.renderer.graphlib;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.jboss.windup.reporting.renderer.GraphWriter;
import org.jboss.windup.reporting.renderer.graphlib.GraphlibWriter;
import org.jboss.windup.reporting.renderer.graphlib.GraphvizConstants;
import org.jboss.windup.util.Logging;
import org.joox.JOOX;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DagreD3JSHtmlWriter
implements GraphWriter {
    private static final Logger LOG = Logging.get(DagreD3JSHtmlWriter.class);
    private final GraphlibWriter writer;

    public DagreD3JSHtmlWriter(Graph graph, String vertexLabelProperty, String edgeLabelProperty) {
        this.writer = new GraphlibWriter(graph, GraphvizConstants.GraphvizType.DIGRAPH, GraphvizConstants.GraphvizDirection.TOP_TO_BOTTOM, "g", vertexLabelProperty, edgeLabelProperty);
    }

    @Override
    public void writeGraph(Path outputDirectory) throws IOException {
        try (FileOutputStream os = new FileOutputStream(outputDirectory.resolve("index.html").toFile());){
            this.writeGraph(os);
        }
    }

    private void writeGraph(OutputStream os) throws IOException {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("dagred3/HtmlTemplate.html");){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writer.writeGraph(baos);
            String result = baos.toString();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Graphlib: " + result);
            }
            try {
                Document document = JOOX.$((InputStream)is).document();
                JOOX.$((Document)document).find("#graphlib-source").append(result);
                this.writeDocument(document, os);
            }
            catch (SAXException e) {
                throw new IOException("Exception loading document.", e);
            }
        }
    }

    public void writeDocument(Document document, OutputStream os) throws IOException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException("Exception writing to output stream.", e);
        }
    }
}

