/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;

public class Sha1HexMethod
implements WindupFreeMarkerMethod {
    public String exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (FileModel)");
        }
        StringModel stringModel = (StringModel)arguments.get(0);
        FileModel fileModel = (FileModel)stringModel.getWrappedObject();
        return !fileModel.isDirectory() ? fileModel.getSHA1Hash() : DigestUtils.sha1Hex((String)fileModel.getFileName());
    }

    public String getMethodName() {
        return "sha1Hex";
    }

    public String getDescription() {
        return "Returns the SHA1 Hex hash for the provided " + FileModel.class.getSimpleName() + ".";
    }

    public void setContext(GraphRewrite event) {
    }
}

