/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.virtual;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import org.xadisk.bridge.proxies.interfaces.XAFileOutputStream;
import org.xadisk.filesystem.Buffer;
import org.xadisk.filesystem.NativeSession;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.TransactionInformation;
import org.xadisk.filesystem.TransactionLogEntry;
import org.xadisk.filesystem.exceptions.ClosedStreamException;
import org.xadisk.filesystem.exceptions.NoTransactionAssociatedException;
import org.xadisk.filesystem.virtual.VirtualViewFile;
import org.xadisk.filesystem.workers.GatheringDiskWriter;

public class NativeXAFileOutputStream
implements XAFileOutputStream {
    private final String destination;
    private ByteBuffer byteBuffer;
    private Buffer buffer;
    private final NativeXAFileSystem xaFileSystem;
    private final TransactionInformation xid;
    private final GatheringDiskWriter theGatheringDiskWriter;
    private long filePosition;
    private boolean closed = false;
    private final VirtualViewFile vvf;
    private final boolean heavyWrite;
    private final NativeSession owningSession;
    private final ReentrantLock asynchronousRollbackLock;

    public NativeXAFileOutputStream(VirtualViewFile vvf, TransactionInformation xid, boolean heavyWrite, NativeSession owningSession, NativeXAFileSystem xaFileSystem) {
        this.xaFileSystem = xaFileSystem;
        this.destination = vvf.getFileName().getAbsolutePath();
        this.xid = xid;
        this.theGatheringDiskWriter = this.xaFileSystem.getTheGatheringDiskWriter();
        this.vvf = vvf;
        this.filePosition = vvf.getLength();
        vvf.setBeingWritten(true);
        if (heavyWrite && !vvf.isUsingHeavyWriteOptimization()) {
            try {
                vvf.setUpForHeavyWriteOptimization();
            }
            catch (IOException ioe) {
                xaFileSystem.notifySystemFailure(ioe);
            }
        }
        this.heavyWrite = vvf.isUsingHeavyWriteOptimization();
        this.allocateByteBuffer();
        this.setUpNewBuffer();
        this.owningSession = owningSession;
        this.asynchronousRollbackLock = owningSession.getAsynchronousRollbackLock();
    }

    public void write(byte[] b) throws ClosedStreamException, NoTransactionAssociatedException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws ClosedStreamException, NoTransactionAssociatedException {
        byte[] b1 = new byte[]{(byte)b};
        this.write(b1, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws ClosedStreamException, NoTransactionAssociatedException {
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            int len1 = len;
            if (this.byteBuffer.remaining() < len) {
                len1 = this.byteBuffer.remaining();
            }
            this.byteBuffer.put(b, off, len1);
            this.filePosition += (long)len1;
            if (this.byteBuffer.remaining() == 0) {
                this.submitBuffer();
                this.setUpNewBuffer();
            }
            if (len1 < len) {
                this.write(b, off + len1, len - len1);
            }
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws ClosedStreamException, NoTransactionAssociatedException {
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            this.submitBuffer();
            this.setUpNewBuffer();
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws NoTransactionAssociatedException {
        if (this.closed) {
            return;
        }
        try {
            this.asynchronousRollbackLock.lock();
            this.owningSession.checkIfCanContinue();
            this.submitBuffer();
            this.vvf.setBeingWritten(false);
            this.closed = true;
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    private void allocateByteBuffer() {
        this.buffer = this.xaFileSystem.getBufferPool().checkOut();
        if (this.buffer != null) {
            this.byteBuffer = this.buffer.getBuffer();
        } else {
            this.buffer = new Buffer(this.xaFileSystem.getConfiguredBufferSize(), false, this.xaFileSystem);
            this.byteBuffer = this.buffer.getBuffer();
        }
        this.byteBuffer.clear();
    }

    private void setUpNewBuffer() {
        if (this.heavyWrite) {
            this.byteBuffer.clear();
        } else {
            this.allocateByteBuffer();
            byte[] temp = TransactionLogEntry.getLogEntry(this.xid, this.destination, this.filePosition, 21, (byte)2);
            this.byteBuffer.put(temp);
            this.buffer.setFileContentPosition(this.filePosition);
            this.buffer.setHeaderLength(temp.length);
        }
    }

    private void submitBuffer() {
        try {
            if (this.heavyWrite) {
                this.byteBuffer.flip();
                this.vvf.appendContentBuffer(this.buffer);
            } else {
                int contentLength = this.byteBuffer.position() - this.buffer.getHeaderLength();
                TransactionLogEntry.updateContentLength(this.byteBuffer, contentLength);
                this.buffer.setFileContentLength(contentLength);
                this.byteBuffer.flip();
                this.vvf.appendContentBuffer(this.buffer);
                this.theGatheringDiskWriter.submitBuffer(this.buffer, this.xid);
            }
        }
        catch (IOException ioe) {
            this.xaFileSystem.notifySystemFailure(ioe);
        }
    }

    public File getDestinationFile() {
        return new File(this.destination);
    }

    private void checkIfCanContinue() throws NoTransactionAssociatedException, ClosedStreamException {
        this.owningSession.checkIfCanContinue();
    }

    public boolean isClosed() {
        return this.closed;
    }
}

