/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.OnDiskInfo;
import org.xadisk.filesystem.pools.PooledBuffer;

public class Buffer {
    protected ByteBuffer buffer;
    private final boolean hasItsOwnBytes;
    public final boolean isDirect;
    private volatile OnDiskInfo onDiskInfo = null;
    private long fileContentPosition;
    private int fileContentLength;
    private int headerLength;
    private FileChannel logFileChannel;
    private int logChannelIndex = -1;
    private final NativeXAFileSystem xaFileSystem;
    private volatile boolean memorySynchTrigger = true;

    public Buffer(int bufferSize, boolean isDirect, NativeXAFileSystem xaFileSystem) {
        this.xaFileSystem = xaFileSystem;
        this.buffer = isDirect ? ByteBuffer.allocateDirect(bufferSize) : ByteBuffer.allocate(bufferSize);
        this.hasItsOwnBytes = true;
        this.isDirect = isDirect;
        if (!(this instanceof PooledBuffer)) {
            xaFileSystem.changeTotalNonPooledBufferSize(bufferSize);
        }
    }

    public Buffer(ByteBuffer buffer, NativeXAFileSystem xaFileSystem) {
        this.xaFileSystem = xaFileSystem;
        this.buffer = buffer;
        this.isDirect = false;
        this.hasItsOwnBytes = true;
        if (!(this instanceof PooledBuffer)) {
            xaFileSystem.changeTotalNonPooledBufferSize(buffer.capacity());
        }
    }

    public Buffer(NativeXAFileSystem xaFileSystem) {
        this.xaFileSystem = xaFileSystem;
        this.hasItsOwnBytes = false;
        this.isDirect = false;
    }

    public void flushByteBufferChanges() {
        this.memorySynchTrigger = true;
    }

    public void invalidateByteBufferFromCache() {
        boolean dummyRead = this.memorySynchTrigger;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    boolean isDirect() {
        return this.isDirect;
    }

    public void makeOnDisk(OnDiskInfo onDiskInfo) {
        if (onDiskInfo == null) {
            return;
        }
        this.onDiskInfo = onDiskInfo;
        if (!(this instanceof PooledBuffer)) {
            if (this.hasItsOwnBytes) {
                this.xaFileSystem.changeTotalNonPooledBufferSize(-this.buffer.capacity());
            }
            this.buffer = null;
        }
    }

    public void setOnDiskInfo(OnDiskInfo onDiskInfo) {
        this.onDiskInfo = onDiskInfo;
    }

    protected void finalize() throws Throwable {
        if (!(this instanceof PooledBuffer) && this.buffer != null && this.hasItsOwnBytes) {
            this.xaFileSystem.changeTotalNonPooledBufferSize(-this.buffer.capacity());
        }
    }

    public OnDiskInfo getOnDiskInfo() {
        return this.onDiskInfo;
    }

    public int getFileContentLength() {
        return this.fileContentLength;
    }

    public void setFileContentLength(int fileContentLength) {
        this.fileContentLength = fileContentLength;
    }

    public long getFileContentPosition() {
        return this.fileContentPosition;
    }

    public void setFileContentPosition(long fileContentPosition) {
        this.fileContentPosition = fileContentPosition;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public void setHeaderLength(int headerLength) {
        this.headerLength = headerLength;
    }

    public Buffer createReadOnlyClone() {
        Buffer clone = new Buffer(this.xaFileSystem);
        ByteBuffer referenceToByteBuffer = this.buffer;
        if (referenceToByteBuffer == null) {
            clone.onDiskInfo = this.onDiskInfo;
        } else {
            clone.buffer = referenceToByteBuffer.asReadOnlyBuffer();
        }
        clone.setFileContentLength(this.fileContentLength);
        clone.setFileContentPosition(this.fileContentPosition);
        clone.setHeaderLength(this.headerLength);
        return clone;
    }

    public int regenerateContentFromDisk(ByteBuffer target, int offsetToReadFrom) throws IOException {
        int logIndex = this.onDiskInfo.getLogIndex();
        if (this.logChannelIndex != logIndex) {
            if (this.logFileChannel != null) {
                this.logFileChannel.close();
            }
            FileInputStream logIS = new FileInputStream(this.xaFileSystem.getTransactionLogFileBaseName() + "_" + logIndex);
            this.logFileChannel = logIS.getChannel();
            this.logChannelIndex = logIndex;
        }
        this.logFileChannel.position(this.onDiskInfo.getLocation() + (long)this.headerLength + (long)offsetToReadFrom);
        target.limit(this.fileContentLength - offsetToReadFrom);
        int numRead = 0;
        while (numRead == 0) {
            numRead = this.logFileChannel.read(target);
        }
        target.flip();
        return numRead;
    }
}

