/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.connector.outbound;

import java.io.PrintWriter;
import java.util.HashSet;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import org.xadisk.bridge.proxies.interfaces.XAFileSystem;
import org.xadisk.connector.outbound.XADiskConnection;
import org.xadisk.connector.outbound.XADiskConnectionImpl;
import org.xadisk.connector.outbound.XADiskLocalTransaction;
import org.xadisk.connector.outbound.XADiskManagedConnectionMetaData;
import org.xadisk.filesystem.NativeXASession;

public class XADiskManagedConnection
extends NativeXASession
implements ManagedConnection {
    private final HashSet<ConnectionEventListener> listeners = new HashSet(10);
    private volatile PrintWriter logWriter;
    private final HashSet<XADiskConnection> connectionHandles = new HashSet(2);
    private volatile boolean memorySynchTrigger = false;
    private volatile XADiskLocalTransaction localTransactionImpl = new XADiskLocalTransaction(this);

    public XADiskManagedConnection(XAFileSystem xaFileSystem, String instanceId) {
        super(xaFileSystem, instanceId);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localTransactionImpl;
    }

    public void cleanup() throws ResourceException {
        super.cleanup();
        this.localTransactionImpl = new XADiskLocalTransaction(this);
        this.connectionHandles.clear();
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (!(connection instanceof XADiskConnection)) {
            throw new ResourceException("Unexpected type for connection handle.");
        }
        ((XADiskConnectionImpl)connection).setManagedConnection(this);
        this.invalidateCache();
        this.connectionHandles.add((XADiskConnection)connection);
        this.flushCacheToMainMemory();
    }

    public void destroy() throws ResourceException {
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        XADiskConnectionImpl temp = new XADiskConnectionImpl(this);
        this.invalidateCache();
        this.connectionHandles.add(temp);
        this.flushCacheToMainMemory();
        return temp;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new XADiskManagedConnectionMetaData();
    }

    public void addConnectionEventListener(ConnectionEventListener cel) {
        this.invalidateCache();
        this.listeners.add(cel);
        this.flushCacheToMainMemory();
    }

    public void removeConnectionEventListener(ConnectionEventListener cel) {
        this.invalidateCache();
        this.listeners.remove(cel);
        this.flushCacheToMainMemory();
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.logWriter = logWriter;
    }

    void connectionClosed(XADiskConnection connection) {
        this.connectionHandles.remove(connection);
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 1);
        connectionEvent.setConnectionHandle((Object)connection);
        this.raiseConnectionEvent(connectionEvent);
    }

    private void raiseConnectionEvent(ConnectionEvent ce) {
        this.invalidateCache();
        for (ConnectionEventListener cel : this.listeners) {
            switch (ce.getId()) {
                case 1: {
                    cel.connectionClosed(ce);
                    break;
                }
                case 5: {
                    cel.connectionErrorOccurred(ce);
                    break;
                }
                case 2: {
                    cel.localTransactionStarted(ce);
                    break;
                }
                case 3: {
                    cel.localTransactionCommitted(ce);
                    break;
                }
                case 4: {
                    cel.localTransactionRolledback(ce);
                }
            }
        }
    }

    void raiseUserLocalTransactionEvent(int transactionalEvent) {
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, transactionalEvent);
        this.raiseConnectionEvent(ce);
    }

    private void flushCacheToMainMemory() {
        this.memorySynchTrigger = true;
    }

    private void invalidateCache() {
        boolean temp = this.memorySynchTrigger;
    }
}

