/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.connector.inbound;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.xadisk.filesystem.FileSystemStateChangeEvent;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.TransactionInformation;
import org.xadisk.filesystem.TransactionLogEntry;
import org.xadisk.filesystem.utilities.MiscUtils;

public class LocalEventProcessingXAResource
implements XAResource {
    private final ConcurrentHashMap<Xid, TransactionInformation> internalXids = new ConcurrentHashMap(1000);
    private final Object lockOnInternalXids = new ArrayList(0);
    private final NativeXAFileSystem xaFileSystem;
    private final FileSystemStateChangeEvent event;
    private volatile boolean returnedAllPreparedTransactions = false;
    private final boolean isCreatedForRecovery;
    private volatile HashMap<TransactionInformation, FileSystemStateChangeEvent> dequeuingTransactionsPreparedPreCrash;
    private byte transactionOutcome = (byte)6;

    public LocalEventProcessingXAResource(NativeXAFileSystem xaFileSystem, FileSystemStateChangeEvent event) {
        this.xaFileSystem = xaFileSystem;
        this.event = event;
        this.isCreatedForRecovery = false;
    }

    public LocalEventProcessingXAResource(NativeXAFileSystem xaFileSystem) {
        this.xaFileSystem = xaFileSystem;
        this.isCreatedForRecovery = true;
        this.event = null;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (flags == 0) {
            // empty if block
        }
    }

    public void end(Xid xid, int flags) throws XAException {
    }

    public int prepare(Xid xid) throws XAException {
        TransactionInformation xidImpl = this.mapToInternalXid(xid);
        if (this.isCreatedForRecovery) {
            // empty if block
        }
        try {
            this.xaFileSystem.getTheGatheringDiskWriter().transactionPrepareCompletesForEventDequeue(xidImpl, this.event);
        }
        catch (IOException ioe) {
            this.xaFileSystem.notifySystemFailureAndContinue(ioe);
            throw MiscUtils.createXAExceptionWithCause(-7, ioe);
        }
        return 0;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        TransactionInformation xidImpl = this.mapToInternalXid(xid);
        FileSystemStateChangeEvent eventForTransaction = null;
        try {
            eventForTransaction = this.isCreatedForRecovery ? this.dequeuingTransactionsPreparedPreCrash.get(xidImpl) : this.event;
            ArrayList<FileSystemStateChangeEvent> events = new ArrayList<FileSystemStateChangeEvent>(1);
            events.add(eventForTransaction);
            ByteBuffer logEntryBytes = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(xidImpl, events, (byte)19));
            this.xaFileSystem.getTheGatheringDiskWriter().forceLog(logEntryBytes);
            this.xaFileSystem.getTheGatheringDiskWriter().transactionCompletes(xidImpl, true);
            if (this.isCreatedForRecovery) {
                this.xaFileSystem.getRecoveryWorker().cleanupTransactionInfo(xidImpl);
            }
            this.transactionOutcome = (byte)3;
        }
        catch (IOException ioe) {
            this.xaFileSystem.notifySystemFailureAndContinue(ioe);
            throw MiscUtils.createXAExceptionWithCause(-7, ioe);
        }
        finally {
            this.releaseFromInternalXidMap(xid);
        }
    }

    public void rollback(Xid xid) throws XAException {
        TransactionInformation xidImpl = this.mapToInternalXid(xid);
        try {
            this.xaFileSystem.getTheGatheringDiskWriter().transactionCompletes(xidImpl, false);
            if (this.isCreatedForRecovery) {
                this.xaFileSystem.getRecoveryWorker().cleanupTransactionInfo(xidImpl);
            }
            this.transactionOutcome = (byte)4;
        }
        catch (IOException ioe) {
            this.xaFileSystem.notifySystemFailureAndContinue(ioe);
            throw MiscUtils.createXAExceptionWithCause(-7, ioe);
        }
        finally {
            this.releaseFromInternalXidMap(xid);
        }
    }

    public void forget(Xid xid) throws XAException {
    }

    public Xid[] recover(int flag) throws XAException {
        if (flag == 0x1000000) {
            this.returnedAllPreparedTransactions = false;
        }
        if (flag == 0x1800000) {
            this.returnedAllPreparedTransactions = false;
        }
        if (this.returnedAllPreparedTransactions) {
            return new Xid[0];
        }
        this.dequeuingTransactionsPreparedPreCrash = this.xaFileSystem.getRecoveryWorker().getPreparedInDoubtTransactionsOfDequeue();
        Set<TransactionInformation> xidsSet = this.dequeuingTransactionsPreparedPreCrash.keySet();
        Xid[] xids = xidsSet.toArray(new Xid[0]);
        this.returnedAllPreparedTransactions = true;
        return xids;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean setTransactionTimeout(int arg0) throws XAException {
        return false;
    }

    public boolean isSameRM(XAResource obj) throws XAException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionInformation mapToInternalXid(Xid xid) {
        Object object = this.lockOnInternalXids;
        synchronized (object) {
            TransactionInformation internalXid = this.internalXids.get(xid);
            if (internalXid == null) {
                internalXid = new TransactionInformation(xid);
                this.internalXids.put(xid, internalXid);
            }
            return internalXid;
        }
    }

    private void releaseFromInternalXidMap(Xid xid) {
        this.internalXids.remove(xid);
    }

    public byte getTransactionOutcome() {
        return this.transactionOutcome;
    }
}

