/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.additional;

import java.io.IOException;
import java.io.InputStream;
import org.xadisk.additional.Utilities;
import org.xadisk.bridge.proxies.interfaces.XAFileInputStream;
import org.xadisk.filesystem.exceptions.XAApplicationException;

public class XAFileInputStreamWrapper
extends InputStream {
    private XAFileInputStream xis;
    private long latestMarkPoint = -1L;

    public XAFileInputStreamWrapper(XAFileInputStream xis) {
        this.xis = xis;
    }

    public int available() throws IOException {
        try {
            return this.xis.available();
        }
        catch (XAApplicationException e) {
            throw Utilities.wrapWithIOException(e);
        }
    }

    public void close() throws IOException {
        try {
            this.xis.close();
        }
        catch (XAApplicationException e) {
            throw Utilities.wrapWithIOException(e);
        }
    }

    public synchronized void mark(int readlimit) {
        this.latestMarkPoint = this.xis.position();
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        try {
            return this.xis.read();
        }
        catch (XAApplicationException e) {
            throw Utilities.wrapWithIOException(e);
        }
    }

    public int read(byte[] b) throws IOException {
        try {
            return this.xis.read(b);
        }
        catch (XAApplicationException e) {
            throw Utilities.wrapWithIOException(e);
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.xis.read(b, off, len);
        }
        catch (XAApplicationException e) {
            throw Utilities.wrapWithIOException(e);
        }
    }

    public synchronized void reset() throws IOException {
        if (this.latestMarkPoint == -1L) {
            throw new IOException("No corresponding mark does exist.");
        }
        try {
            this.xis.position(this.latestMarkPoint);
            this.latestMarkPoint = -1L;
        }
        catch (XAApplicationException e) {
            throw Utilities.wrapWithIOException(e);
        }
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        try {
            return this.xis.skip(n);
        }
        catch (XAApplicationException e) {
            throw Utilities.wrapWithIOException(e);
        }
    }
}

