/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassWriter;

public final class ExceptionsWriter
extends ClassWriter.Element {
    private final int attrID;
    private int[] table;

    public ExceptionsWriter(ClassWriter w) {
        if (w == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.attrID = w.addCPUtf8("Exceptions");
    }

    @Override
    public int getSize() {
        return this.table == null ? 8 : 8 + this.table.length * 2;
    }

    @Override
    public int copyInto(byte[] buf, int offset) throws IllegalArgumentException {
        ClassWriter.setUShort(buf, offset, this.attrID);
        ClassWriter.setInt(buf, offset + 2, this.getSize() - 6);
        ClassWriter.setUShort(buf, offset + 6, this.table == null ? 0 : this.table.length);
        offset += 8;
        if (this.table != null) {
            for (int element : this.table) {
                ClassWriter.setUShort(buf, offset, element);
                offset += 2;
            }
        }
        return offset;
    }

    public void setRawTable(int[] exceptions) {
        if (exceptions == null) {
            throw new IllegalArgumentException("exceptions is null");
        }
        for (int exception : exceptions) {
            if (exception >= 1 && exception <= 65535) continue;
            throw new IllegalArgumentException("Invalid CP index: " + exception);
        }
        this.table = exceptions;
    }
}

