/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.info;

import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.StoreInstruction;

public class ThisAssignmentChecker
implements MethodData.Results {
    private static final String key = ThisAssignmentChecker.class.getName();
    private boolean assignmentToThis;

    ThisAssignmentChecker(MethodData info) {
        this.recalculateFrom(info);
    }

    private void recalculateFrom(MethodData info) {
        this.assignmentToThis = false;
        if (!info.getIsStatic()) {
            IInstruction[] instructions;
            for (IInstruction instr : instructions = info.getInstructions()) {
                StoreInstruction st;
                if (!(instr instanceof StoreInstruction) || (st = (StoreInstruction)instr).getVarIndex() != 0) continue;
                this.assignmentToThis = true;
            }
        }
    }

    @Override
    public boolean notifyUpdate(MethodData info, IInstruction[] newInstructions, ExceptionHandler[][] newHandlers, int[] newInstructionMap) {
        return true;
    }

    public static boolean isThisAssigned(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        ThisAssignmentChecker c = (ThisAssignmentChecker)info.getInfo(key);
        if (c == null) {
            c = new ThisAssignmentChecker(info);
            info.putInfo(key, c);
        }
        return c.assignmentToThis;
    }
}

