/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.project.handlers;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.graph.model.DependencyLocation;
import org.jboss.windup.project.condition.Artifact;
import org.jboss.windup.rules.apps.java.condition.Version;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="artifact", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class ArtifactHandler
implements ElementHandler<Artifact> {
    public Artifact processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String groupId = JOOX.$((Element)element).attr("groupId");
        String artifactId = JOOX.$((Element)element).attr("artifactId");
        String from = JOOX.$((Element)element).attr("fromVersion");
        String to = JOOX.$((Element)element).attr("toVersion");
        List locationElements = JOOX.$((Element)element).children().get();
        Collection locations = null;
        if (locationElements != null && !locationElements.isEmpty()) {
            locations = locationElements.stream().map(child -> DependencyLocation.valueOf((String)child.getTextContent())).collect(Collectors.toSet());
        }
        return Artifact.withGroupId(groupId).andArtifactId(artifactId).andVersion(Version.fromVersion((String)from).to(to)).andLocations(locations);
    }
}

