/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import java.util.ArrayList;
import java.util.List;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.DefaultInputBuffer;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.ParseError;
import org.parboiled.matchers.Matcher;
import org.parboiled.parserunners.ParseRunner;
import org.parboiled.support.DefaultValueStack;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.ValueStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParseRunner<V>
implements ParseRunner<V> {
    private final Matcher rootMatcher;
    private List<ParseError> parseErrors;
    private ValueStack<V> valueStack;
    private Object initialValueStackSnapshot;

    public AbstractParseRunner(Rule rule) {
        this.rootMatcher = Preconditions.checkArgNotNull((Matcher)rule, "rule");
    }

    public Matcher getRootMatcher() {
        return this.rootMatcher;
    }

    @Override
    public ParseRunner<V> withParseErrors(List<ParseError> list) {
        this.parseErrors = list;
        return this;
    }

    public List<ParseError> getParseErrors() {
        if (this.parseErrors == null) {
            this.withParseErrors(new ArrayList<ParseError>());
        }
        return this.parseErrors;
    }

    @Override
    public ParseRunner<V> withValueStack(ValueStack<V> valueStack) {
        this.valueStack = Preconditions.checkArgNotNull(valueStack, "valueStack");
        this.initialValueStackSnapshot = valueStack.takeSnapshot();
        return this;
    }

    public ValueStack<V> getValueStack() {
        if (this.valueStack == null) {
            this.withValueStack(new DefaultValueStack());
        }
        return this.valueStack;
    }

    @Override
    public ParsingResult<V> run(String string) {
        Preconditions.checkArgNotNull(string, "input");
        return this.run(string.toCharArray());
    }

    @Override
    public ParsingResult<V> run(char[] cArray) {
        Preconditions.checkArgNotNull(cArray, "input");
        return this.run(new DefaultInputBuffer(cArray));
    }

    protected void resetValueStack() {
        this.getValueStack().restoreSnapshot(this.initialValueStackSnapshot);
    }

    protected MatcherContext<V> createRootContext(InputBuffer inputBuffer, MatchHandler matchHandler, boolean bl) {
        return new MatcherContext<V>(inputBuffer, this.getValueStack(), this.getParseErrors(), matchHandler, this.rootMatcher, bl);
    }

    protected ParsingResult<V> createParsingResult(boolean bl, MatcherContext<V> matcherContext) {
        return new ParsingResult<V>(bl, matcherContext.getNode(), this.getValueStack(), this.getParseErrors(), matcherContext.getInputBuffer());
    }
}

