/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource.monitor;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.addon.resource.monitor.ResourceMonitorImpl;

class FileWatcher
implements Runnable {
    private static Logger log = Logger.getLogger(FileWatcher.class.getName());
    private final WatchService watcher;
    private final Map<WatchKey, ResourceMonitorImpl> keys = new ConcurrentHashMap<WatchKey, ResourceMonitorImpl>();
    private Thread resourceMonitorThread;
    private volatile boolean alive = true;

    public FileWatcher() throws IOException {
        this.watcher = FileSystems.getDefault().newWatchService();
    }

    public void start() throws IllegalStateException {
        if (!this.alive) {
            throw new IllegalStateException("FileWatcher already stopped");
        }
        this.resourceMonitorThread = new Thread((Runnable)this, "Resource File Monitor");
        this.resourceMonitorThread.setDaemon(true);
        this.resourceMonitorThread.setContextClassLoader(null);
        this.resourceMonitorThread.start();
    }

    public void stop() {
        this.alive = false;
        this.resourceMonitorThread.interrupt();
        try {
            this.watcher.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error while closing FileWatcher", e);
        }
    }

    void register(ResourceMonitorImpl monitorImpl) throws IOException {
        Path path = monitorImpl.getResourcePath();
        this.registerAll(path, monitorImpl);
    }

    void unregister(ResourceMonitorImpl monitorImpl) {
        Set<Map.Entry<WatchKey, ResourceMonitorImpl>> entrySet = this.keys.entrySet();
        Iterator<Map.Entry<WatchKey, ResourceMonitorImpl>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<WatchKey, ResourceMonitorImpl> next = iterator.next();
            if (next.getValue() != monitorImpl) continue;
            next.getKey().cancel();
            iterator.remove();
        }
    }

    private void register(Path path, ResourceMonitorImpl monitorImpl) throws IOException {
        WatchKey key = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keys.put(key, monitorImpl);
    }

    private void registerAll(Path start, final ResourceMonitorImpl monitorImpl) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileWatcher.this.register(dir, monitorImpl);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public void run() {
        while (this.alive) {
            WatchKey key;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                break;
            }
            List<WatchEvent<?>> pollEvents = key.pollEvents();
            for (WatchEvent<?> event : pollEvents) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent<?> ev = event;
                Path name = (Path)ev.context();
                ResourceMonitorImpl resourceMonitor = this.keys.get(key);
                if (resourceMonitor == null) {
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("WatchKey not recognized " + name + " - " + key.watchable() + "> " + kind);
                    continue;
                }
                Path resourcePath = resourceMonitor.getResourcePath();
                Path child = resourcePath.resolve(name);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("%s: %s %s %s\n", event.kind().name(), child, key, this.keys.keySet()));
                }
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    try {
                        if (Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                            this.registerAll(child, resourceMonitor);
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Error while registering child directories", e);
                    }
                    resourceMonitor.onPathCreate(child);
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                    resourceMonitor.onPathDelete(child);
                    continue;
                }
                if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                resourceMonitor.onPathModify(child);
            }
            if (!this.keys.containsKey(key)) {
                key.cancel();
                continue;
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keys.remove(key);
        }
    }
}

