/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource;

import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.ResourceGenerator;
import org.jboss.forge.addon.resource.URLResource;
import org.jboss.forge.addon.resource.URLResourceImpl;
import org.jboss.forge.furnace.util.Strings;

public class URLResourceGenerator
implements ResourceGenerator<URLResource, Object> {
    public boolean handles(Class<?> type, Object resource) {
        boolean result = resource == null ? false : (resource instanceof URL ? true : Strings.isURL((String)resource.toString()));
        return result;
    }

    public <T extends Resource<Object>> T getResource(ResourceFactory factory, Class<URLResource> type, Object resource) {
        URL url = null;
        if (resource instanceof URL) {
            url = (URL)resource;
        } else if (Strings.isURL((String)resource.toString())) {
            try {
                url = new URL(resource.toString());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid URL found", e);
            }
        }
        URLResourceImpl createdResource = new URLResourceImpl(factory, url);
        return (T)((Object)createdResource);
    }

    public <T extends Resource<Object>> Class<?> getResourceType(ResourceFactory factory, Class<URLResource> type, Object resource) {
        return type;
    }
}

