/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.files;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphListener;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.files.FileMapping;

public class FileMappingGraphChangedListener
implements GraphListener {
    private static final Logger LOG = Logger.getLogger(FileMappingGraphChangedListener.class.getName());
    private final GraphRewrite event;

    public FileMappingGraphChangedListener(GraphRewrite event) {
        this.event = event;
    }

    public void vertexPropertyChanged(Vertex element, Property oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
        String key = oldValue.key();
        if (!"filePath".equals(key)) {
            return;
        }
        FileService fileService = new FileService(this.event.getGraphContext());
        element = (Vertex)this.event.getGraphContext().getGraph().vertices(new Object[]{element.id()}).next();
        FileModel model = (FileModel)fileService.frame(element);
        if (model.isDirectory()) {
            return;
        }
        Map mappings = FileMapping.getMappings((GraphRewrite)this.event);
        for (Map.Entry entry : mappings.entrySet()) {
            String pattern = (String)entry.getKey();
            List types = (List)entry.getValue();
            if (!((String)setValue).matches(pattern)) continue;
            for (Class type : types) {
                GraphService.addTypeToModel((GraphContext)this.event.getGraphContext(), (WindupVertexFrame)model, (Class)type);
            }
            LOG.fine("Mapped file [" + model.getFilePath() + "] matching pattern [" + pattern + "] to the following [" + types.size() + "] types: " + types);
        }
    }

    public void vertexAdded(Vertex vertex) {
    }
}

