/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.maven.nexusindexer.client;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Bits;
import org.jboss.windup.maven.nexusindexer.ZipUtil;
import org.jboss.windup.maven.nexusindexer.client.DocTo;

public class LuceneIndexServiceBase
implements Closeable {
    private static final Logger LOG = Logger.getLogger(LuceneIndexServiceBase.class.getName());
    protected File directory;
    protected Directory index;
    protected IndexReader reader;
    protected IndexSearcher searcher;

    public LuceneIndexServiceBase(File directory) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Directory does not exist: " + directory);
        }
        this.directory = directory;
        try {
            this.initialize();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load Lucene index due to: " + e.getMessage(), e);
        }
    }

    private void initialize() throws IOException {
        this.index = new SimpleFSDirectory(this.directory.toPath());
        this.reader = DirectoryReader.open((Directory)this.index);
        this.searcher = new IndexSearcher(this.reader);
    }

    @Override
    public final void close() {
        try {
            this.reader.close();
            this.index.close();
        }
        catch (Exception e) {
            LOG.warning("Failed to close Lucene index in: " + this.directory + " due to: " + e.getMessage());
        }
    }

    public int visitAllDocuments(ZipUtil.Visitor<Document> visitor) {
        int count = 0;
        IndexReader reader = this.searcher.getIndexReader();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        for (int i = 0; i < reader.maxDoc(); ++i) {
            if (liveDocs != null && !liveDocs.get(i)) continue;
            try {
                Document doc = reader.document(i);
                visitor.visit((Object)doc);
                ++count;
                continue;
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Error reading Lucene document #" + i + ": " + ex.getMessage(), ex);
            }
        }
        return count;
    }

    public void findByField(String fieldName, String value, int maxHits, ZipUtil.Visitor<Document> visitor) {
        TermQuery query = new TermQuery(new Term(fieldName, value));
        try {
            TopDocs results = this.getSearcher().search((Query)query, maxHits);
            for (ScoreDoc scoreDoc : results.scoreDocs) {
                Document doc = this.getSearcher().doc(scoreDoc.doc);
                visitor.visit((Object)doc);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error finding document with: " + fieldName + " == " + value + "\n    Visitor used: " + visitor + "\n    " + ex.getMessage(), ex);
        }
    }

    public <T> T findSingle(String fieldName, String value, DocTo<T> converter) {
        TermQuery query = new TermQuery(new Term(fieldName, value));
        try {
            TopDocs results = this.getSearcher().search((Query)query, 1);
            ScoreDoc[] scoreDocArray = results.scoreDocs;
            int n = scoreDocArray.length;
            int n2 = 0;
            if (n2 < n) {
                ScoreDoc scoreDoc = scoreDocArray[n2];
                Document doc = this.getSearcher().doc(scoreDoc.doc);
                return converter.convert(doc);
            }
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException("Error finding single document with: " + fieldName + " == " + value + "\n    " + ex.getMessage(), ex);
        }
    }

    public final IndexSearcher getSearcher() {
        return this.searcher;
    }

    public final File getDirectory() {
        return this.directory;
    }
}

