/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.loader.OverrideRule;
import org.jboss.windup.config.loader.RuleKey;
import org.jboss.windup.config.loader.RuleLoader;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.loader.RuleProviderLoader;
import org.jboss.windup.config.loader.RuleProviderSorter;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.util.ServiceLogger;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionVisit;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationVisit;
import org.ocpsoft.rewrite.config.ParameterizedCallback;
import org.ocpsoft.rewrite.config.ParameterizedConditionVisitor;
import org.ocpsoft.rewrite.config.ParameterizedOperationVisitor;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleBuilder;
import org.ocpsoft.rewrite.param.ConfigurableParameter;
import org.ocpsoft.rewrite.param.DefaultParameter;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedRule;
import org.ocpsoft.rewrite.util.Visitor;

public class RuleLoaderImpl
implements RuleLoader {
    public static Logger LOG = Logger.getLogger(RuleLoaderImpl.class.getName());
    @Inject
    private Imported<RuleProviderLoader> loaders;

    public RuleProviderRegistry loadConfiguration(RuleLoaderContext ruleLoaderContext) {
        return this.buildRegistry(ruleLoaderContext);
    }

    private RuleProviderRegistry buildRegistry(RuleLoaderContext ruleLoaderContext) {
        ArrayList<Rule> allRules = new ArrayList<Rule>(2000);
        List<RuleProvider> providers = this.loadProviders(ruleLoaderContext);
        RuleProviderRegistry registry = new RuleProviderRegistry();
        registry.setProviders(providers);
        Map<RuleKey, OverrideRule> overrideRules = this.extractOverrideRules(providers, ruleLoaderContext);
        for (RuleProvider provider : providers) {
            if (ruleLoaderContext.getRuleProviderFilter() != null) {
                boolean accepted = ruleLoaderContext.getRuleProviderFilter().accept((Object)provider);
                LOG.info((accepted ? "Accepted" : "Skipped") + ": [" + provider + "] by filter [" + ruleLoaderContext.getRuleProviderFilter() + "]");
                if (!accepted) continue;
            }
            if (provider.getMetadata().isOverrideProvider()) {
                List<Rule> unusedOverrideRules = provider.getConfiguration(null).getRules().stream().filter(rule -> {
                    OverrideRule overrideRule = (OverrideRule)overrideRules.get(new RuleKey(provider.getMetadata().getID(), rule.getId()));
                    if (overrideRule != null) {
                        return !overrideRule.isUsed();
                    }
                    return false;
                }).collect(Collectors.toList());
                registry.addRulesForProvider(provider, unusedOverrideRules);
                this.enhanceRules(allRules, provider, unusedOverrideRules);
                continue;
            }
            Configuration cfg = provider.getConfiguration(ruleLoaderContext);
            List<Rule> rules = this.overrideRules(cfg, overrideRules, provider);
            registry.addRulesForProvider(provider, rules);
            this.enhanceRules(allRules, provider, rules);
        }
        ConfigurationBuilder result = ConfigurationBuilder.begin();
        for (Rule rule2 : allRules) {
            result.addRule(rule2);
        }
        registry.setConfiguration((Configuration)result);
        return registry;
    }

    private void enhanceRules(List<Rule> allRules, RuleProvider provider, List<Rule> rules) {
        for (int i = 0; i < rules.size(); ++i) {
            Rule rule = rules.get(i);
            AbstractRuleProvider.enhanceRuleMetadata((RuleProvider)provider, (Rule)rule);
            if (rule instanceof RuleBuilder && StringUtils.isBlank((CharSequence)rule.getId())) {
                ((RuleBuilder)rule).withId(this.generatedRuleID(provider, i + 1));
            }
            allRules.add(rule);
            if (!(rule instanceof ParameterizedRule)) continue;
            this.injectParametersIntoRule(rule);
        }
    }

    private List<RuleProvider> loadProviders(RuleLoaderContext ruleLoaderContext) {
        LOG.info("Starting provider load...");
        ArrayList<RuleProvider> unsortedProviders = new ArrayList<RuleProvider>();
        StreamSupport.stream(this.loaders.spliterator(), false).filter(loader -> !ruleLoaderContext.isFileBasedRulesOnly() || loader.isFileBased()).forEach(loader -> unsortedProviders.addAll(loader.getProviders(ruleLoaderContext)));
        LOG.info("Loaded, now sorting, etc");
        this.checkForDuplicateProviders(unsortedProviders);
        this.printRulePhases(unsortedProviders);
        List<RuleProvider> sortedProviders = RuleProviderSorter.sort(unsortedProviders);
        ServiceLogger.logLoadedServices((Logger)LOG, RuleProvider.class, sortedProviders);
        LOG.info("Finished provider load");
        return Collections.unmodifiableList(sortedProviders);
    }

    private void checkForDuplicateProviders(List<RuleProvider> providers) {
        HashMap<RuleProvider, RuleProvider> duplicates = new HashMap<RuleProvider, RuleProvider>(providers.size());
        for (RuleProvider provider : providers) {
            RuleProvider previousProvider = (RuleProvider)duplicates.get(provider);
            if (previousProvider != null) {
                String currentProviderOrigin = provider.getMetadata().getOrigin();
                String previousProviderOrigin = previousProvider.getMetadata().getOrigin();
                String typeMessage = previousProvider.getClass().equals(provider.getClass()) ? " (type: " + previousProviderOrigin + " and " + currentProviderOrigin + ")" : " (types: " + Proxies.unwrapProxyClassName(previousProvider.getClass()) + " at " + previousProviderOrigin + " and " + Proxies.unwrapProxyClassName(provider.getClass()) + " at " + currentProviderOrigin + ")";
                throw new WindupException("Found two providers with the same id: " + provider.getMetadata().getID() + typeMessage);
            }
            duplicates.put(provider, provider);
        }
    }

    private void printRulePhases(List<RuleProvider> allProviders) {
        ArrayList<RuleProvider> unsortedPhases = new ArrayList<RuleProvider>();
        for (RuleProvider provider : allProviders) {
            if (!(provider instanceof RulePhase)) continue;
            unsortedPhases.add(provider);
        }
        List<RuleProvider> sortedPhases = RuleProviderSorter.sort(unsortedPhases);
        StringBuilder rulePhaseSB = new StringBuilder();
        for (RuleProvider phase : sortedPhases) {
            Class<?> unproxiedClass = Proxies.unwrap((Object)phase).getClass();
            rulePhaseSB.append("\tPhase: ").append(unproxiedClass.getSimpleName()).append(System.lineSeparator());
        }
        LOG.info("Rule Phases: [\n" + rulePhaseSB.toString() + "]");
    }

    private Map<RuleKey, OverrideRule> extractOverrideRules(List<RuleProvider> providers, RuleLoaderContext ruleLoaderContext) {
        HashMap<RuleKey, OverrideRule> overrideRules = new HashMap<RuleKey, OverrideRule>();
        providers.stream().filter(provider -> provider.getMetadata().isOverrideProvider()).filter(provider -> ruleLoaderContext.getRuleProviderFilter() == null || ruleLoaderContext.getRuleProviderFilter().accept(provider)).forEach(provider -> provider.getConfiguration(null).getRules().forEach(rule -> {
            RuleKey ruleKey = new RuleKey(provider.getMetadata().getID(), rule.getId());
            overrideRules.put(ruleKey, new OverrideRule((Rule)rule));
        }));
        return overrideRules;
    }

    private List<Rule> overrideRules(Configuration cfg, Map<RuleKey, OverrideRule> overrideRules, RuleProvider provider) {
        ArrayList<Rule> rules = new ArrayList<Rule>(cfg.getRules());
        ListIterator ruleIterator = rules.listIterator();
        while (ruleIterator.hasNext()) {
            Rule rule = (Rule)ruleIterator.next();
            OverrideRule overrideRule = overrideRules.get(new RuleKey(provider.getMetadata().getID(), rule.getId()));
            Optional.ofNullable(overrideRule).ifPresent(r -> {
                LOG.info("Replacing rule " + rule.getId() + " with a user override!");
                ruleIterator.set(r.getRule());
                r.setUsed(true);
            });
        }
        return rules;
    }

    private void injectParametersIntoRule(Rule rule) {
        ParameterizedCallback callback = parameterized -> {
            Set names = parameterized.getRequiredParameterNames();
            ParameterStore store = ((ParameterizedRule)rule).getParameterStore();
            if (names != null) {
                for (String name : names) {
                    Parameter parameter = store.get(name, (Parameter)new DefaultParameter(name));
                    if (!(parameter instanceof ConfigurableParameter)) continue;
                    ((ConfigurableParameter)parameter).bindsTo((Binding)Evaluation.property((String)name));
                }
            }
            parameterized.setParameterStore(store);
        };
        ParameterizedConditionVisitor conditionVisitor = new ParameterizedConditionVisitor(callback);
        new ConditionVisit((Condition)rule).accept((Visitor)conditionVisitor);
        ParameterizedOperationVisitor operationVisitor = new ParameterizedOperationVisitor(callback);
        new OperationVisit((Operation)rule).accept((Visitor)operationVisitor);
    }

    private String generatedRuleID(RuleProvider provider, int idx) {
        return String.format("%s_%s", provider.getMetadata().getID(), idx);
    }
}

