/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class XSLDocument
extends StyleElement {
    private int validationAction = 4;
    private SchemaType schemaType = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String validationAtt = null;
        String typeAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("validation")) {
                validationAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("type")) {
                typeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        this.validationAction = validationAtt == null ? this.getDefaultValidation() : this.validateValidationAttribute(validationAtt);
        if (typeAtt != null) {
            if (!this.isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.schemaType = this.getSchemaType(typeAtt);
            this.validationAction = 8;
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        DocumentInstr inst = new DocumentInstr(false, null);
        inst.setValidationAction(this.validationAction, this.schemaType);
        Expression b = this.compileSequenceConstructor(exec, decl, true);
        if (b == null) {
            b = Literal.makeEmptySequence();
        }
        inst.setContentExpression(b);
        return inst;
    }
}

