/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;
import java.util.Collections;

public abstract class SSAInstruction {
    public static final int NO_INDEX = -1;
    private int instructionIndex;

    protected SSAInstruction(int iindex) {
        this.instructionIndex = iindex;
    }

    public abstract SSAInstruction copyForSSA(SSAInstructionFactory var1, int[] var2, int[] var3);

    public abstract String toString(SymbolTable var1);

    public String toString() {
        return this.toString(null);
    }

    protected String getValueString(SymbolTable symbolTable, int valueNumber) {
        if (symbolTable == null) {
            return Integer.toString(valueNumber);
        }
        return symbolTable.getValueString(valueNumber);
    }

    public abstract void visit(IVisitor var1);

    public boolean hasDef() {
        return false;
    }

    public int getDef() {
        return -1;
    }

    public int getDef(int i) {
        return -1;
    }

    public int getNumberOfDefs() {
        return 0;
    }

    public int getNumberOfUses() {
        return 0;
    }

    public int getUse(int j) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public abstract int hashCode();

    public boolean isPEI() {
        return false;
    }

    public Collection<TypeReference> getExceptionTypes() {
        assert (!this.isPEI());
        return Collections.emptySet();
    }

    public abstract boolean isFallThrough();

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof SSAInstruction) {
            return this.instructionIndex == ((SSAInstruction)obj).instructionIndex;
        }
        return false;
    }

    public int iIndex() {
        return this.instructionIndex;
    }

    public void setInstructionIndex(int instructionIndex) {
        this.instructionIndex = instructionIndex;
    }

    public static abstract class Visitor
    implements IVisitor {
        @Override
        public void visitGoto(SSAGotoInstruction instruction) {
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
        }

        @Override
        public void visitBinaryOp(SSABinaryOpInstruction instruction) {
        }

        @Override
        public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
        }

        @Override
        public void visitConversion(SSAConversionInstruction instruction) {
        }

        @Override
        public void visitComparison(SSAComparisonInstruction instruction) {
        }

        @Override
        public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
        }

        @Override
        public void visitSwitch(SSASwitchInstruction instruction) {
        }

        @Override
        public void visitReturn(SSAReturnInstruction instruction) {
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction instruction) {
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
        }

        @Override
        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
        }

        @Override
        public void visitThrow(SSAThrowInstruction instruction) {
        }

        @Override
        public void visitMonitor(SSAMonitorInstruction instruction) {
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction instruction) {
        }

        @Override
        public void visitInstanceof(SSAInstanceofInstruction instruction) {
        }

        @Override
        public void visitPhi(SSAPhiInstruction instruction) {
        }

        @Override
        public void visitPi(SSAPiInstruction instruction) {
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
        }

        @Override
        public void visitLoadMetadata(SSALoadMetadataInstruction instruction) {
        }
    }

    public static interface IVisitor {
        default public void visitGoto(SSAGotoInstruction instruction) {
        }

        default public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
        }

        default public void visitArrayStore(SSAArrayStoreInstruction instruction) {
        }

        default public void visitBinaryOp(SSABinaryOpInstruction instruction) {
        }

        default public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
        }

        default public void visitConversion(SSAConversionInstruction instruction) {
        }

        default public void visitComparison(SSAComparisonInstruction instruction) {
        }

        default public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
        }

        default public void visitSwitch(SSASwitchInstruction instruction) {
        }

        default public void visitReturn(SSAReturnInstruction instruction) {
        }

        default public void visitGet(SSAGetInstruction instruction) {
        }

        default public void visitPut(SSAPutInstruction instruction) {
        }

        default public void visitInvoke(SSAInvokeInstruction instruction) {
        }

        default public void visitNew(SSANewInstruction instruction) {
        }

        default public void visitArrayLength(SSAArrayLengthInstruction instruction) {
        }

        default public void visitThrow(SSAThrowInstruction instruction) {
        }

        default public void visitMonitor(SSAMonitorInstruction instruction) {
        }

        default public void visitCheckCast(SSACheckCastInstruction instruction) {
        }

        default public void visitInstanceof(SSAInstanceofInstruction instruction) {
        }

        default public void visitPhi(SSAPhiInstruction instruction) {
        }

        default public void visitPi(SSAPiInstruction instruction) {
        }

        default public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
        }

        default public void visitLoadMetadata(SSALoadMetadataInstruction instruction) {
        }
    }
}

