/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;

public class ClassHierarchyMethodTargetSelector
implements MethodTargetSelector {
    private final IClassHierarchy classHierarchy;

    public ClassHierarchyMethodTargetSelector(IClassHierarchy cha) {
        this.classHierarchy = cha;
    }

    @Override
    public IMethod getCalleeTarget(CGNode caller, CallSiteReference call, IClass receiver) {
        IClass klass;
        if (call == null) {
            throw new IllegalArgumentException("call is null");
        }
        TypeReference targetType = call.getDeclaredTarget().getDeclaringClass();
        if (call.isDispatch()) {
            assert (receiver != null) : "null receiver for " + call;
            klass = receiver;
        } else if (call.isFixed()) {
            klass = this.classHierarchy.lookupClass(targetType);
            if (klass == null) {
                return null;
            }
        } else {
            return null;
        }
        return this.classHierarchy.resolveMethod(klass, call.getDeclaredTarget().getSelector());
    }

    public boolean mightReturnSyntheticMethod() {
        return false;
    }
}

