/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.FieldImpl;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JVMClass;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InnerClassesReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.SignatureReader;
import com.ibm.wala.shrikeCT.SourceFileReader;
import com.ibm.wala.shrikeCT.TypeAnnotationsReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.types.annotations.TypeAnnotation;
import com.ibm.wala.types.generics.ClassSignature;
import com.ibm.wala.types.generics.TypeSignature;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.shrike.ShrikeClassReaderHandle;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public final class ShrikeClass
extends JVMClass<IClassLoader> {
    static final boolean DEBUG = false;
    private final ShrikeClassReaderHandle reader;

    public ShrikeClass(ShrikeClassReaderHandle reader, IClassLoader loader, IClassHierarchy cha) throws InvalidClassFileException {
        super(loader, cha);
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        this.reader = reader;
        this.computeTypeReference();
        this.hashCode = 2161 * this.getReference().hashCode();
        this.computeSuperName();
        this.computeModifiers();
        this.computeInterfaceNames();
        this.computeFields();
    }

    private void computeFields() throws InvalidClassFileException {
        ClassReader cr = this.reader.get();
        int fieldCount = cr.getFieldCount();
        ArrayList<FieldImpl> instanceList = new ArrayList<FieldImpl>(fieldCount);
        ArrayList<FieldImpl> staticList = new ArrayList<FieldImpl>(fieldCount);
        try {
            for (int i = 0; i < fieldCount; ++i) {
                String signature;
                int accessFlags = cr.getFieldAccessFlags(i);
                Atom name = Atom.findOrCreateUnicodeAtom(cr.getFieldName(i));
                ImmutableByteArray b = ImmutableByteArray.make(cr.getFieldType(i));
                HashSet annotations = HashSetFactory.make();
                annotations.addAll(this.getRuntimeInvisibleAnnotations(i));
                annotations.addAll(this.getRuntimeVisibleAnnotations(i));
                annotations = annotations.isEmpty() ? null : annotations;
                HashSet typeAnnotations = HashSetFactory.make();
                typeAnnotations.addAll(this.getRuntimeInvisibleTypeAnnotations(i));
                typeAnnotations.addAll(this.getRuntimeVisibleTypeAnnotations(i));
                typeAnnotations = typeAnnotations.isEmpty() ? null : typeAnnotations;
                TypeSignature sig = null;
                SignatureReader signatureReader = this.getSignatureReader(i);
                if (signatureReader != null && (signature = signatureReader.getSignature()) != null) {
                    sig = TypeSignature.make(signature);
                }
                if ((accessFlags & 8) == 0) {
                    this.addFieldToList(instanceList, name, b, accessFlags, annotations, typeAnnotations, sig);
                    continue;
                }
                this.addFieldToList(staticList, name, b, accessFlags, annotations, typeAnnotations, sig);
            }
            this.instanceFields = instanceList.toArray(new IField[0]);
            this.staticFields = staticList.toArray(new IField[0]);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    private void computeModifiers() throws InvalidClassFileException {
        this.modifiers = this.reader.get().getAccessFlags();
    }

    private void computeSuperName() {
        try {
            String s = this.reader.get().getSuperName();
            if (s != null) {
                this.superName = ImmutableByteArray.make('L' + s);
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
    }

    private void computeInterfaceNames() {
        try {
            String[] s = this.reader.get().getInterfaceNames();
            this.interfaceNames = new ImmutableByteArray[s.length];
            Arrays.setAll(this.interfaceNames, i -> ImmutableByteArray.make('L' + s[i]));
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
    }

    protected ShrikeCTMethod[] computeDeclaredMethods() throws InvalidClassFileException {
        int methodCount = this.reader.get().getMethodCount();
        ShrikeCTMethod[] result = new ShrikeCTMethod[methodCount];
        for (int i = 0; i < methodCount; ++i) {
            ShrikeCTMethod m;
            result[i] = m = new ShrikeCTMethod(this, i);
        }
        return result;
    }

    private void computeTypeReference() throws InvalidClassFileException {
        String className = 'L' + this.reader.get().getName();
        ImmutableByteArray name = ImmutableByteArray.make(className);
        this.typeReference = TypeReference.findOrCreate(this.getClassLoader().getReference(), TypeName.findOrCreate(name));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShrikeClass) {
            return this.getReference().equals(((ShrikeClass)obj).getReference());
        }
        return false;
    }

    public ClassReader getReader() {
        try {
            return this.reader.get();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public void clearSoftCaches() {
        if (this.methodMap != null) {
            for (IMethod iMethod : this.getDeclaredMethods()) {
                ShrikeCTMethod m = (ShrikeCTMethod)iMethod;
                m.clearCaches();
            }
        }
        this.inheritCache = null;
        this.allInterfaces = null;
        this.reader.clear();
    }

    public Collection<Annotation> getRuntimeInvisibleAnnotations() throws InvalidClassFileException {
        return this.getAnnotations(true);
    }

    public Collection<Annotation> getRuntimeVisibleAnnotations() throws InvalidClassFileException {
        return this.getAnnotations(false);
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        HashSet result = HashSetFactory.make();
        try {
            result.addAll(this.getAnnotations(true));
            result.addAll(this.getAnnotations(false));
        }
        catch (InvalidClassFileException invalidClassFileException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Collection<Annotation> getAnnotations(boolean runtimeInvisible) throws InvalidClassFileException {
        AnnotationsReader r = this.getAnnotationsReader(runtimeInvisible);
        return Annotation.getAnnotationsFromReader(r, this.getClassLoader().getReference());
    }

    private AnnotationsReader getAnnotationsReader(boolean runtimeInvisable) throws InvalidClassFileException {
        ClassReader r = this.reader.get();
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        r.initClassAttributeIterator(attrs);
        return AnnotationsReader.getReaderForAnnotation((AnnotationsReader.AnnotationType)(runtimeInvisable ? AnnotationsReader.AnnotationType.RuntimeInvisibleAnnotations : AnnotationsReader.AnnotationType.RuntimeVisibleAnnotations), (ClassReader.AttrIterator)attrs);
    }

    public Collection<TypeAnnotation> getTypeAnnotations(boolean runtimeInvisible) throws InvalidClassFileException {
        TypeAnnotationsReader r = this.getTypeAnnotationsReader(runtimeInvisible);
        ClassLoaderReference clRef = this.getClassLoader().getReference();
        return TypeAnnotation.getTypeAnnotationsFromReader(r, TypeAnnotation.targetConverterAtClassFile(clRef), clRef);
    }

    private TypeAnnotationsReader getTypeAnnotationsReader(boolean runtimeInvisible) throws InvalidClassFileException {
        ClassReader r = this.reader.get();
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        r.initClassAttributeIterator(attrs);
        return TypeAnnotationsReader.getReaderForAnnotationAtClassfile((TypeAnnotationsReader.AnnotationType)(runtimeInvisible ? TypeAnnotationsReader.AnnotationType.RuntimeInvisibleTypeAnnotations : TypeAnnotationsReader.AnnotationType.RuntimeVisibleTypeAnnotations), (ClassReader.AttrIterator)attrs, (SignatureReader)this.getSignatureReader(-1));
    }

    static <T> T getReader(ClassReader.AttrIterator iter, String attrName, GetReader<T> reader) {
        try {
            while (iter.isValid()) {
                if (iter.getName().equals(attrName)) {
                    return reader.getReader(iter);
                }
                iter.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return null;
    }

    private InnerClassesReader getInnerClassesReader() throws InvalidClassFileException {
        ClassReader r = this.reader.get();
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        r.initClassAttributeIterator(attrs);
        InnerClassesReader result = null;
        try {
            while (attrs.isValid()) {
                if (attrs.getName().equals("InnerClasses")) {
                    result = new InnerClassesReader(attrs);
                    break;
                }
                attrs.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    SourceFileReader getSourceFileReader() {
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        this.getReader().initClassAttributeIterator(attrs);
        return ShrikeClass.getReader(attrs, "SourceFile", SourceFileReader::new);
    }

    private AnnotationsReader getFieldAnnotationsReader(boolean runtimeInvisible, int fieldIndex) throws InvalidClassFileException {
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.reader.get().initFieldAttributeIterator(fieldIndex, iter);
        return AnnotationsReader.getReaderForAnnotation((AnnotationsReader.AnnotationType)(runtimeInvisible ? AnnotationsReader.AnnotationType.RuntimeInvisibleAnnotations : AnnotationsReader.AnnotationType.RuntimeVisibleAnnotations), (ClassReader.AttrIterator)iter);
    }

    public Collection<Annotation> getRuntimeInvisibleAnnotations(int fieldIndex) throws InvalidClassFileException {
        return this.getFieldAnnotations(fieldIndex, true);
    }

    public Collection<Annotation> getRuntimeVisibleAnnotations(int fieldIndex) throws InvalidClassFileException {
        return this.getFieldAnnotations(fieldIndex, false);
    }

    protected Collection<Annotation> getFieldAnnotations(int fieldIndex, boolean runtimeInvisible) throws InvalidClassFileException {
        AnnotationsReader r = this.getFieldAnnotationsReader(runtimeInvisible, fieldIndex);
        return Annotation.getAnnotationsFromReader(r, this.getClassLoader().getReference());
    }

    private TypeAnnotationsReader getFieldTypeAnnotationsReader(boolean runtimeInvisible, int fieldIndex) throws InvalidClassFileException {
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.reader.get().initFieldAttributeIterator(fieldIndex, iter);
        return TypeAnnotationsReader.getReaderForAnnotationAtFieldInfo((TypeAnnotationsReader.AnnotationType)(runtimeInvisible ? TypeAnnotationsReader.AnnotationType.RuntimeInvisibleTypeAnnotations : TypeAnnotationsReader.AnnotationType.RuntimeVisibleTypeAnnotations), (ClassReader.AttrIterator)iter);
    }

    public Collection<TypeAnnotation> getRuntimeInvisibleTypeAnnotations(int fieldIndex) throws InvalidClassFileException {
        return this.getFieldTypeAnnotations(fieldIndex, true);
    }

    public Collection<TypeAnnotation> getRuntimeVisibleTypeAnnotations(int fieldIndex) throws InvalidClassFileException {
        return this.getFieldTypeAnnotations(fieldIndex, false);
    }

    protected Collection<TypeAnnotation> getFieldTypeAnnotations(int fieldIndex, boolean runtimeInvisible) throws InvalidClassFileException {
        TypeAnnotationsReader r = this.getFieldTypeAnnotationsReader(runtimeInvisible, fieldIndex);
        ClassLoaderReference clRef = this.getClassLoader().getReference();
        return TypeAnnotation.getTypeAnnotationsFromReader(r, TypeAnnotation.targetConverterAtFieldInfo(), clRef);
    }

    private SignatureReader getSignatureReader(int index) throws InvalidClassFileException {
        ClassReader r = this.reader.get();
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        if (index == -1) {
            r.initClassAttributeIterator(attrs);
        } else {
            r.initFieldAttributeIterator(index, attrs);
        }
        SignatureReader result = null;
        try {
            while (attrs.isValid()) {
                if (attrs.getName().equals("Signature")) {
                    result = new SignatureReader(attrs);
                    break;
                }
                attrs.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    public ClassSignature getClassSignature() throws InvalidClassFileException {
        SignatureReader r = this.getSignatureReader(-1);
        if (r == null) {
            return null;
        }
        return ClassSignature.make(r.getSignature());
    }

    public ModuleEntry getModuleEntry() {
        return this.reader.getModuleEntry();
    }

    public boolean isInnerClass() throws InvalidClassFileException {
        InnerClassesReader r = this.getInnerClassesReader();
        if (r != null) {
            for (String s : r.getInnerClasses()) {
                if (!s.equals(this.getName().toString().substring(1))) continue;
                String outer = r.getOuterClass(s);
                return outer != null;
            }
        }
        return false;
    }

    public boolean isStaticInnerClass() throws InvalidClassFileException {
        InnerClassesReader r = this.getInnerClassesReader();
        if (r != null) {
            for (String s : r.getInnerClasses()) {
                String outer;
                if (!s.equals(this.getName().toString().substring(1)) || (outer = r.getOuterClass(s)) == null) continue;
                int modifiers = r.getAccessFlags(s);
                boolean result = (modifiers & 8) != 0;
                return result;
            }
        }
        return false;
    }

    public TypeReference getOuterClass() throws InvalidClassFileException {
        if (!this.isInnerClass()) {
            return null;
        }
        InnerClassesReader r = this.getInnerClassesReader();
        for (String s : r.getInnerClasses()) {
            String outer;
            if (!s.equals(this.getName().toString().substring(1)) || (outer = r.getOuterClass(s)) == null) continue;
            return TypeReference.findOrCreate(this.getClassLoader().getReference(), 'L' + outer);
        }
        return null;
    }

    @Override
    public Module getContainer() {
        return this.reader.getModuleEntry().getContainer();
    }

    static interface GetReader<T> {
        public T getReader(ClassReader.AttrIterator var1) throws InvalidClassFileException;
    }
}

