/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.cdg;

import com.ibm.wala.cfg.MinimalCFG;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.dominators.DominanceFrontiers;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ControlDependenceGraph<T>
extends AbstractNumberedGraph<T> {
    private final MinimalCFG<T> cfg;
    private final NumberedEdgeManager<T> edgeManager;
    private Map<Pair<T, T>, Set<? extends Object>> edgeLabels;

    private Map<T, Set<T>> buildControlDependence(boolean wantEdgeLabels) {
        HashMap controlDependence = HashMapFactory.make((int)this.cfg.getNumberOfNodes());
        DominanceFrontiers RDF = new DominanceFrontiers((Graph)GraphInverter.invert(this.cfg), this.cfg.exit());
        if (wantEdgeLabels) {
            this.edgeLabels = HashMapFactory.make();
        }
        Iterator iterator = this.cfg.iterator();
        while (iterator.hasNext()) {
            Object name = iterator.next();
            HashSet s = HashSetFactory.make((int)2);
            controlDependence.put(name, s);
        }
        iterator = this.cfg.iterator();
        while (iterator.hasNext()) {
            Object y = iterator.next();
            for (Object x : Iterator2Iterable.make((Iterator)RDF.getDominanceFrontier(y))) {
                ((Set)controlDependence.get(x)).add(y);
                if (!wantEdgeLabels) continue;
                HashSet labels = HashSetFactory.make();
                this.edgeLabels.put(Pair.make(x, y), labels);
                for (Object s : Iterator2Iterable.make((Iterator)this.cfg.getSuccNodes(x))) {
                    if (!RDF.isDominatedBy(s, y)) continue;
                    labels.add(this.makeEdgeLabel(x, y, s));
                }
            }
        }
        return controlDependence;
    }

    protected Object makeEdgeLabel(T from, T to, T s) {
        return s;
    }

    private NumberedEdgeManager<T> constructGraphEdges(final Map<T, Set<T>> forwardEdges) {
        return new NumberedEdgeManager<T>(){
            final Map<T, Set<T>> backwardEdges;
            {
                this.backwardEdges = HashMapFactory.make((int)forwardEdges.size());
                Iterator iterator = ControlDependenceGraph.this.cfg.iterator();
                while (iterator.hasNext()) {
                    Object name = iterator.next();
                    HashSet s = HashSetFactory.make();
                    this.backwardEdges.put(name, s);
                }
                for (Map.Entry entry : forwardEdges.entrySet()) {
                    Iterator iterator2 = ((Set)entry.getValue()).iterator();
                    while (iterator2.hasNext()) {
                        Object t;
                        Object n = t = iterator2.next();
                        this.backwardEdges.get(n).add(entry.getKey());
                    }
                }
            }

            public Iterator<T> getPredNodes(T N) {
                if (this.backwardEdges.containsKey(N)) {
                    return this.backwardEdges.get(N).iterator();
                }
                return EmptyIterator.instance();
            }

            public IntSet getPredNodeNumbers(T node) {
                MutableIntSet x = IntSetUtil.make();
                if (this.backwardEdges.containsKey(node)) {
                    for (Object pred : this.backwardEdges.get(node)) {
                        x.add(ControlDependenceGraph.this.cfg.getNumber(pred));
                    }
                }
                return x;
            }

            public int getPredNodeCount(T N) {
                if (this.backwardEdges.containsKey(N)) {
                    return this.backwardEdges.get(N).size();
                }
                return 0;
            }

            public Iterator<T> getSuccNodes(T N) {
                if (forwardEdges.containsKey(N)) {
                    return ((Set)forwardEdges.get(N)).iterator();
                }
                return EmptyIterator.instance();
            }

            public IntSet getSuccNodeNumbers(T node) {
                MutableIntSet x = IntSetUtil.make();
                if (forwardEdges.containsKey(node)) {
                    for (Object succ : (Set)forwardEdges.get(node)) {
                        x.add(ControlDependenceGraph.this.cfg.getNumber(succ));
                    }
                }
                return x;
            }

            public int getSuccNodeCount(T N) {
                if (forwardEdges.containsKey(N)) {
                    return ((Set)forwardEdges.get(N)).size();
                }
                return 0;
            }

            public boolean hasEdge(T src, T dst) {
                return forwardEdges.containsKey(src) && ((Set)forwardEdges.get(src)).contains(dst);
            }

            public void addEdge(T src, T dst) {
                throw new UnsupportedOperationException();
            }

            public void removeEdge(T src, T dst) {
                throw new UnsupportedOperationException();
            }

            public void removeAllIncidentEdges(T node) {
                throw new UnsupportedOperationException();
            }

            public void removeIncomingEdges(T node) {
                throw new UnsupportedOperationException();
            }

            public void removeOutgoingEdges(T node) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object n = iterator.next();
            sb.append(n.toString()).append('\n');
            for (Object s : Iterator2Iterable.make((Iterator)this.getSuccNodes(n))) {
                sb.append("  --> ").append(s);
                if (this.edgeLabels != null) {
                    for (Object object : this.edgeLabels.get(Pair.make(n, s))) {
                        sb.append("\n   label: ").append(object);
                    }
                }
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public ControlDependenceGraph(MinimalCFG<T> cfg, boolean wantEdgeLabels) {
        if (cfg == null) {
            throw new IllegalArgumentException("null cfg");
        }
        this.cfg = cfg;
        this.edgeManager = this.constructGraphEdges(this.buildControlDependence(wantEdgeLabels));
    }

    public ControlDependenceGraph(MinimalCFG<T> cfg) {
        this(cfg, false);
    }

    public MinimalCFG<T> getControlFlowGraph() {
        return this.cfg;
    }

    public Set<? extends Object> getEdgeLabels(T from, T to) {
        return this.edgeLabels.get(Pair.make(from, to));
    }

    public NumberedNodeManager<T> getNodeManager() {
        return this.cfg;
    }

    public NumberedEdgeManager<T> getEdgeManager() {
        return this.edgeManager;
    }

    public boolean controlEquivalent(T bb1, T bb2) {
        if (this.getPredNodeCount(bb1) != this.getPredNodeCount(bb2)) {
            return false;
        }
        for (Object pb : Iterator2Iterable.make((Iterator)this.getPredNodes(bb1))) {
            if (this.hasEdge(pb, bb2)) continue;
            return false;
        }
        return true;
    }
}

